/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.functional;

import ch.awae.utils.functional.FailableFunction0;
import ch.awae.utils.functional.FailableFunction1;
import ch.awae.utils.functional.Failure;
import ch.awae.utils.functional.Success;
import java.util.function.Function;

public interface Try<T> {
    public boolean isSuccess();

    default public boolean isFailure() {
        return !this.isSuccess();
    }

    public T get() throws Throwable;

    public Throwable getFailure();

    public <S> Try<S> map(FailableFunction1<T, S> var1);

    public <S> Try<S> flatMap(Function<T, Try<S>> var1);

    public Try<T> recover(FailableFunction1<Throwable, Try<T>> var1);

    public static <T> Try<T> success(T value) {
        return new Success<T>(value);
    }

    public static <T> Try<T> failure(Throwable throwable) {
        return new Failure(throwable);
    }

    public static <T> Try<T> of(FailableFunction0<T> f) {
        try {
            return Try.success(f.apply());
        }
        catch (Throwable t) {
            return Try.failure(t);
        }
    }
}

