/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.logic;

import ch.awae.utils.logic.EdgeLogic;
import ch.awae.utils.logic.LogicCluster;
import ch.awae.utils.logic.NotLogic;
import java.util.Objects;
import java.util.function.BooleanSupplier;

@FunctionalInterface
public interface Logic {
    public static final Logic TRUE = () -> true;
    public static final Logic FALSE = () -> false;

    public static LogicCluster cluster(Logic ... elements) {
        return new LogicCluster(elements);
    }

    public boolean evaluate();

    default public void test(Runnable handler) {
        Objects.requireNonNull(handler);
        if (this.evaluate()) {
            handler.run();
        }
    }

    default public Logic not() {
        return new NotLogic(this);
    }

    default public Logic and(Logic other) {
        Objects.requireNonNull(other, "the 'other' instance may not be null!");
        return Logic.and(this, other);
    }

    default public Logic or(Logic other) {
        Objects.requireNonNull(other, "the 'other' instance may not be null!");
        return Logic.or(this, other);
    }

    default public Logic edge() {
        return new EdgeLogic(this);
    }

    public static Logic from(BooleanSupplier f) {
        Objects.requireNonNull(f, "no parameter may be null!");
        return () -> f.getAsBoolean();
    }

    public static Logic or(Logic logic0, Logic ... logics) {
        Objects.requireNonNull(logic0, "no logic instance may be null!");
        Objects.requireNonNull(logics, "the logics array may not be null!");
        for (Logic l : logics) {
            Objects.requireNonNull(l, "no logic instance may be null!");
        }
        if (logics.length == 0) {
            throw new IllegalArgumentException("logics array may not be empty!");
        }
        return () -> {
            if (logic0.evaluate()) {
                return true;
            }
            for (Logic logic : logics) {
                if (!logic.evaluate()) continue;
                return true;
            }
            return false;
        };
    }

    public static Logic and(Logic logic0, Logic ... logics) {
        Objects.requireNonNull(logic0, "no logic instance may be null!");
        Objects.requireNonNull(logics, "the logics array may not be null!");
        for (Logic l : logics) {
            Objects.requireNonNull(l, "no logic instance may be null!");
        }
        if (logics.length == 0) {
            throw new IllegalArgumentException("logics array may not be empty!");
        }
        return () -> {
            if (!logic0.evaluate()) {
                return false;
            }
            for (Logic logic : logics) {
                if (logic.evaluate()) continue;
                return false;
            }
            return true;
        };
    }

    public static Logic count(int target, Logic ... logics) {
        Objects.requireNonNull(logics, "the logics array may not be null!");
        for (Logic l : logics) {
            Objects.requireNonNull(l, "no logic instance may be null!");
        }
        if (logics.length == 0) {
            throw new IllegalArgumentException("logics array may not be empty!");
        }
        if (target < 0) {
            throw new IllegalArgumentException("the target value may not be negative!");
        }
        if (target > logics.length) {
            throw new IllegalArgumentException("the target value may not exceed the size of the logics array");
        }
        return () -> {
            int counter = 0;
            for (Logic logic : logics) {
                if (!logic.evaluate()) continue;
                ++counter;
            }
            return counter == target;
        };
    }

    public static Logic none(Logic ... logics) {
        return Logic.any(logics).not();
    }

    public static Logic all(Logic ... logics) {
        return Logic.and(TRUE, logics);
    }

    public static Logic any(Logic ... logics) {
        return Logic.or(FALSE, logics);
    }

    public static Logic not(Logic logic) {
        return logic.not();
    }

    public static Logic edge(Logic logic) {
        return logic.edge();
    }
}

