/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.statemachine;

import ch.awae.utils.statemachine.Command;
import ch.awae.utils.statemachine.CommandType;
import ch.awae.utils.statemachine.MachineCore;
import ch.awae.utils.statemachine.Transition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;

public final class MachineCoreBuilder {
    private ArrayList<Transition> transitions = new ArrayList();
    private String initialState = null;
    private boolean allowTerminal = false;
    private boolean checkTerminal = true;
    private final Object LOCK = new Object();

    public MachineCoreBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineCoreBuilder(MachineCoreBuilder builder) {
        Objects.requireNonNull(builder);
        this.checkTerminal = builder.checkTerminal;
        this.initialState = builder.initialState;
        this.allowTerminal = builder.allowTerminal;
        Object object = builder.LOCK;
        synchronized (object) {
            this.transitions.addAll(builder.transitions);
        }
    }

    public MachineCoreBuilder setCheckForTerminalStates(boolean check) {
        this.checkTerminal = check;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineCoreBuilder addTransition(String from, String event, String to, String[] events, String[] commands) {
        int i;
        if (events == null) {
            return this.addTransition(from, event, to, new String[0], commands);
        }
        if (commands == null) {
            return this.addTransition(from, event, to, events, new String[0]);
        }
        Objects.requireNonNull(from, "'from' may not be null");
        Objects.requireNonNull(event, "'event' may not be null");
        Objects.requireNonNull(commands, "'commands' may not be null");
        Command[] cmds = new Command[events.length + commands.length];
        for (i = 0; i < events.length; ++i) {
            cmds[i] = new Command(CommandType.EVENT, Objects.requireNonNull(events[i], "'events[" + i + "]' may not be null"));
        }
        for (i = 0; i < commands.length; ++i) {
            cmds[i + events.length] = new Command(CommandType.COMMAND, Objects.requireNonNull(commands[i], "'commands[" + i + "]' may not be null"));
        }
        Transition transition = new Transition(from, event, to, cmds);
        Object object = this.LOCK;
        synchronized (object) {
            this.transitions.add(transition);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineCoreBuilder addFunnel(String[] from, String event, String to, String[] events, String[] commands) {
        int i;
        if (events == null) {
            return this.addFunnel(from, event, to, new String[0], commands);
        }
        if (commands == null) {
            return this.addFunnel(from, event, to, events, new String[0]);
        }
        Objects.requireNonNull(from, "'from' may not be null");
        Objects.requireNonNull(event, "'event' may not be null");
        Objects.requireNonNull(commands, "'commands' may not be null");
        if (from.length == 0) {
            throw new IllegalArgumentException("empty 'from' array is not allowed");
        }
        for (int i2 = 0; i2 < from.length; ++i2) {
            Objects.requireNonNull(from[i2], "'from[" + i2 + "]' may not be null");
        }
        Command[] cmds = new Command[events.length + commands.length];
        for (i = 0; i < events.length; ++i) {
            cmds[i] = new Command(CommandType.EVENT, Objects.requireNonNull(events[i], "'events[" + i + "]' may not be null"));
        }
        for (i = 0; i < commands.length; ++i) {
            cmds[i + events.length] = new Command(CommandType.COMMAND, Objects.requireNonNull(commands[i], "'commands[" + i + "]' may not be null"));
        }
        for (String state : from) {
            Transition transition = new Transition(state, event, to, cmds);
            Object object = this.LOCK;
            synchronized (object) {
                this.transitions.add(transition);
            }
        }
        return this;
    }

    public MachineCoreBuilder setAllowTerminalStates(boolean allow) {
        this.allowTerminal = allow;
        return this;
    }

    public String[] addSequence(String from, String[] sequence, String to, String[] events, String[] commands) {
        if (events == null) {
            return this.addSequence(from, sequence, to, new String[0], commands);
        }
        if (commands == null) {
            return this.addSequence(from, sequence, to, events, new String[0]);
        }
        Objects.requireNonNull(from, "'from' may not be null");
        Objects.requireNonNull(sequence, "'seqence' may not be null");
        Objects.requireNonNull(commands, "'commands' may not be null");
        if (sequence.length == 0) {
            throw new IllegalArgumentException("empty sequence is not allowed");
        }
        for (int i = 0; i < sequence.length; ++i) {
            Objects.requireNonNull(sequence[i], "'sequence[" + i + "]' may not be null");
        }
        if (sequence.length == 1) {
            this.addTransition(from, sequence[0], to, events, commands);
            return new String[0];
        }
        String[] states = new String[sequence.length - 1];
        String state = from;
        for (int i = 0; i < sequence.length - 1; ++i) {
            String uuid = UUID.randomUUID().toString();
            this.addTransition(state, sequence[i], uuid, null, null);
            states[i] = state = uuid;
        }
        this.addTransition(state, sequence[sequence.length - 1], to, events, commands);
        return states;
    }

    public MachineCoreBuilder setInitialState(String state) {
        this.initialState = Objects.requireNonNull(state, "'state' may not be null");
        return this;
    }

    public MachineCoreBuilder addArbitrarySequence(String from, String[] sequence, String to, String[] events, String[] commands) {
        if (events == null) {
            return this.addArbitrarySequence(from, sequence, to, new String[0], commands);
        }
        if (commands == null) {
            return this.addArbitrarySequence(from, sequence, to, events, new String[0]);
        }
        Objects.requireNonNull(from, "'from' may not be null");
        Objects.requireNonNull(sequence, "'seqence' may not be null");
        Objects.requireNonNull(commands, "'commands' may not be null");
        if (sequence.length == 0) {
            throw new IllegalArgumentException("empty sequence is not allowed");
        }
        for (int i = 0; i < sequence.length; ++i) {
            Objects.requireNonNull(sequence[i], "'sequence[" + i + "]' may not be null");
        }
        if (sequence.length == 1) {
            return this.addTransition(from, sequence[0], to, events, commands);
        }
        for (String event : sequence) {
            String state = UUID.randomUUID().toString();
            ArrayList<String> remaining = new ArrayList<String>();
            remaining.addAll(Arrays.asList(sequence));
            remaining.remove(event);
            this.addTransition(from, event, state, null, null);
            this.addArbitrarySequence(state, remaining.toArray(new String[0]), to, events, commands);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTarget(String origin, String event) {
        Object object = this.LOCK;
        synchronized (object) {
            for (Transition transition : this.transitions) {
                if (!transition.origin.equals(origin) || !transition.event.equals(event)) continue;
                return transition.target;
            }
        }
        return null;
    }

    public MachineCoreBuilder copy() {
        return new MachineCoreBuilder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MachineCore build(int id, String logname, Logger logger) {
        Object object = this.LOCK;
        synchronized (object) {
            return new MachineCore(id, logname, logger, !this.allowTerminal, this.checkTerminal, this.initialState, this.transitions.toArray(new Transition[0]));
        }
    }
}

