/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.statemachine;

import ch.awae.utils.statemachine.Command;
import ch.awae.utils.statemachine.MachineCore;
import ch.awae.utils.statemachine.StateMachine;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

final class StateMachineImpl
implements StateMachine {
    private final MachineCore[] cores;
    private final BlockingQueue<String> eventQueue;
    private final BlockingQueue<String> commandQueue;
    private final Object LOCK = new Object();
    private Thread worker = null;

    StateMachineImpl(MachineCore ... cores) {
        this.cores = Objects.requireNonNull(cores, "cores may not be null");
        for (int i = 0; i < cores.length; ++i) {
            Objects.requireNonNull(cores[i], "core[" + i + "] may not be null");
        }
        this.eventQueue = new LinkedBlockingQueue<String>();
        this.commandQueue = new LinkedBlockingQueue<String>();
    }

    @Override
    public void event(String event) {
        this.eventQueue.add(Objects.requireNonNull(event, "event may not be null"));
    }

    @Override
    public BlockingQueue<String> getCommandQueue() {
        return this.commandQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.worker != null) {
                throw new IllegalStateException("worker already running");
            }
            this.worker = new Thread(this::processingLoop);
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.worker == null) {
                throw new IllegalStateException("worker not running");
            }
            this.worker.interrupt();
            boolean interrupted = false;
            while (true) {
                try {
                    this.worker.join();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
            this.worker = null;
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean running;
            boolean bl = running = this.worker != null;
            if (running) {
                this.stop();
            }
            for (MachineCore core : this.cores) {
                core.reset();
            }
            this.eventQueue.clear();
            if (running) {
                this.start();
            }
        }
    }

    private void processingLoop() {
        try {
            while (!Thread.interrupted()) {
                String event = this.eventQueue.take();
                for (MachineCore core : this.cores) {
                    block8: for (Command command : core.processEvent(event)) {
                        switch (command.type) {
                            case EVENT: {
                                this.eventQueue.add(command.command);
                                continue block8;
                            }
                            case COMMAND: {
                                this.commandQueue.add(command.command);
                            }
                        }
                    }
                }
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }
}

