/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.statemachine;

import ch.awae.utils.statemachine.MachineCore;
import ch.awae.utils.statemachine.MachineCoreBuilder;
import ch.awae.utils.statemachine.StateMachine;
import ch.awae.utils.statemachine.StateMachineImpl;
import java.util.ArrayList;
import java.util.Objects;

public class StateMachineBuilder {
    private ArrayList<MachineCoreBuilder> cores = new ArrayList();

    public StateMachineBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateMachineBuilder(StateMachineBuilder builder) {
        Objects.requireNonNull(builder);
        ArrayList<MachineCoreBuilder> arrayList = builder.cores;
        synchronized (arrayList) {
            this.cores.addAll(builder.cores);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateMachineBuilder addMachineCore(MachineCoreBuilder builder) {
        Objects.requireNonNull(builder);
        MachineCoreBuilder bldr = builder.copy();
        ArrayList<MachineCoreBuilder> arrayList = this.cores;
        synchronized (arrayList) {
            this.cores.add(bldr);
        }
        return this;
    }

    public StateMachineBuilder copy() {
        return new StateMachineBuilder(this);
    }

    public StateMachine build() {
        MachineCore[] cores = new MachineCore[this.cores.size()];
        for (int i = 0; i < cores.length; ++i) {
            try {
                cores[i] = this.cores.get(i).build();
                continue;
            }
            catch (IllegalArgumentException | NullPointerException ex) {
                throw new IllegalArgumentException("core[" + i + "] could not be constructed:\n" + ex.getMessage(), ex);
            }
        }
        return new StateMachineImpl(cores);
    }
}

