/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.statemachine;

import ch.awae.utils.statemachine.Command;
import ch.awae.utils.statemachine.CommandType;
import ch.awae.utils.statemachine.MachineCore;
import ch.awae.utils.statemachine.Transition;
import java.util.ArrayList;
import java.util.Objects;

public final class MachineCoreBuilder {
    private ArrayList<Transition> transitions = new ArrayList();
    private String initialState = null;
    private final Object LOCK = new Object();

    public MachineCoreBuilder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineCoreBuilder(MachineCoreBuilder builder) {
        Objects.requireNonNull(builder);
        this.initialState = builder.initialState;
        Object object = builder.LOCK;
        synchronized (object) {
            this.transitions.addAll(builder.transitions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineCoreBuilder addTransition(String from, String event, String to, String[] events, String[] commands) {
        int i;
        if (events == null) {
            return this.addTransition(from, event, to, new String[0], commands);
        }
        if (commands == null) {
            return this.addTransition(from, event, to, events, new String[0]);
        }
        Objects.requireNonNull(from, "'from' may not be null");
        Objects.requireNonNull(event, "'event' may not be null");
        Objects.requireNonNull(commands, "'commands' may not be null");
        Command[] cmds = new Command[events.length + commands.length];
        for (i = 0; i < events.length; ++i) {
            cmds[i] = new Command(CommandType.EVENT, Objects.requireNonNull(events[i], "'events[" + i + "]' may not be null"));
        }
        for (i = 0; i < commands.length; ++i) {
            cmds[i + events.length] = new Command(CommandType.COMMAND, Objects.requireNonNull(commands[i], "'commands[" + i + "]' may not be null"));
        }
        Transition transition = new Transition(from, event, to, cmds);
        Object object = this.LOCK;
        synchronized (object) {
            this.transitions.add(transition);
        }
        return this;
    }

    public MachineCoreBuilder setInitialState(String state) {
        this.initialState = Objects.requireNonNull(state, "'state' may not be null");
        return this;
    }

    public MachineCoreBuilder copy() {
        return new MachineCoreBuilder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MachineCore build() {
        Object object = this.LOCK;
        synchronized (object) {
            return new MachineCore(this.initialState, this.transitions.toArray(new Transition[0]));
        }
    }
}

