/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils.statemachine;

import ch.awae.utils.statemachine.Command;
import ch.awae.utils.statemachine.Transition;
import java.util.HashMap;
import java.util.Objects;

final class MachineCore {
    private static final Command[] EMPTY_COMMAND_ARRAY = new Command[0];
    private final HashMap<String, HashMap<String, Transition>> map;
    private final String initialState;
    private String currentState;

    MachineCore(String initial, Transition ... transitions) {
        this.currentState = this.initialState = Objects.requireNonNull(initial, "initial may not be null");
        this.map = new HashMap();
        for (int i = 0; i < transitions.length; ++i) {
            HashMap<Object, Object> temp;
            Transition transition = Objects.requireNonNull(transitions[i], "transitions[" + i + "] may not be null");
            if (this.map.containsKey(transition.origin)) {
                temp = this.map.get(transition.origin);
            } else {
                temp = new HashMap();
                this.map.put(transition.origin, temp);
            }
            if (temp.containsKey(transition.event)) {
                throw new IllegalArgumentException("duplicate transition event '" + transition.event + "' on state '" + transition.origin + "'");
            }
            temp.put(transition.event, transition);
        }
        this.map.forEach((origin, map) -> map.forEach((event, transition) -> {
            if (!this.map.containsKey(transition.target)) {
                throw new IllegalArgumentException("transition '" + event + "' on state '" + origin + "' has unknown target state '" + transition.target + "'");
            }
        }));
        if (!this.map.containsKey(this.initialState)) {
            throw new IllegalArgumentException("unknown initial state '" + this.initialState + "'");
        }
    }

    synchronized Command[] processEvent(String event) {
        Transition transition = this.map.get(this.currentState).get(Objects.requireNonNull(event, "event may not be null"));
        if (transition == null) {
            return EMPTY_COMMAND_ARRAY;
        }
        this.currentState = transition.target;
        return transition.commands;
    }

    synchronized void reset() {
        this.currentState = this.initialState;
    }
}

