/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Trampoline {
    public static <T> Result<T> result(T value) {
        return new Result(true, value, null);
    }

    public static <T> Result<T> bounce(Supplier<Result<T>> f) {
        return new Result(false, null, f);
    }

    public static <T, A> Result<T> bounce(Function<A, Result<T>> f, A param0) {
        return new Result(false, null, () -> (Result)f.apply(param0));
    }

    public static <T, A, B> Result<T> bounce(BiFunction<A, B, Result<T>> f, A param0, B param1) {
        return new Result(false, null, () -> (Result)f.apply(param0, param1));
    }

    public static <T> Result<T> bounceWrapped(Supplier<T> f) {
        return new Result(false, null, () -> Trampoline.result(f.get()));
    }

    public static <T, A> Result<T> bounceWrapped(Function<A, T> f, A param0) {
        return new Result(false, null, () -> Trampoline.result(f.apply(param0)));
    }

    public static <T, A, B> Result<T> bounceWrapped(BiFunction<A, B, T> f, A param0, B param1) {
        return new Result(false, null, () -> Trampoline.result(f.apply(param0, param1)));
    }

    public static <T> T run(Result<T> result) {
        Result step = result;
        while (!step.isReturn()) {
            step = result.call();
        }
        return (T)step.get();
    }

    public static final class Result<T> {
        private final boolean isValue;
        private final T value;
        private final Supplier<Result<T>> supplier;

        private Result(boolean isValue, T value, Supplier<Result<T>> supplier) {
            this.isValue = isValue;
            this.value = isValue ? value : null;
            this.supplier = isValue ? null : supplier;
        }

        private final boolean isReturn() {
            return this.isValue;
        }

        private final T get() {
            if (this.isValue) {
                return this.value;
            }
            throw new UnsupportedOperationException();
        }

        private final Result<T> call() {
            if (this.isValue) {
                throw new UnsupportedOperationException();
            }
            return this.supplier.get();
        }
    }
}

