/*
 * Decompiled with CFR 0.152.
 */
package ch.awae.utils;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Trampoline {
    public static <T> Result<T> result(T value) {
        return new TrampolineValue<T>(value);
    }

    public static <T> Result<T> bounce(final Supplier<Result<T>> f) {
        return new Result<T>(){

            @Override
            Result<T> call() {
                return (Result)f.get();
            }
        };
    }

    public static <T, A> Result<T> bounce(final Function<A, Result<T>> f, final A param0) {
        return new Result<T>(){

            @Override
            Result<T> call() {
                return (Result)f.apply(param0);
            }
        };
    }

    public static <T, A, B> Result<T> bounce(final BiFunction<A, B, Result<T>> f, final A param0, final B param1) {
        return new Result<T>(){

            @Override
            Result<T> call() {
                return (Result)f.apply(param0, param1);
            }
        };
    }

    public static <T> Result<T> bounceWrapped(final Supplier<T> f) {
        return new Result<T>(){

            @Override
            Result<T> call() {
                return Trampoline.result(f.get());
            }
        };
    }

    public static <T, A> Result<T> bounceWrapped(final Function<A, T> f, final A param0) {
        return new Result<T>(){

            @Override
            Result<T> call() {
                return Trampoline.result(f.apply(param0));
            }
        };
    }

    public static <T, A, B> Result<T> bounceWrapped(final BiFunction<A, B, T> f, final A param0, final B param1) {
        return new Result<T>(){

            @Override
            Result<T> call() {
                return Trampoline.result(f.apply(param0, param1));
            }
        };
    }

    public static <T> T run(Result<T> result) {
        Result<T> step = result;
        while (!step.isReturn()) {
            step = result.call();
        }
        return step.get();
    }

    private static class TrampolineValue<T>
    extends Result<T> {
        private final T value;

        TrampolineValue(T value) {
            this.value = value;
        }

        @Override
        public boolean isReturn() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public Result<T> call() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class Result<T> {
        Result() {
        }

        boolean isReturn() {
            return false;
        }

        T get() {
            throw new UnsupportedOperationException();
        }

        abstract Result<T> call();
    }
}

