/*
 * Decompiled with CFR 0.152.
 */
package ch.artecat.jexler;

import ch.artecat.jexler.Jexler;
import ch.artecat.jexler.JexlerContainer;
import ch.artecat.jexler.service.ServiceState;
import ch.artecat.jexler.service.ServiceUtil;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class JexlerUtil
implements GroovyObject {
    public static final String STARTUP_TIMEOUT_MSG = "Timeout waiting for jexler startup.";
    public static final String SHUTDOWN_TIMEOUT_MSG = "Timeout waiting for jexler shutdown.";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public JexlerUtil() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static boolean waitForStartup(Jexler jexler, long timeout) {
        if (ServiceUtil.waitForStartup(jexler, timeout)) {
            return true;
        }
        jexler.trackIssue(jexler, STARTUP_TIMEOUT_MSG, null);
        return false;
    }

    public static boolean waitForShutdown(Jexler jexler, long timeout) {
        if (ServiceUtil.waitForShutdown(jexler, timeout)) {
            return true;
        }
        jexler.trackIssue(jexler, SHUTDOWN_TIMEOUT_MSG, null);
        return false;
    }

    public static boolean waitForStartup(JexlerContainer container, long timeout) {
        if (ServiceUtil.waitForStartup(container, timeout)) {
            return true;
        }
        Jexler jexler = null;
        Iterator<Jexler> iterator = container.getJexlers().iterator();
        while (iterator.hasNext()) {
            jexler = (Jexler)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Jexler.class);
            if (!ScriptBytecodeAdapter.compareEqual((Object)((Object)jexler.getState()), (Object)((Object)ServiceState.BUSY_STARTING))) continue;
            jexler.trackIssue(jexler, STARTUP_TIMEOUT_MSG, null);
        }
        return false;
    }

    public static boolean waitForShutdown(JexlerContainer container, long timeout) {
        if (ServiceUtil.waitForShutdown(container, timeout)) {
            return true;
        }
        Jexler jexler = null;
        Iterator<Jexler> iterator = container.getJexlers().iterator();
        while (iterator.hasNext()) {
            jexler = (Jexler)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Jexler.class);
            if (!ScriptBytecodeAdapter.compareNotEqual((Object)((Object)jexler.getState()), (Object)((Object)ServiceState.OFF))) continue;
            jexler.trackIssue(jexler, SHUTDOWN_TIMEOUT_MSG, null);
        }
        return false;
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter result = new StringWriter();
        throwable.printStackTrace(new PrintWriter(result));
        String string = ShortTypeHandling.castToString((Object)result);
        try {
            return string;
        }
        catch (RuntimeException ignore) {
            String string2 = "";
            return string2;
        }
    }

    public static String toSingleLine(String multi) {
        String string = multi;
        String string2 = string != null ? string.replace("\r\n", "%n") : null;
        String string3 = string2 != null ? string2.replace("\r", "%n") : null;
        return string3 != null ? string3.replace("\n", "%n") : null;
    }

    public static void waitAtLeast(long ms) {
        long t0 = System.currentTimeMillis();
        while (true) {
            long t1 = System.currentTimeMillis();
            if (t1 - t0 >= ms) {
                return;
            }
            try {
                Thread.sleep(ms - (t1 - t0));
            }
            catch (InterruptedException ignored) {
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JexlerUtil.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

