/*
 * Decompiled with CFR 0.152.
 */
package ch.artecat.jexler.tool;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class StringObfuscatorTool
implements GroovyObject {
    private static final int DEFAULT_BYTE_BUFFER_PAD_LEN = 64;
    private static final int MIN_SALT_LEN = 16;
    private static final int LEN_BYTES_LEN = 1;
    private SecretKeySpec key;
    private IvParameterSpec iv;
    private Cipher cipher;
    private int byteBufferPadLen;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public StringObfuscatorTool() throws NoSuchAlgorithmException, NoSuchPaddingException {
        int n;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.setParameters("62e0c45a20dfe429543212be640c3254", "b42de953243ab9edf03bdac61344bec5", "AES", "AES/CBC/PKCS5Padding");
        this.byteBufferPadLen = n = DEFAULT_BYTE_BUFFER_PAD_LEN;
    }

    public StringObfuscatorTool setParameters(String hexKey, String hexIv, String algorithm, String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher;
        IvParameterSpec ivParameterSpec;
        SecretKeySpec secretKeySpec;
        this.key = secretKeySpec = new SecretKeySpec(EncodingGroovyMethods.decodeHex((String)hexKey), algorithm);
        this.iv = ivParameterSpec = new IvParameterSpec(EncodingGroovyMethods.decodeHex((String)hexIv));
        this.cipher = cipher = Cipher.getInstance(transformation);
        return this;
    }

    public StringObfuscatorTool setByteBufferPadLen(int len) {
        int n;
        this.byteBufferPadLen = n = len;
        return this;
    }

    public String obfuscate(String plain) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidAlgorithmParameterException {
        byte[] plainBytes = plain.getBytes("UTF-8");
        int lenActual = plainBytes.length;
        int lenMaxAllowed = this.byteBufferPadLen - MIN_SALT_LEN - LEN_BYTES_LEN;
        if (lenActual > lenMaxAllowed) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{lenActual, lenMaxAllowed}, new String[]{"Input string too long (", " bytes UTF-8 encoded, max allowed: ", ")"})));
        }
        byte[] plainPaddedBytes = new byte[this.byteBufferPadLen];
        int lenSaltBytes = this.byteBufferPadLen - lenActual - LEN_BYTES_LEN;
        byte[] saltBytes = new byte[lenSaltBytes];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(saltBytes);
        System.arraycopy(saltBytes, 0, plainPaddedBytes, 0, lenSaltBytes);
        System.arraycopy(plainBytes, 0, plainPaddedBytes, lenSaltBytes, lenActual);
        byte by = (byte)lenActual;
        BytecodeInterface8.bArraySet((byte[])plainPaddedBytes, (int)(this.byteBufferPadLen - 1), (byte)by);
        this.cipher.init(Cipher.ENCRYPT_MODE, (Key)this.key, this.iv);
        byte[] enc = this.cipher.doFinal(plainPaddedBytes);
        return EncodingGroovyMethods.encodeHex((byte[])enc).toString();
    }

    public String deobfuscate(String encHex) throws InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException, InvalidAlgorithmParameterException {
        byte[] enc = EncodingGroovyMethods.decodeHex((String)encHex);
        this.cipher.init(Cipher.DECRYPT_MODE, (Key)this.key, this.iv);
        byte[] plain = this.cipher.doFinal(enc);
        if (plain.length != this.byteBufferPadLen) {
            throw (Throwable)new IllegalArgumentException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{plain.length, this.byteBufferPadLen}, new String[]{"Illegal length of deciphered buffer (", " bytes, expected ", ")"})));
        }
        int lenPlainBytes = BytecodeInterface8.bArrayGet((byte[])plain, (int)(this.byteBufferPadLen - 1)) & 0xFF;
        int offs = this.byteBufferPadLen - LEN_BYTES_LEN - lenPlainBytes;
        return new String(plain, offs, lenPlainBytes, "UTF-8");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StringObfuscatorTool.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

