/*
 * Decompiled with CFR 0.152.
 */
package ch.artecat.jexler.tool;

import ch.artecat.jexler.JexlerUtil;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class ShellTool
implements GroovyObject {
    private File workingDirectory;
    private Map<String, String> env;
    private Closure stdoutLineHandler;
    private Closure stderrLineHandler;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ShellTool() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public ShellTool setWorkingDirectory(File workingDirectory) {
        File file;
        this.workingDirectory = file = workingDirectory;
        return this;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ShellTool setEnvironment(Map<String, String> env) {
        Map<String, String> map = env;
        this.env = map;
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public ShellTool setStdoutLineHandler(Closure handler) {
        Closure closure;
        this.stdoutLineHandler = closure = handler;
        return this;
    }

    public Closure getStdoutLineHandler() {
        return this.stdoutLineHandler;
    }

    public ShellTool setStderrLineHandler(Closure handler) {
        Closure closure;
        this.stderrLineHandler = closure = handler;
        return this;
    }

    public Closure getStderrLineHandler() {
        return this.stderrLineHandler;
    }

    public Result run(String command) {
        Process proc = Runtime.getRuntime().exec(command, ShellTool.toEnvArray(this.env), this.workingDirectory);
        Result result = this.getResult(proc);
        try {
            return result;
        }
        catch (Exception e) {
            Result result2 = ShellTool.getExceptionResult(JexlerUtil.getStackTrace(e));
            return result2;
        }
    }

    public Result run(List<String> cmdList) {
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray((Object[])ScriptBytecodeAdapter.castToType((Object)cmdArray, Object[].class));
        Process proc = Runtime.getRuntime().exec(cmdArray, ShellTool.toEnvArray(this.env), this.workingDirectory);
        Result result = this.getResult(proc);
        try {
            return result;
        }
        catch (Exception e) {
            Result result2 = ShellTool.getExceptionResult(JexlerUtil.getStackTrace(e));
            return result2;
        }
    }

    private Result getResult(Process proc) throws Exception {
        OutputCollector outCollector = new OutputCollector(proc.getInputStream(), this.stdoutLineHandler, "stdout collector");
        OutputCollector errCollector = new OutputCollector(proc.getErrorStream(), this.stderrLineHandler, "stderr collector");
        outCollector.start();
        errCollector.start();
        int rc = proc.waitFor();
        outCollector.join();
        errCollector.join();
        return new Result(rc, outCollector.getOutput(), errCollector.getOutput());
    }

    private static Result getExceptionResult(String stackTrace) {
        return new Result(-1, "", stackTrace);
    }

    private static String[] toEnvArray(Map<String, String> env) {
        Reference envList = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        Map<String, String> map = env;
        public final class _toEnvArray_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference envList;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _toEnvArray_closure1(Object _outerInstance, Object _thisObject, Reference envList) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.envList = reference = envList;
            }

            public Object doCall(Object key, Object value) {
                return ((List)this.envList.get()).add(new GStringImpl(new Object[]{key, value}, new String[]{"", "=", ""}));
            }

            public Object call(Object key, Object value) {
                return this.doCall(key, value);
            }

            public List getEnvList() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.envList.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toEnvArray_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Map map2 = map != null ? DefaultGroovyMethods.each(map, (Closure)new _toEnvArray_closure1(ShellTool.class, ShellTool.class, envList)) : null;
        return (String[])ScriptBytecodeAdapter.asType((Object)((List)envList.get()), String[].class);
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ShellTool.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ShellTool.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ShellTool.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ShellTool.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static class Result
    implements GroovyObject {
        private final int rc;
        private final String stdout;
        private final String stderr;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public Result(int rc, String stdout, String stderr) {
            String string;
            String string2;
            int n;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.rc = n = rc;
            this.stdout = string2 = stdout;
            this.stderr = string = stderr;
        }

        public String toString() {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.rc, JexlerUtil.toSingleLine(this.stdout)}, new String[]{"[rc=", ",stdout='", "',"}).plus((GString)new GStringImpl(new Object[]{JexlerUtil.toSingleLine(this.stderr)}, new String[]{"stderr='", "']"})));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Result.class, ShellTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Result.class, ShellTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ShellTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ShellTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Result.class, ShellTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Result.class, ShellTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Result.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public final int getRc() {
            return this.rc;
        }

        @Generated
        public final String getStdout() {
            return this.stdout;
        }

        @Generated
        public final String getStderr() {
            return this.stderr;
        }
    }

    static class OutputCollector
    extends Thread
    implements GroovyObject {
        private final InputStream is;
        private final Closure lineHandler;
        private final String threadName;
        private String output;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public OutputCollector(InputStream is, Closure lineHandler, String threadName) {
            String string;
            Closure closure;
            InputStream inputStream;
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            this.is = inputStream = is;
            this.lineHandler = closure = lineHandler;
            this.threadName = string = threadName;
        }

        @Override
        public void run() {
            String string;
            String string2 = this.threadName;
            ((Thread)ScriptBytecodeAdapter.invokeStaticMethod0(OutputCollector.class, OutputCollector.class, (String)"currentThread")).setName(string2);
            StringBuilder out = new StringBuilder();
            Scanner scanner = new Scanner(this.is);
            while (scanner.hasNext()) {
                String line = scanner.nextLine();
                out.append(line);
                out.append(System.lineSeparator());
                if (!(this.lineHandler != null)) continue;
                this.lineHandler.call((Object)line);
            }
            scanner.close();
            this.output = string = out.toString();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(OutputCollector.class, ShellTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(OutputCollector.class, ShellTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ShellTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ShellTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(OutputCollector.class, ShellTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(OutputCollector.class, ShellTool.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != OutputCollector.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        @Generated
        public String getOutput() {
            return this.output;
        }

        @Generated
        public void setOutput(String string) {
            this.output = string;
        }
    }
}

