/*
 * Decompiled with CFR 0.152.
 */
package ch.artecat.jexler.service;

import ch.artecat.jexler.Jexler;
import ch.artecat.jexler.service.DirWatchEvent;
import ch.artecat.jexler.service.ServiceBase;
import ch.artecat.jexler.service.ServiceState;
import ch.artecat.jexler.service.ServiceUtil;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirWatchService
extends ServiceBase {
    private static final Logger LOG;
    private final Jexler jexler;
    private File dir;
    private List<WatchEvent.Kind<Path>> kinds;
    private List<WatchEvent.Modifier> modifiers;
    private String cron;
    private Scheduler scheduler;
    private TriggerKey triggerKey;
    private WatchService watchService;
    private WatchKey watchKey;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public DirWatchService(Jexler jexler, String id) {
        super(id);
        String string;
        List list;
        List list2;
        File file;
        Jexler jexler2;
        this.jexler = jexler2 = jexler;
        this.dir = file = jexler.getDir();
        this.kinds = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE});
        this.modifiers = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.cron = string = "*/5 * * * * ?";
    }

    public DirWatchService setDir(File dir) {
        File file;
        this.dir = file = dir;
        return this;
    }

    public File getDir() {
        return this.dir;
    }

    public DirWatchService setKinds(List<WatchEvent.Kind<Path>> kinds) {
        List<WatchEvent.Kind<Path>> list = kinds;
        this.kinds = list;
        return this;
    }

    public List<WatchEvent.Kind<Path>> getKinds() {
        return this.kinds;
    }

    public DirWatchService setModifiers(List<WatchEvent.Modifier> modifiers) {
        List<WatchEvent.Modifier> list = modifiers;
        this.modifiers = list;
        return this;
    }

    public List<WatchEvent.Modifier> getModifiers() {
        return this.modifiers;
    }

    public DirWatchService setCron(String cron) {
        String string;
        this.cron = string = ServiceUtil.toQuartzCron(cron);
        return this;
    }

    public String getCron() {
        return this.cron;
    }

    public DirWatchService setScheduler(Scheduler scheduler) {
        Scheduler scheduler2;
        this.scheduler = scheduler2 = scheduler;
        return this;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Jexler getJexler() {
        return this.jexler;
    }

    @Override
    public void start() {
        TriggerKey triggerKey;
        if (this.getState().isOn()) {
            return;
        }
        Path path = this.dir.toPath();
        try {
            WatchKey watchKey;
            WatchService watchService;
            this.watchService = watchService = path.getFileSystem().newWatchService();
            this.watchKey = watchKey = path.register(this.watchService, (WatchEvent.Kind[])ScriptBytecodeAdapter.asType(this.kinds, WatchEvent.Kind[].class), (WatchEvent.Modifier[])ScriptBytecodeAdapter.asType(this.modifiers, WatchEvent.Modifier[].class));
        }
        catch (IOException eCreate) {
            this.jexler.trackIssue(this, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.dir.getAbsolutePath()}, new String[]{"Could not create watch service or key for directory '", "'."})), eCreate);
            return;
        }
        String uuid = ShortTypeHandling.castToString((Object)UUID.randomUUID());
        JobDetail job = JobBuilder.newJob(DirWatchJob.class).withIdentity(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getId(), uuid}, new String[]{"job-", "-", ""})), this.jexler.getId()).usingJobData((JobDataMap)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"service", this}), JobDataMap.class)).build();
        CronTrigger trigger = (CronTrigger)ScriptBytecodeAdapter.castToType((Object)TriggerBuilder.newTrigger().withIdentity(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getId(), uuid}, new String[]{"trigger-", "-", ""})), this.jexler.getId()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cron)).startNow().build(), CronTrigger.class);
        this.triggerKey = triggerKey = trigger.getKey();
        if (this.scheduler == null) {
            Scheduler scheduler;
            this.scheduler = scheduler = this.jexler.getContainer().getScheduler();
        }
        this.scheduler.scheduleJob(job, (Trigger)trigger);
        ServiceState serviceState = ServiceState.IDLE;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)((Object)serviceState), DirWatchService.class, (GroovyObject)this, (String)"state");
    }

    @Override
    public void stop() {
        if (this.getState().isOff()) {
            return;
        }
        this.scheduler.unscheduleJob(this.triggerKey);
        this.watchKey.cancel();
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            LOG.trace("failed to close watch service", (Throwable)e);
        }
        ServiceState serviceState = ServiceState.OFF;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)((Object)serviceState), DirWatchService.class, (GroovyObject)this, (String)"state");
    }

    @Override
    public void zap() {
        if (this.getState().isOff()) {
            return;
        }
        ServiceState serviceState = ServiceState.OFF;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)((Object)serviceState), DirWatchService.class, (GroovyObject)this, (String)"state");
        new GroovyObject(this){
            public /* synthetic */ DirWatchService this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                DirWatchService dirWatchService;
                this.this$0 = dirWatchService = p0;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void run() {
                if (this.this$0.getScheduler() != null) {
                    try {
                        this.this$0.getScheduler().unscheduleJob(this.this$0.triggerKey);
                    }
                    catch (Throwable tUnschedule) {
                        LOG.trace("failed to unschedule cron job", tUnschedule);
                    }
                }
                try {
                    this.this$0.watchKey.cancel();
                    this.this$0.watchService.close();
                }
                catch (Throwable tStop) {
                    LOG.trace("failed stop watching directory", tStop);
                }
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$2(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, DirWatchService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$2(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, DirWatchService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$2(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, DirWatchService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }.start();
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(DirWatchService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, DirWatchService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(DirWatchService.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ Scheduler pfaccess$1(DirWatchService $that) {
        return $that.getScheduler();
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DirWatchService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        LOG = logger = LoggerFactory.getLogger(DirWatchService.class);
    }

    public static class DirWatchJob
    implements Job,
    GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public DirWatchJob() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public void execute(JobExecutionContext ctx) throws JobExecutionException {
            DirWatchService service = (DirWatchService)ScriptBytecodeAdapter.castToType(ctx.getJobDetail().getJobDataMap().get("service"), DirWatchService.class);
            String savedName = Thread.currentThread().getName();
            GStringImpl gStringImpl = new GStringImpl(new Object[]{service.getJexler().getId(), service.getId()}, new String[]{"", "|", ""});
            Thread.currentThread().setName(ShortTypeHandling.castToString((Object)gStringImpl));
            WatchEvent watchEvent = null;
            Iterator<WatchEvent<?>> iterator = service.watchKey.pollEvents().iterator();
            while (iterator.hasNext()) {
                watchEvent = (WatchEvent)ScriptBytecodeAdapter.castToType(iterator.next(), WatchEvent.class);
                Path contextPath = (Path)ScriptBytecodeAdapter.castToType(watchEvent.context(), Path.class);
                File file = new File(service.getDir(), contextPath.toFile().getName());
                WatchEvent.Kind<Path> kind = watchEvent.kind();
                LOG.trace(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{kind, file.getAbsolutePath()}, new String[]{"event ", " '", "'"})));
                service.getJexler().handle(new DirWatchEvent(service, file, kind));
            }
            String string = savedName;
            Thread.currentThread().setName(string);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DirWatchJob.class, DirWatchService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DirWatchJob.class, DirWatchService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DirWatchService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, DirWatchService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DirWatchJob.class, DirWatchService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DirWatchJob.class, DirWatchService.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != DirWatchJob.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

