/*
 * Decompiled with CFR 0.152.
 */
package ch.artecat.jexler;

import ch.artecat.grengine.Grengine;
import ch.artecat.grengine.code.CompilerFactory;
import ch.artecat.grengine.code.groovy.DefaultGroovyCompiler;
import ch.artecat.grengine.code.groovy.DefaultGroovyCompilerFactory;
import ch.artecat.grengine.engine.Engine;
import ch.artecat.grengine.engine.LayeredEngine;
import ch.artecat.grengine.except.GrengineException;
import ch.artecat.grengine.load.DefaultTopCodeCacheFactory;
import ch.artecat.grengine.load.LoadMode;
import ch.artecat.grengine.load.TopCodeCacheFactory;
import ch.artecat.grengine.source.DefaultSourceFactory;
import ch.artecat.grengine.source.SourceFactory;
import ch.artecat.grengine.sources.Sources;
import ch.artecat.jexler.Issue;
import ch.artecat.jexler.IssueTracker;
import ch.artecat.jexler.IssueTrackerBase;
import ch.artecat.jexler.Jexler;
import ch.artecat.jexler.JexlerContainerSources;
import ch.artecat.jexler.service.Service;
import ch.artecat.jexler.service.ServiceGroup;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.Closeable;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.quartz.Scheduler;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JexlerContainer
extends ServiceGroup
implements Service,
IssueTracker,
Closeable {
    private static final Logger LOG;
    private static final String EXT = ".groovy";
    private final File dir;
    private final Map<String, Jexler> jexlerMap;
    private final IssueTracker issueTracker;
    private Scheduler scheduler;
    private final Object schedulerLock;
    private Grengine grengine;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public JexlerContainer(File dir) {
        super(ShortTypeHandling.castToString((Object)(dir.exists() ? dir.getName() : null)));
        Grengine grengine;
        Object object;
        File file;
        if (!dir.exists()) {
            throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir.getAbsolutePath()}, new String[]{"Directory '", "' does not exist."})));
        }
        if (!dir.isDirectory()) {
            throw (Throwable)new RuntimeException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dir.getAbsolutePath()}, new String[]{"File '", "' is not a directory."})));
        }
        this.dir = file = dir;
        TreeMap<String, Jexler> treeMap = new TreeMap<String, Jexler>();
        this.jexlerMap = treeMap;
        IssueTrackerBase issueTrackerBase = new IssueTrackerBase();
        this.issueTracker = issueTrackerBase;
        this.schedulerLock = object = new Object();
        this.grengine = grengine = this.createGrengine();
    }

    public void refresh() {
        Map<String, Jexler> map = this.jexlerMap;
        synchronized (map) {
            File[] fileArray = this.dir.listFiles();
            public final class _refresh_closure1
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _refresh_closure1(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(File file) {
                    if (file.isFile() && !file.isHidden()) {
                        String id = ((JexlerContainer)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), JexlerContainer.class)).getJexlerId(file);
                        if (id != null && !((JexlerContainer)this.getThisObject()).jexlerMap.containsKey(id)) {
                            Jexler jexler = new Jexler(file, (JexlerContainer)this.getThisObject());
                            Jexler jexler2 = jexler;
                            DefaultGroovyMethods.putAt((Map)((Map)ScriptBytecodeAdapter.castToType((Object)this.getProperty("jexlerMap"), Map.class)), (Object)jexler.getId(), (Object)jexler2);
                            return jexler2;
                        }
                        return null;
                    }
                    return null;
                }

                public Object call(File file) {
                    return this.doCall(file);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _refresh_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            Object[] objectArray = fileArray != null ? DefaultGroovyMethods.each((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)fileArray, Object[].class)), (Closure)new _refresh_closure1(this, this)) : null;
            this.getServices().clear();
            public final class _refresh_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _refresh_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object id, Object jexler) {
                    if (((Jexler)jexler).getFile().exists() || ((Jexler)jexler).getState().isOn()) {
                        return ((JexlerContainer)((ServiceGroup)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ServiceGroup.class))).getServices().add((Service)jexler);
                    }
                    return null;
                }

                public Object call(Object id, Object jexler) {
                    return this.doCall(id, jexler);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _refresh_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(this.jexlerMap, (Closure)new _refresh_closure2(this, this));
            this.jexlerMap.clear();
            Jexler jexler = null;
            Iterator<Jexler> iterator = this.getJexlers().iterator();
            while (iterator.hasNext()) {
                Jexler jexler2 = jexler = (Jexler)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Jexler.class);
                DefaultGroovyMethods.putAt(this.jexlerMap, (Object)jexler.getId(), (Object)jexler2);
            }
        }
    }

    @Override
    public void start() {
        Jexler jexler = null;
        Iterator<Jexler> iterator = this.getJexlers().iterator();
        while (iterator.hasNext()) {
            jexler = (Jexler)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Jexler.class);
            if (!DefaultTypeTransformation.booleanUnbox(jexler.getMetaConfig() == null ? null : jexler.getMetaConfig().get("autostart"))) continue;
            jexler.start();
        }
    }

    @Override
    public void stop() {
        Grengine grengine;
        super.stop();
        this.grengine = grengine = this.createGrengine();
    }

    @Override
    public void trackIssue(Issue issue) {
        this.issueTracker.trackIssue(issue);
    }

    @Override
    public void trackIssue(Service service, String message, Throwable cause) {
        this.issueTracker.trackIssue(service, message, cause);
    }

    @Override
    public List<Issue> getIssues() {
        return this.issueTracker.getIssues();
    }

    @Override
    public void forgetIssues() {
        this.issueTracker.forgetIssues();
    }

    public List<Jexler> getJexlers() {
        LinkedList<Jexler> jexlers = new LinkedList<Jexler>();
        LinkedList<Jexler> nonRunnables = new LinkedList<Jexler>();
        Map<String, Jexler> map = this.jexlerMap;
        synchronized (map) {
            Service service = null;
            Iterator<Service> iterator = this.getServices().iterator();
            while (iterator.hasNext()) {
                service = (Service)ScriptBytecodeAdapter.castToType((Object)iterator.next(), Service.class);
                Jexler jexler = (Jexler)ScriptBytecodeAdapter.castToType((Object)service, Jexler.class);
                if (jexler.isRunnable()) {
                    jexlers.add(jexler);
                    continue;
                }
                nonRunnables.add(jexler);
            }
            jexlers.addAll(nonRunnables);
        }
        return Collections.unmodifiableList(jexlers);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Jexler getJexler(String id) {
        Map<String, Jexler> map = this.jexlerMap;
        synchronized (map) {
            return (Jexler)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt(this.jexlerMap, (Object)id), Jexler.class);
        }
    }

    public File getDir() {
        return this.dir;
    }

    public File getJexlerFile(String id) {
        return new File(this.dir, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{id, EXT}, new String[]{"", "", ""})));
    }

    public String getJexlerId(File jexlerFile) {
        String name = jexlerFile.getName();
        if (name.endsWith(EXT)) {
            return name.substring(0, name.length() - EXT.length());
        }
        return ShortTypeHandling.castToString(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Scheduler getScheduler() {
        Object object = this.schedulerLock;
        synchronized (object) {
            Scheduler scheduler2;
            if (!(this.scheduler == null)) return this.scheduler;
            String uuid = ShortTypeHandling.castToString((Object)UUID.randomUUID());
            String name = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.getId(), uuid}, new String[]{"JexlerContainerScheduler-", "-", ""}));
            String instanceId = name;
            DirectSchedulerFactory.getInstance().createScheduler(name, instanceId, (ThreadPool)new SimpleThreadPool(5, Thread.currentThread().getPriority()), (JobStore)new RAMJobStore());
            this.scheduler = scheduler2 = DirectSchedulerFactory.getInstance().getScheduler(name);
            this.scheduler.start();
            return this.scheduler;
        }
    }

    @Override
    public void close() {
        Object object = this.schedulerLock;
        synchronized (object) {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
                Object var2_2 = null;
                this.scheduler = (Scheduler)ScriptBytecodeAdapter.castToType(var2_2, Scheduler.class);
            }
        }
    }

    public static Logger getLogger() {
        return LOG;
    }

    public ConfigObject getAsConfig(String jexlerId) {
        Class clazz = this.grengine.load(new File(this.dir, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{jexlerId}, new String[]{"", EXT}))));
        return new ConfigSlurper().parse(clazz);
    }

    public Grengine getGrengine() {
        return this.grengine;
    }

    private Grengine createGrengine() {
        Reference runtimeLoader = new Reference((Object)new GroovyClassLoader());
        Grengine.Grape.activate();
        public final class _createGrengine_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createGrengine_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                ((CompilerConfiguration)this.getDelegate()).getOptimizationOptions().put(CompilerConfiguration.INVOKEDYNAMIC, true);
                String string = CompilerConfiguration.JDK8;
                ((CompilerConfiguration)this.getDelegate()).setTargetBytecode(string);
                public final class _closure5
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure5(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object it) {
                        return ((ImportCustomizer)this.getDelegate()).addStarImports(new String[]{"ch.artecat.jexler", "ch.artecat.jexler.service", "ch.artecat.jexler.tool"});
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                return ((CompilerConfiguration)this.getDelegate()).addCompilationCustomizers(new CompilationCustomizer[]{(CompilationCustomizer)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.with((Object)new ImportCustomizer(), (Closure)new _closure5((Object)this, this.getThisObject())), CompilationCustomizer.class)});
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createGrengine_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        CompilerConfiguration config = (CompilerConfiguration)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.with((Object)new CompilerConfiguration(), (Closure)new _createGrengine_closure3(this, this)), CompilerConfiguration.class);
        DefaultGroovyCompiler.withGrape((CompilerConfiguration)config, (GroovyClassLoader)((GroovyClassLoader)runtimeLoader.get()));
        Reference theCompilerFactory = new Reference((Object)new DefaultGroovyCompilerFactory(config));
        public final class _createGrengine_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference theCompilerFactory;
            private /* synthetic */ Reference runtimeLoader;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _createGrengine_closure4(Object _outerInstance, Object _thisObject, Reference theCompilerFactory, Reference runtimeLoader) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                this.theCompilerFactory = reference2 = theCompilerFactory;
                this.runtimeLoader = reference = runtimeLoader;
            }

            public Object doCall(Object it) {
                public final class _closure6
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference theCompilerFactory;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure6(Object _outerInstance, Object _thisObject, Reference theCompilerFactory) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.theCompilerFactory = reference = theCompilerFactory;
                    }

                    public Object doCall(Object it) {
                        Object object = this.theCompilerFactory.get();
                        ((JexlerContainerSources.Builder)this.getDelegate()).setCompilerFactory((CompilerFactory)ScriptBytecodeAdapter.castToType((Object)object, CompilerFactory.class));
                        DefaultSourceFactory defaultSourceFactory = new DefaultSourceFactory();
                        ((JexlerContainerSources.Builder)this.getDelegate()).setSourceFactory((SourceFactory)defaultSourceFactory);
                        int n = 800;
                        ((JexlerContainerSources.Builder)this.getDelegate()).setLatencyMs(n);
                        return ((JexlerContainerSources.Builder)this.getDelegate()).build();
                    }

                    public CompilerFactory getTheCompilerFactory() {
                        return (CompilerFactory)ScriptBytecodeAdapter.castToType((Object)this.theCompilerFactory.get(), CompilerFactory.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure6.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                List list = ScriptBytecodeAdapter.createList((Object[])new Object[]{(Sources)DefaultGroovyMethods.with((Object)new JexlerContainerSources.Builder((JexlerContainer)this.getThisObject()), (Closure)new _closure6((Object)this, this.getThisObject(), this.theCompilerFactory))});
                ((Grengine.Builder)this.getDelegate()).setSourcesLayers(list);
                int n = 800;
                ((Grengine.Builder)this.getDelegate()).setLatencyMs((long)n);
                public final class _closure7
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference runtimeLoader;
                    private /* synthetic */ Reference theCompilerFactory;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _closure7(Object _outerInstance, Object _thisObject, Reference runtimeLoader, Reference theCompilerFactory) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        Reference reference2;
                        this.runtimeLoader = reference2 = runtimeLoader;
                        this.theCompilerFactory = reference = theCompilerFactory;
                    }

                    public Object doCall(Object it) {
                        Object object = this.runtimeLoader.get();
                        ((LayeredEngine.Builder)this.getDelegate()).setParent((ClassLoader)ScriptBytecodeAdapter.castToType((Object)object, ClassLoader.class));
                        boolean bl = false;
                        ((LayeredEngine.Builder)this.getDelegate()).setAllowSameClassNamesInMultipleCodeLayers(bl);
                        boolean bl2 = true;
                        ((LayeredEngine.Builder)this.getDelegate()).setAllowSameClassNamesInParentAndCodeLayers(bl2);
                        boolean bl3 = true;
                        ((LayeredEngine.Builder)this.getDelegate()).setWithTopCodeCache(bl3);
                        LoadMode loadMode = LoadMode.PARENT_FIRST;
                        ((LayeredEngine.Builder)this.getDelegate()).setTopLoadMode(loadMode);
                        public final class _closure8
                        extends Closure
                        implements GeneratedClosure {
                            private /* synthetic */ Reference theCompilerFactory;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure8(Object _outerInstance, Object _thisObject, Reference theCompilerFactory) {
                                super(_outerInstance, _thisObject);
                                Reference reference;
                                this.theCompilerFactory = reference = theCompilerFactory;
                            }

                            public Object doCall(Object it) {
                                Object object = this.theCompilerFactory.get();
                                ((DefaultTopCodeCacheFactory.Builder)this.getDelegate()).setCompilerFactory((CompilerFactory)ScriptBytecodeAdapter.castToType((Object)object, CompilerFactory.class));
                                return ((DefaultTopCodeCacheFactory.Builder)this.getDelegate()).build();
                            }

                            public CompilerFactory getTheCompilerFactory() {
                                return (CompilerFactory)ScriptBytecodeAdapter.castToType((Object)this.theCompilerFactory.get(), CompilerFactory.class);
                            }

                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure8.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }
                        }
                        Object object2 = DefaultGroovyMethods.with((Object)new DefaultTopCodeCacheFactory.Builder(), (Closure)new _closure8((Object)this, this.getThisObject(), this.theCompilerFactory));
                        ((LayeredEngine.Builder)this.getDelegate()).setTopCodeCacheFactory((TopCodeCacheFactory)ScriptBytecodeAdapter.castToType((Object)object2, TopCodeCacheFactory.class));
                        return ((LayeredEngine.Builder)this.getDelegate()).build();
                    }

                    public GroovyClassLoader getRuntimeLoader() {
                        return (GroovyClassLoader)ScriptBytecodeAdapter.castToType((Object)this.runtimeLoader.get(), GroovyClassLoader.class);
                    }

                    public CompilerFactory getTheCompilerFactory() {
                        return (CompilerFactory)ScriptBytecodeAdapter.castToType((Object)this.theCompilerFactory.get(), CompilerFactory.class);
                    }

                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Object doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure7.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }
                }
                Object object = DefaultGroovyMethods.with((Object)new LayeredEngine.Builder(), (Closure)new _closure7((Object)this, this.getThisObject(), this.runtimeLoader, this.theCompilerFactory));
                ((Grengine.Builder)this.getDelegate()).setEngine((Engine)ScriptBytecodeAdapter.castToType((Object)object, Engine.class));
                return ((Grengine.Builder)this.getDelegate()).build();
            }

            public CompilerFactory getTheCompilerFactory() {
                return (CompilerFactory)ScriptBytecodeAdapter.castToType((Object)this.theCompilerFactory.get(), CompilerFactory.class);
            }

            public GroovyClassLoader getRuntimeLoader() {
                return (GroovyClassLoader)ScriptBytecodeAdapter.castToType((Object)this.runtimeLoader.get(), GroovyClassLoader.class);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _createGrengine_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        Grengine gren = (Grengine)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.with((Object)new Grengine.Builder(), (Closure)new _createGrengine_closure4(this, this, theCompilerFactory, runtimeLoader)), Grengine.class);
        GrengineException lastUpdateException = gren.getLastUpdateException();
        if (lastUpdateException != null) {
            this.trackIssue(this, StringGroovyMethods.plus((String)"Compiling container sources failed at startup", (CharSequence)" - utility classes are not available to jexlers."), (Throwable)lastUpdateException);
        }
        return gren;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JexlerContainer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        LOG = logger = LoggerFactory.getLogger(JexlerContainer.class);
    }
}

