/*
 * Decompiled with CFR 0.152.
 */
package ch.artecat.jexler;

import ch.artecat.grengine.Grengine;
import ch.artecat.jexler.Issue;
import ch.artecat.jexler.IssueTracker;
import ch.artecat.jexler.IssueTrackerBase;
import ch.artecat.jexler.JexlerContainer;
import ch.artecat.jexler.service.Event;
import ch.artecat.jexler.service.Service;
import ch.artecat.jexler.service.ServiceGroup;
import ch.artecat.jexler.service.ServiceState;
import ch.artecat.jexler.service.StopEvent;
import groovy.lang.Binding;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.lang.Script;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jexler
implements Service,
IssueTracker,
GroovyObject {
    private static final Logger LOG;
    private static final Grengine META_CONFIG_GRENGINE;
    private static final Pattern META_CONFIG_PATTERN;
    private final File file;
    private final String id;
    private final JexlerContainer container;
    private volatile ServiceState state;
    private volatile Script script;
    private volatile Thread scriptThread;
    protected final Events events;
    private final ServiceGroup services;
    private final IssueTracker issueTracker;
    private ConfigObject metaConfigAtStart;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public Jexler(File file, JexlerContainer container) {
        ServiceGroup serviceGroup;
        Events events;
        ServiceState serviceState;
        String string;
        JexlerContainer jexlerContainer;
        File file2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.file = file2 = file;
        this.container = jexlerContainer = container;
        this.id = string = container.getJexlerId(file);
        this.state = serviceState = ServiceState.OFF;
        this.events = events = new Events(this);
        this.services = serviceGroup = new ServiceGroup(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.id}, new String[]{"", ".services"})));
        IssueTrackerBase issueTrackerBase = new IssueTrackerBase();
        this.issueTracker = issueTrackerBase;
    }

    @Override
    public void start() {
        Thread thread;
        ServiceState serviceState;
        LOG.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.id}, new String[]{"*** Jexler start: ", ""})));
        if (this.state.isOn()) {
            return;
        }
        this.state = serviceState = ServiceState.BUSY_STARTING;
        this.forgetIssues();
        Reference jexler = new Reference((Object)this);
        this.scriptThread = thread = new Thread(new Runnable(this, jexler){
            public /* synthetic */ Reference jexler;
            public /* synthetic */ Jexler this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                Jexler jexler;
                this.this$0 = jexler = p0;
                this.jexler = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void run() {
                Class clazz;
                Binding binding;
                block19: {
                    Jexler.pfaccess$06(this.this$0, this.this$0.readMetaConfig());
                    boolean runnable = this.this$0.metaConfigAtStart != null;
                    if (!runnable || !this.this$0.getIssues().isEmpty()) {
                        Jexler.pfaccess$03(this.this$0, ServiceState.OFF);
                        return;
                    }
                    binding = new Binding(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"jexler", this.jexler.get(), "container", this.this$0.getContainer(), "events", this.getProperty("events"), "services", this.this$0.services, "log", LOG}));
                    clazz = null;
                    try {
                        Class clazz2;
                        clazz = clazz2 = this.this$0.getContainer().getGrengine().load(this.this$0.getFile());
                    }
                    catch (Throwable tCompile) {
                        this.this$0.trackIssue((Service)ScriptBytecodeAdapter.castToType((Object)this.jexler.get(), Service.class), "Script compile failed.", tCompile);
                        Jexler.pfaccess$03(this.this$0, ServiceState.OFF);
                        return;
                    }
                    if (!(!Script.class.isAssignableFrom(clazz))) break block19;
                    Jexler.pfaccess$03(this.this$0, ServiceState.OFF);
                    return;
                }
                try {
                    Jexler.pfaccess$04(this.this$0, (Script)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.newInstance((Class)clazz), Script.class));
                }
                catch (Throwable tCreate) {
                    this.this$0.trackIssue((Service)ScriptBytecodeAdapter.castToType((Object)this.jexler.get(), Service.class), "Script create failed.", tCreate);
                    Jexler.pfaccess$03(this.this$0, ServiceState.OFF);
                    return;
                }
                Binding binding2 = binding;
                this.this$0.getScript().setBinding(binding2);
                try {
                    this.this$0.getScript().run();
                }
                catch (Throwable tRun) {
                    this.this$0.trackIssue((Service)ScriptBytecodeAdapter.castToType((Object)this.jexler.get(), Service.class), "Script run failed.", tRun);
                }
                Jexler.pfaccess$03(this.this$0, ServiceState.BUSY_STOPPING);
                try {
                    this.this$0.services.stop();
                }
                catch (Throwable tStop) {
                    this.this$0.trackIssue(this.this$0.services, "Could not stop services.", tStop);
                }
                ((Events)this.getProperty("events")).clear();
                this.this$0.services.getServices().clear();
                Jexler.pfaccess$04(this.this$0, null);
                Jexler.pfaccess$03(this.this$0, ServiceState.OFF);
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(1.class, Jexler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, Jexler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(1.class, Jexler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        });
        boolean bl = true;
        this.scriptThread.setDaemon(bl);
        String string = this.id;
        this.scriptThread.setName(string);
        this.scriptThread.start();
    }

    public void handle(Event event) {
        this.events.add(event);
    }

    @Override
    public void stop() {
        LOG.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.id}, new String[]{"*** Jexler stop: ", ""})));
        if (this.state.isOff()) {
            return;
        }
        this.handle(new StopEvent(this));
    }

    @Override
    public ServiceState getState() {
        return this.state;
    }

    @Override
    public void zap() {
        ServiceState serviceState;
        LOG.info(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.id}, new String[]{"*** Jexler zap: ", ""})));
        if (this.state.isOff()) {
            return;
        }
        this.state = serviceState = ServiceState.OFF;
        Reference services = new Reference((Object)this.services);
        Reference scriptThread = new Reference((Object)this.scriptThread);
        Reference jexler = new Reference((Object)this);
        new GroovyObject(this, services, scriptThread, jexler){
            public /* synthetic */ Reference jexler;
            public /* synthetic */ Reference scriptThread;
            public /* synthetic */ Reference services;
            public /* synthetic */ Jexler this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            {
                MetaClass metaClass;
                Reference reference;
                Reference reference2;
                Reference reference3;
                Jexler jexler;
                this.this$0 = jexler = p0;
                this.jexler = reference3 = p3;
                this.scriptThread = reference2 = p2;
                this.services = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            @Override
            public void run() {
                if (this.services.get() != null) {
                    ((ServiceGroup)this.services.get()).zap();
                }
                if (this.scriptThread.get() != null) {
                    try {
                        ((Thread)this.scriptThread.get()).stop();
                    }
                    catch (Throwable tZap) {
                        this.this$0.trackIssue((Service)ScriptBytecodeAdapter.castToType((Object)this.jexler.get(), Service.class), "Failed to stop jexler thread.", tZap);
                    }
                }
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                return this.this$0.this$dist$invoke$1(name, args);
            }

            public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
                return ScriptBytecodeAdapter.invokeMethodN(2.class, Jexler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                this.this$0.this$dist$set$1(name, val);
            }

            public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, Jexler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                return this.this$0.this$dist$get$1(name);
            }

            public static /* synthetic */ Object $static_propertyMissing(String name) {
                return ScriptBytecodeAdapter.getProperty(2.class, Jexler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            @Generated
            @Internal
            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            @Generated
            @Internal
            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            @Generated
            @Internal
            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            @Generated
            @Internal
            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }
        }.start();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void trackIssue(Issue issue) {
        this.issueTracker.trackIssue(issue);
    }

    @Override
    public void trackIssue(Service service, String message, Throwable cause) {
        this.issueTracker.trackIssue(service, message, cause);
    }

    @Override
    public List<Issue> getIssues() {
        return this.issueTracker.getIssues();
    }

    @Override
    public void forgetIssues() {
        this.issueTracker.forgetIssues();
    }

    public File getFile() {
        return this.file;
    }

    public File getDir() {
        return this.file.getParentFile();
    }

    public JexlerContainer getContainer() {
        return this.container;
    }

    public Script getScript() {
        return this.script;
    }

    public ConfigObject getAsConfig() {
        return new ConfigSlurper().parse(this.container.getGrengine().load(this.file));
    }

    public boolean isRunnable() {
        return this.getMetaConfig() != null;
    }

    public ConfigObject getMetaConfig() {
        if (this.state.isOn()) {
            return this.metaConfigAtStart;
        }
        return this.readMetaConfig();
    }

    private ConfigObject readMetaConfig() {
        List lines;
        block13: {
            if (!this.file.exists()) {
                return (ConfigObject)ScriptBytecodeAdapter.castToType(null, ConfigObject.class);
            }
            lines = null;
            try {
                List list;
                lines = list = ResourceGroovyMethods.readLines((File)this.file);
            }
            catch (IOException eRead) {
                String msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.file.getAbsolutePath()}, new String[]{"Could not read meta config from jexler file '", "'."}));
                this.trackIssue(this.container, msg, eRead);
                ConfigObject configObject = (ConfigObject)ScriptBytecodeAdapter.castToType(null, ConfigObject.class);
                return configObject;
            }
            if (!lines.isEmpty()) break block13;
            return (ConfigObject)ScriptBytecodeAdapter.castToType(null, ConfigObject.class);
        }
        String line = ((String)DefaultGroovyMethods.first((List)lines)).trim();
        Matcher matcher = META_CONFIG_PATTERN.matcher(line);
        if (!matcher.matches()) {
            return (ConfigObject)ScriptBytecodeAdapter.castToType(null, ConfigObject.class);
        }
        String metaConfigText = matcher.group(1);
        Script script = META_CONFIG_GRENGINE.create(metaConfigText);
        ConfigObject configObject = new ConfigSlurper().parse(script);
        try {
            return configObject;
        }
        catch (Throwable tParse) {
            String msg = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.id}, new String[]{"Could not parse meta config of jexler '", "'."}));
            this.trackIssue(this, msg, tParse);
            ConfigObject configObject2 = new ConfigObject();
            return configObject2;
        }
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(Jexler.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, Jexler.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(Jexler.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public static /* synthetic */ File pfaccess$1(Jexler $that) {
        return $that.getFile();
    }

    public static /* synthetic */ JexlerContainer pfaccess$2(Jexler $that) {
        return $that.getContainer();
    }

    public static /* synthetic */ ServiceState pfaccess$03(Jexler $that, ServiceState $value) {
        ServiceState serviceState = $value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)((Object)serviceState), Jexler.class, (GroovyObject)$that, (String)"state");
        return serviceState;
    }

    public static /* synthetic */ Script pfaccess$4(Jexler $that) {
        return $that.getScript();
    }

    public static /* synthetic */ Script pfaccess$04(Jexler $that, Script $value) {
        Script script = $value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)script, Jexler.class, (GroovyObject)$that, (String)"script");
        return script;
    }

    public static /* synthetic */ ConfigObject pfaccess$06(Jexler $that, ConfigObject $value) {
        ConfigObject configObject = $value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)configObject, Jexler.class, (GroovyObject)$that, (String)"metaConfigAtStart");
        return configObject;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != Jexler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Pattern pattern;
        Grengine grengine;
        Logger logger;
        LOG = logger = LoggerFactory.getLogger(Jexler.class);
        META_CONFIG_GRENGINE = grengine = new Grengine();
        META_CONFIG_PATTERN = pattern = Pattern.compile("^//\\s*jexler\\s*\\{\\s*(.*?)\\s*}$", Pattern.CASE_INSENSITIVE);
    }

    public class Events
    extends LinkedBlockingQueue<Event>
    implements GroovyObject {
        public /* synthetic */ Jexler this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;

        public Events(Jexler $p$) {
            MetaClass metaClass;
            Jexler jexler;
            this.this$0 = jexler = $p$;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        @Override
        public Event take() {
            Jexler.pfaccess$03(this.this$0, ServiceState.IDLE);
            while (true) {
                Event event = (Event)ScriptBytecodeAdapter.castToType(super.take(), Event.class);
                Jexler.pfaccess$03(this.this$0, ServiceState.BUSY_EVENT);
                Event event2 = event;
                try {
                    return event2;
                }
                catch (InterruptedException e) {
                    this.this$0.trackIssue(this.this$0, "Could not take event.", e);
                    continue;
                }
                break;
            }
        }

        public boolean nextIsStop() {
            return this.peek() instanceof StopEvent;
        }

        public boolean hasStop() {
            Object[] events = this.toArray();
            Object event2 = null;
            Object[] objectArray = events;
            if (events != null) {
                for (Object event2 : objectArray) {
                    if (!(event2 instanceof StopEvent)) continue;
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return this.this$0.this$dist$invoke$1(name, args);
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Events.class, Jexler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            this.this$0.this$dist$set$1(name, val);
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, Jexler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return this.this$0.this$dist$get$1(name);
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Events.class, Jexler.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != Events.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        @Generated
        @Internal
        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        @Generated
        @Internal
        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        @Generated
        @Internal
        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        @Generated
        @Internal
        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }
}

