/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.timeutil;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.Day;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.timeutil.TimeUtil;

public class DayExpression {
    public static String TODAY = "today";
    public static String START = "start";
    public static String END = "end";
    private Adjustment adjustment;
    private Type type;
    private TimeIndex time;
    private int offset;

    public DayExpression(Adjustment adjustment) {
        if (adjustment == null) {
            throw new IllegalArgumentException("adjustment null");
        }
        this.adjustment = adjustment;
        this.type = Type.ERROR;
    }

    public DayExpression(DayExpression model) {
        this.adjustment = model.adjustment;
        this.type = model.type;
        this.time = model.time;
        this.offset = model.offset;
    }

    public static Day parseDay(String expr) throws T2Exception {
        return new Day(DayExpression.parseDay(expr, Day.DOMAIN, Adjustment.NONE));
    }

    public static TimeIndex parseDay(String expr, TimeDomain domain, Adjustment adjustment) throws T2Exception {
        DayExpression dex = new DayExpression(adjustment);
        dex.parseExpression(Day.DOMAIN, expr);
        return dex.getDate(domain);
    }

    protected boolean isToday() {
        return this.type == Type.TODAY;
    }

    protected void reset(DayExpression model) {
        if (model == null) {
            return;
        }
        this.adjustment = model.adjustment;
        this.type = model.type;
        this.time = model.time;
        this.offset = model.offset;
    }

    protected boolean needContext() {
        switch (this.type) {
            case LITERAL: 
            case TODAY: {
                return false;
            }
            case END: 
            case START: {
                return true;
            }
            case ERROR: {
                throw new IllegalStateException(this.type.name());
            }
        }
        throw new RuntimeException(this.type.name());
    }

    protected void setTime(TimeIndex time) {
        if (time == null) {
            throw new IllegalArgumentException("time null");
        }
        this.type = Type.LITERAL;
        this.time = time;
        this.offset = 0;
    }

    public void setExpression(TimeDomain domain, String expression) throws T2Exception {
        this.parseExpression(domain, expression);
    }

    public void incr(int increment) throws T2Exception {
        if (this.type == Type.ERROR) {
            throw new IllegalStateException();
        }
        if (increment == 0) {
            return;
        }
        long test = this.offset + increment;
        if (Math.abs(test) <= Integer.MAX_VALUE) {
            this.offset = (int)test;
        }
        this.applyOffset();
    }

    public String getExpression() {
        String expression;
        switch (this.type) {
            case LITERAL: {
                return this.time.toString();
            }
            case TODAY: {
                expression = TODAY;
                break;
            }
            case END: {
                expression = END;
                break;
            }
            case START: {
                expression = START;
                break;
            }
            case ERROR: {
                throw new IllegalStateException(this.type.name());
            }
            default: {
                throw new RuntimeException(this.type.name());
            }
        }
        if (this.offset > 0) {
            expression = expression + "+" + this.offset;
        } else if (this.offset < 0) {
            expression = expression + this.offset;
        }
        return expression;
    }

    public TimeIndex getDate(TimeDomain domain) throws T2Exception {
        switch (this.type) {
            case LITERAL: {
                if (!domain.equals(this.time.getTimeDomain())) {
                    return this.time.convert(domain, this.adjustment);
                }
                return this.time;
            }
            case TODAY: {
                if (domain.compareResolutionTo(Resolution.DAY) < 0) {
                    TimeIndex t = this.addOffset(TimeUtil.now(Day.DOMAIN));
                    return t.convert(domain, Adjustment.DOWN);
                }
                return this.addOffset(TimeUtil.now(domain));
            }
            case END: 
            case START: {
                throw T2Msg.exception("T7026", this.getExpression());
            }
            case ERROR: {
                throw new IllegalStateException(this.type.name());
            }
        }
        throw new RuntimeException("bug: " + this.type.name());
    }

    public TimeIndex getDate(Range context) throws T2Exception {
        switch (this.type) {
            case LITERAL: 
            case TODAY: {
                return this.getDate(context.getTimeDomain());
            }
            case END: {
                return this.addOffset(context.getLast());
            }
            case START: {
                return this.addOffset(context.getFirst());
            }
            case ERROR: {
                throw new IllegalStateException(this.type.name());
            }
        }
        throw new RuntimeException(this.type.name());
    }

    private void setOffset(int offset) {
        this.offset = offset;
    }

    private void applyOffset() throws T2Exception {
        if (this.time != null && this.offset != 0) {
            this.time = this.time.add(this.offset);
            this.offset = 0;
        }
    }

    private TimeIndex addOffset(TimeIndex t) throws T2Exception {
        if (t == null) {
            return null;
        }
        if (this.offset != 0) {
            return t.add(this.offset);
        }
        return t;
    }

    private void parseExpression(TimeDomain domain, String expression) throws T2Exception {
        DayExpression previous = new DayExpression(this);
        try {
            this.tryParseExpression(domain, expression);
        }
        catch (T2Exception e) {
            this.reset(previous);
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void tryParseExpression(TimeDomain domain, String expr) throws T2Exception {
        modifier = "";
        this.time = null;
        try {
            if (expr.length() > 10) {
                this.time = domain.time(expr.substring(0, 10), this.adjustment);
                modifier = expr.substring(10);
            } else {
                this.time = domain.time(expr, this.adjustment);
            }
            this.type = Type.LITERAL;
        }
        catch (T2Exception e) {
            modifier = this.parseKeyword(expr, e);
        }
        if (modifier.length() > 0) {
            try {
                this.offset = DayExpression.parseOffset(modifier);
            }
            catch (NumberFormatException e) {
                if (this.time == null) ** GOTO lbl26
                try {
                    this.time = domain.time(expr, this.adjustment);
                    this.offset = 0;
                }
                catch (T2Exception e2) {
                    throw T2Msg.exception("T7025", new Object[]{modifier, expr});
                }
            }
        } else {
            this.offset = 0;
        }
lbl26:
        // 4 sources

        this.applyOffset();
    }

    private String parseKeyword(String expression, T2Exception originalException) throws T2Exception {
        String modifier = "";
        String expr = expression.toLowerCase();
        if (expr.startsWith(TODAY)) {
            modifier = this.modifier(expr, TODAY.length());
            this.type = Type.TODAY;
        } else if (expr.startsWith(START)) {
            modifier = this.modifier(expr, START.length());
            this.type = Type.START;
        } else if (expr.startsWith(END)) {
            modifier = this.modifier(expr, END.length());
            this.type = Type.END;
        } else if (originalException != null) {
            throw originalException;
        }
        return modifier;
    }

    private String modifier(String expr, int length) {
        if (expr.length() > length) {
            return expr.substring(length);
        }
        return "";
    }

    private static int parseOffset(String expr) throws NumberFormatException {
        int offset = 0;
        if (expr.length() > 0) {
            int sign = 1;
            char signStr = expr.charAt(0);
            if (signStr != '+') {
                if (signStr == '-') {
                    sign = -1;
                } else {
                    throw new NumberFormatException(expr);
                }
            }
            int plusIndex = expr.indexOf(43, 1);
            int minusIndex = expr.indexOf(45, 1);
            int index = -1;
            if (plusIndex >= 0 || minusIndex >= 0) {
                index = plusIndex < 0 ? minusIndex : (minusIndex < 0 ? plusIndex : Math.min(plusIndex, minusIndex));
            }
            if (index < 0) {
                offset = sign * Integer.parseInt(expr.substring(1));
            } else {
                offset = sign * Integer.parseInt(expr.substring(1, index));
                offset += DayExpression.parseOffset(expr.substring(index));
            }
        }
        return offset;
    }

    protected boolean enforceValidRange(TimeDomain domain, DayExpression begin, boolean keepBegin) throws T2Exception {
        if (this.type == Type.ERROR || begin.type == Type.ERROR) {
            return false;
        }
        if (this.type == begin.type) {
            this.eVRSameType(begin, keepBegin);
            return true;
        }
        if (this.type == Type.LITERAL && begin.type == Type.TODAY) {
            this.eVRTodayLiteral(domain, begin, keepBegin);
            return true;
        }
        if (this.type == Type.TODAY && begin.type == Type.LITERAL) {
            this.eVRLiteralToday(domain, begin, keepBegin);
            return true;
        }
        return true;
    }

    private void eVRSameType(DayExpression begin, boolean keepBegin) {
        if (this.time == null) {
            if (begin.offset > this.offset) {
                if (keepBegin) {
                    this.setOffset(begin.offset);
                } else {
                    begin.setOffset(this.offset);
                }
            }
        } else if (begin.time.compareTo(this.time) > 0) {
            if (keepBegin) {
                this.setTime(begin.time);
            } else {
                begin.setTime(this.time);
            }
        }
    }

    private void eVRTodayLiteral(TimeDomain domain, DayExpression begin, boolean keepBegin) throws T2Exception {
        TimeIndex t = begin.getDate(domain);
        if (t.compareTo(this.time) > 0) {
            if (keepBegin) {
                this.setTime(t);
            } else {
                long diff = t.asLong() - this.time.asLong();
                long test = (long)begin.offset + diff;
                if (Math.abs(test) <= Integer.MAX_VALUE) {
                    begin.incr((int)diff);
                } else {
                    begin.setTime(this.time);
                }
            }
        }
    }

    private void eVRLiteralToday(TimeDomain domain, DayExpression begin, boolean keepBegin) throws T2Exception {
        TimeIndex t = this.getDate(domain);
        if (begin.time.compareTo(t) > 0) {
            if (keepBegin) {
                long diff = begin.time.asLong() - t.asLong();
                long test = (long)this.offset + diff;
                if (Math.abs(test) <= Integer.MAX_VALUE) {
                    this.incr((int)diff);
                } else {
                    this.setTime(t);
                }
            } else {
                begin.setTime(t);
            }
        }
    }

    private static enum Type {
        END,
        ERROR,
        LITERAL,
        START,
        TODAY;

    }
}

