/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.timeutil;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.Day;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.timeutil.DayExpression;
import ch.agent.t2.timeutil.TimeUtil;

public class DateHolder {
    private TimeDomain domain;
    private DayExpression expr;
    private boolean isEmptyOkay = false;

    public DateHolder(TimeDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException("domain null");
        }
        this.domain = domain;
        this.expr = new DayExpression(Adjustment.DOWN);
        this.expr.setTime(TimeUtil.now(domain));
    }

    public DateHolder() {
        this(Day.DOMAIN);
    }

    protected static int getLargeIncrement(Resolution unit) {
        int incr;
        switch (unit) {
            case YEAR: {
                incr = 5;
                break;
            }
            case MONTH: {
                incr = 12;
                break;
            }
            case DAY: {
                incr = 15;
                break;
            }
            case HOUR: {
                incr = 24;
                break;
            }
            case MIN: {
                incr = 1440;
                break;
            }
            case SEC: {
                incr = 86400;
                break;
            }
            case MSEC: {
                incr = 86400000;
                break;
            }
            case USEC: {
                incr = 500654080;
                break;
            }
            case NSEC: {
                incr = -1857093632;
                break;
            }
            default: {
                throw new RuntimeException("bug: " + unit.name());
            }
        }
        return incr;
    }

    public TimeDomain getTimeDomain() {
        return this.domain;
    }

    public void allowEmptyDate(boolean allow) {
        this.isEmptyOkay = allow;
    }

    public void reset(TimeDomain domain) throws T2Exception {
        if (domain == null) {
            throw new IllegalArgumentException("domain null");
        }
        if (this.domain.equals(domain)) {
            return;
        }
        String date = this.getDateText();
        this.domain = domain;
        this.setDate(date);
    }

    public void resetToCurrentTime() {
        if (this.expr == null) {
            this.expr = new DayExpression(Adjustment.DOWN);
        }
        this.expr.setTime(TimeUtil.now(this.domain));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDate(String date) throws T2Exception {
        if (date == null || date.length() == 0) {
            if (!this.isEmptyOkay) throw T2Msg.exception("T7021", new Object[0]);
            this.expr = null;
            return;
        } else {
            if (this.expr == null) {
                this.expr = new DayExpression(Adjustment.DOWN);
            }
            this.expr.setExpression(this.domain, date);
        }
    }

    public void incrDate(int increment) throws T2Exception {
        if (increment == 0) {
            return;
        }
        if (this.expr == null) {
            this.resetToCurrentTime();
        } else {
            this.expr.incr(increment);
        }
    }

    public void incrDate(boolean up, boolean large) throws T2Exception {
        int incr = 1;
        if (large) {
            incr = this.expr.isToday() ? DateHolder.getLargeIncrement(Resolution.DAY) : DateHolder.getLargeIncrement(this.domain.getResolution());
        }
        this.incrDate(up ? incr : -incr);
    }

    public String getDateText() {
        if (this.expr == null) {
            return "";
        }
        return this.expr.getExpression();
    }

    public TimeIndex getDate() throws T2Exception {
        if (this.expr == null) {
            return null;
        }
        return this.expr.getDate(this.domain);
    }

    public TimeIndex getDate(Range context) throws T2Exception {
        if (this.expr == null) {
            return null;
        }
        return this.expr.getDate(context);
    }
}

