/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.timeseries;

import ch.agent.t2.T2Exception;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.timeseries.AbstractTimeSeries;
import ch.agent.t2.timeseries.Observation;
import ch.agent.t2.timeseries.RegularTimeSeries;
import ch.agent.t2.timeseries.TimeAddressable;
import ch.agent.t2.timeseries.TimeIndexable;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class SparseTimeSeries<T>
extends AbstractTimeSeries<T>
implements TimeAddressable<T> {
    private SortedMap<Long, T> data;

    public SparseTimeSeries(Class<T> type, TimeDomain domain, T missingValue) {
        super(type, domain, missingValue);
        this.data = new TreeMap<Long, T>();
    }

    public SparseTimeSeries(Class<T> type, TimeDomain domain) {
        this(type, domain, type == Double.class ? Double.valueOf(Double.NaN) : null);
    }

    private SparseTimeSeries(SparseTimeSeries<T> ts, long first, long last) {
        super(ts.getType(), ts.getTimeDomain(), ts.getMissingValue());
        this.data = last + 1L < last ? new TreeMap<Long, T>(ts.data.tailMap(first)) : new TreeMap<Long, T>(ts.data.subMap(first, last + 1L));
    }

    @Override
    public Iterator<Observation<T>> iterator() {
        return new IrregularTimeSeriesIterator();
    }

    @Override
    public TimeAddressable<T> makeEmptyCopy() {
        return new SparseTimeSeries(this.getType(), this.getTimeDomain(), this.getMissingValue());
    }

    @Override
    public TimeIndexable<T> asIndexable() throws T2Exception {
        RegularTimeSeries ts = new RegularTimeSeries(this.getType(), this.getTimeDomain(), this.getMissingValue());
        ts.put(this, null);
        return ts;
    }

    @Override
    public TimeAddressable<T> get(long first, long last) {
        if (first > last) {
            last = first - 1L;
        }
        return new SparseTimeSeries<T>(this, first, last);
    }

    @Override
    public TimeAddressable<T> get(Range range) throws T2Exception {
        this.getTimeDomain().requireEquality(range.getTimeDomain());
        if (range.isEmpty()) {
            return new SparseTimeSeries(this.getType(), this.getTimeDomain(), this.getMissingValue());
        }
        return this.get(range.getFirstIndex(), range.getLastIndex());
    }

    @Override
    protected Observation<T> internalGetLast(long index) throws T2Exception {
        SortedMap<Long, T> subMap;
        if (this.data.isEmpty() || this.data.firstKey() > index) {
            return null;
        }
        Long upperBound = index + 1L;
        if (upperBound > this.data.lastKey()) {
            upperBound = this.data.lastKey() + 1L;
        }
        if ((subMap = this.data.headMap(upperBound)).size() == 0) {
            return null;
        }
        Long last = subMap.lastKey();
        return new Observation(this.getTimeDomain(), last, subMap.get(last));
    }

    @Override
    protected Observation<T> internalGetFirst(long index) throws T2Exception {
        SortedMap<Long, T> subMap;
        if (this.data.isEmpty() || this.data.lastKey() < index) {
            return null;
        }
        Long lowerBound = index;
        if (lowerBound < this.data.firstKey()) {
            lowerBound = this.data.firstKey();
        }
        if ((subMap = this.data.tailMap(lowerBound)).size() == 0) {
            return null;
        }
        Long last = subMap.firstKey();
        return new Observation(this.getTimeDomain(), last, subMap.get(last));
    }

    @Override
    public int getValueCount() {
        return this.getSize();
    }

    @Override
    public boolean isIndexable() {
        return false;
    }

    @Override
    protected void internalClear() {
        this.data.clear();
    }

    @Override
    protected T internalGet(long index) throws T2Exception {
        Object result = this.data.get(index);
        if (result == null) {
            return this.getMissingValue();
        }
        return (T)result;
    }

    @Override
    protected Collection<T> internalGetData() {
        return this.data.values();
    }

    @Override
    protected long internalGetFirstIndex() {
        if (this.data.size() == 0) {
            return -1L;
        }
        return this.data.firstKey();
    }

    @Override
    protected long internalGetLastIndex() {
        if (this.data.size() == 0) {
            return -1L;
        }
        return this.data.lastKey();
    }

    @Override
    protected int internalGetSize() {
        return this.data.size();
    }

    @Override
    protected void internalPut(long index, T value) throws T2Exception {
        if (index < 0L) {
            throw new IllegalArgumentException("index < 0");
        }
        if (this.isMissing(value = this.normalizeMissingValue(value))) {
            this.internalRemove(index);
        } else {
            this.data.put(index, value);
        }
    }

    @Override
    protected void internalRemove(long index) throws T2Exception {
        this.data.remove(index);
    }

    @Override
    protected void internalSetBounds(long first, long last) throws T2Exception {
        this.data = new TreeMap<Long, T>(this.data.subMap(first, last + 1L));
    }

    public class IrregularTimeSeriesIterator
    implements Iterator<Observation<T>> {
        private Iterator<Long> keysIt;
        private TimeDomain domain;

        public IrregularTimeSeriesIterator() {
            this.keysIt = SparseTimeSeries.this.data.keySet().iterator();
            this.domain = SparseTimeSeries.this.getTimeDomain();
        }

        @Override
        public boolean hasNext() {
            return this.keysIt.hasNext();
        }

        @Override
        public Observation<T> next() {
            Long k = this.keysIt.next();
            Observation obs = new Observation(this.domain, k, SparseTimeSeries.this.data.get(k));
            return obs;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

