/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.timeseries;

import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;

public class Observation<T> {
    private TimeDomain domain;
    private long index;
    private T value;

    protected Observation(TimeDomain domain, long index, T value) {
        this.domain = domain;
        this.index = index;
        this.value = value;
    }

    public Observation(TimeIndex time, T value) {
        this.domain = time.getTimeDomain();
        this.index = time.asLong();
        this.value = value;
    }

    public long getIndex() {
        return this.index;
    }

    public TimeIndex getTime() {
        return this.domain.time(this.index);
    }

    public TimeDomain getDomain() {
        return this.domain;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return this.getTime().toString() + "=" + (this.value == null ? this.value : this.value.toString());
    }
}

