/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.timeseries;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.timeseries.Observation;
import ch.agent.t2.timeseries.RegularTimeSeries;
import ch.agent.t2.timeseries.SparseTimeSeries;
import ch.agent.t2.timeseries.TimeAddressable;
import ch.agent.t2.timeseries.TimeIndexable;
import ch.agent.t2.timeseries.UpdateReviewer;
import java.util.Collection;

public abstract class AbstractTimeSeries<T>
implements TimeAddressable<T> {
    private final TimeDomain domain;
    private final Class<T> type;
    private final T missingValue;

    public static <X> TimeAddressable<X> make(Class<X> type, TimeDomain domain, boolean forceSparse) {
        return forceSparse || domain.compareResolutionTo(Resolution.DAY) < 0 ? new SparseTimeSeries<X>(type, domain) : new RegularTimeSeries<X>(type, domain);
    }

    public AbstractTimeSeries() {
        throw new UnsupportedOperationException();
    }

    public AbstractTimeSeries(Class<T> type, TimeDomain domain, T missingValue) {
        if (type == null) {
            throw new IllegalArgumentException("type null");
        }
        if (domain == null) {
            throw new IllegalArgumentException("domain null");
        }
        this.type = type;
        this.domain = domain;
        this.missingValue = missingValue;
    }

    @Override
    public boolean isMissing(T value) {
        return value == this.missingValue;
    }

    @Override
    public TimeAddressable<T> copy() throws T2Exception {
        TimeAddressable ts = this.makeEmptyCopy();
        ts.put(this, null);
        return ts;
    }

    @Override
    public T get(long t) throws T2Exception {
        return this.internalGet(t);
    }

    @Override
    public abstract TimeAddressable<T> get(long var1, long var3) throws T2Exception;

    @Override
    public T get(TimeIndex t) throws T2Exception {
        if (!this.domain.equals(t.getTimeDomain())) {
            throw T2Msg.exception("T5011", new Object[0]);
        }
        return this.get(t.asLong());
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public TimeDomain getTimeDomain() {
        return this.domain;
    }

    @Override
    public Range getRange() {
        if (this.getSize() < 1) {
            return new Range(this.domain);
        }
        return new Range(this.domain, this.internalGetFirstIndex(), this.internalGetLastIndex());
    }

    @Override
    public long getFirstIndex() {
        return this.internalGetFirstIndex();
    }

    @Override
    public long getLastIndex() {
        return this.internalGetLastIndex();
    }

    @Override
    public Observation<T> getLast(TimeIndex t) throws T2Exception {
        if (t == null) {
            long l = this.internalGetLastIndex();
            return l >= 0L ? this.internalGetLast(l) : null;
        }
        if (!t.getTimeDomain().equals(this.getTimeDomain())) {
            throw T2Msg.exception("T5013", t.toString(), t.getTimeDomain().getLabel(), this.getTimeDomain().getLabel());
        }
        return this.internalGetLast(t.asLong());
    }

    @Override
    public Observation<T> getFirst(TimeIndex t) throws T2Exception {
        if (t == null) {
            long f = this.internalGetFirstIndex();
            return f >= 0L ? this.internalGetFirst(f) : null;
        }
        if (!t.getTimeDomain().equals(this.getTimeDomain())) {
            throw T2Msg.exception("T5013", t.toString(), t.getTimeDomain().getLabel(), this.getTimeDomain().getLabel());
        }
        return this.internalGetFirst(t.asLong());
    }

    @Override
    public int getSize() {
        return this.internalGetSize();
    }

    @Override
    public void put(long index, T value) throws T2Exception {
        this.internalPut(index, value);
    }

    @Override
    public void put(long index, T[] values) throws T2Exception {
        if (values.length == 0) {
            return;
        }
        this.internalPut(index + (long)values.length - 1L, values[values.length - 1]);
        for (int i = 0; i < values.length - 1; ++i) {
            this.internalPut(index++, values[i]);
        }
    }

    @Override
    public void put(TimeAddressable<T> values, UpdateReviewer<T> reviewer) throws T2Exception {
        this.getRange().union(values.getRange()).getSizeAsInt();
        int rejectCount = this.accept(values, reviewer);
        if (rejectCount > 0) {
            throw T2Msg.exception("T5012", rejectCount, values.getSize());
        }
        if (values.isIndexable()) {
            this.put(values.getFirstIndex(), ((TimeIndexable)values).getArray());
        } else {
            for (Observation<T> obs : values) {
                this.internalPut(obs.getIndex(), obs.getValue());
            }
        }
    }

    @Override
    public void put(TimeIndex t, T value) throws T2Exception {
        if (!this.domain.equals(t.getTimeDomain())) {
            throw T2Msg.exception("T5011", new Object[0]);
        }
        this.internalPut(t.asLong(), value);
    }

    @Override
    public void put(TimeIndex t, T[] values) throws T2Exception {
        if (!this.domain.equals(t.getTimeDomain())) {
            throw T2Msg.exception("T5011", new Object[0]);
        }
        this.put(t.asLong(), values);
    }

    @Override
    public void remove(TimeIndex t) throws T2Exception {
        if (!this.domain.equals(t.getTimeDomain())) {
            throw T2Msg.exception("T5011", new Object[0]);
        }
        this.internalRemove(t.asLong());
    }

    @Override
    public boolean setRange(Range range) throws T2Exception {
        Range current = this.getRange();
        if (current.isEmpty()) {
            return false;
        }
        if (current.equals(range)) {
            return false;
        }
        if (range == null) {
            this.internalClear();
            return true;
        }
        Range inter = current.intersection(range);
        if (inter.isEmpty()) {
            this.internalClear();
            return true;
        }
        if (inter.equals(current)) {
            return false;
        }
        this.internalSetBounds(inter.getFirstIndex(), inter.getLastIndex());
        return true;
    }

    @Override
    public T getMissingValue() {
        return this.missingValue;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        long last = this.getLastIndex();
        int count = 0;
        int max = 3;
        for (Observation o : this) {
            if (count < max || o.getIndex() == last) {
                b.append(o.toString());
                if (o.getIndex() != last) {
                    b.append(", ");
                }
            } else if (count == max) {
                b.append("..., ");
            }
            ++count;
        }
        return b.toString();
    }

    protected T normalizeMissingValue(T value) throws T2Exception {
        if (value == null) {
            if (this.missingValue == null) {
                return value;
            }
            throw T2Msg.exception("T5014", new Object[0]);
        }
        if (value.equals(this.missingValue)) {
            return this.missingValue;
        }
        return value;
    }

    protected int accept(TimeAddressable<T> updates, UpdateReviewer<T> reviewer) throws T2Exception {
        int rejected = 0;
        if (reviewer != null) {
            for (Observation<T> update : updates) {
                try {
                    if (reviewer.accept(this, update.getIndex(), update.getValue())) continue;
                    ++rejected;
                }
                catch (Exception e) {
                    throw T2Msg.exception(e, "T5031", update);
                }
            }
        }
        return rejected;
    }

    protected abstract long internalGetFirstIndex();

    protected abstract long internalGetLastIndex();

    protected abstract Observation<T> internalGetFirst(long var1) throws T2Exception;

    protected abstract Observation<T> internalGetLast(long var1) throws T2Exception;

    protected abstract void internalClear();

    protected abstract T internalGet(long var1) throws T2Exception;

    protected abstract int internalGetSize();

    protected abstract void internalPut(long var1, T var3) throws T2Exception;

    protected abstract void internalRemove(long var1) throws T2Exception;

    protected abstract void internalSetBounds(long var1, long var3) throws T2Exception;

    protected abstract Collection<T> internalGetData();
}

