/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Day;
import ch.agent.t2.time.DayOfWeek;
import ch.agent.t2.time.DefaultTimeFormatter;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.time.TimeParts;
import java.util.Arrays;

public class TimeTools {
    private static final long DAYS_IN_400_YEARS = 146097L;
    private static final int[] daysToMonthCommonYear = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] daysToMonthLeapYear = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};

    public static int daysInMonth(long year, int month) {
        int[] daysToMonth;
        int[] nArray = daysToMonth = TimeTools.isLeap(year) ? daysToMonthLeapYear : daysToMonthCommonYear;
        if (month == 12) {
            return 31;
        }
        return daysToMonth[month] - daysToMonth[month - 1];
    }

    public static int daysToMonth(long year, int month) {
        int[] daysToMonth = TimeTools.isLeap(year) ? daysToMonthLeapYear : daysToMonthCommonYear;
        return daysToMonth[month - 1];
    }

    public static boolean isLeap(long year) {
        if (year < 0L) {
            throw new IllegalArgumentException();
        }
        return year % 4L == 0L && year % 100L != 0L || year % 400L == 0L;
    }

    public static long leapYears(long year) {
        if (year < 0L) {
            throw new IllegalArgumentException();
        }
        if (year == 0L) {
            return 0L;
        }
        return 1L + --year / 4L - year / 100L + year / 400L;
    }

    public static int[] computeMonthAndDay(long year, int day) {
        int[] md = new int[2];
        int[] daysToMonth = TimeTools.isLeap(year) ? daysToMonthLeapYear : daysToMonthCommonYear;
        int i = Arrays.binarySearch(daysToMonth, day - 1);
        if (i >= 0) {
            md[0] = i + 1;
            md[1] = 1;
        } else {
            i = -i - 2;
            md[0] = i + 1;
            md[1] = day - daysToMonth[i];
        }
        return md;
    }

    public static TimeParts.HMSF computeHMS(long totalSeconds) {
        return TimeTools.computeHMS(totalSeconds, 0);
    }

    public static TimeParts.HMSF computeHMS(long totalSeconds, int subSeconds) {
        if (totalSeconds < 0L) {
            throw new IllegalArgumentException("totalSeconds negative");
        }
        if (subSeconds < 0) {
            throw new IllegalArgumentException("subSeconds negative");
        }
        long minutes = totalSeconds / 60L;
        int hours = (int)(minutes / 60L);
        return new TimeParts.HMSF(hours, (int)(minutes - (long)(hours * 60)), (int)(totalSeconds - minutes * 60L), subSeconds);
    }

    public static TimeParts.YMD computeYMD(long days) {
        if (days < 0L) {
            throw new IllegalArgumentException("" + days);
        }
        long y400Intervals = days / 146097L;
        int y400Remainder = (int)(days - y400Intervals * 146097L);
        int remainingYears = y400Remainder / 365;
        int dayOffset = y400Remainder - remainingYears * 365 - (int)TimeTools.leapYears(remainingYears);
        if (dayOffset < 0) {
            dayOffset += TimeTools.isLeap(--remainingYears) ? 366 : 365;
        }
        long y = y400Intervals * 400L + (long)remainingYears;
        int[] monthDay = TimeTools.computeMonthAndDay(y, dayOffset + 1);
        return new TimeParts.YMD(y, monthDay[0], monthDay[1]);
    }

    public static long makeRawIndex(Resolution unit, TimeParts tp) throws T2Exception {
        long time;
        block15: {
            time = 0L;
            long year = tp.getYear();
            int month = tp.getMonth();
            int day = tp.getDay();
            int hour = tp.getHour();
            int min = tp.getMin();
            int sec = tp.getSec();
            int fsec = tp.getFsec();
            if (year < 0L) {
                throw T2Msg.exception("T1014", year);
            }
            if (unit == Resolution.YEAR) {
                time = year;
            } else {
                try {
                    if (month < 1 || month > 12) {
                        throw T2Msg.exception("T1015", month);
                    }
                    if (unit == Resolution.MONTH) {
                        time = TimeTools.sum(TimeTools.prod(year, 12L), month - 1);
                        break block15;
                    }
                    int daysInThisMonth = TimeTools.daysInMonth(year, month);
                    if (day < 1 || day > daysInThisMonth) {
                        throw T2Msg.exception("T1016", day, daysInThisMonth);
                    }
                    time = TimeTools.sum(TimeTools.prod(year, 365L), TimeTools.leapYears(year) + (long)TimeTools.daysToMonth(year, month) + (long)day - 1L);
                    if (unit == Resolution.DAY) break block15;
                    if (hour == 24 && min == 0 && sec == 0 && fsec == 0) {
                        hour = 0;
                        ++time;
                    }
                    if (sec == 60) {
                        if (hour == 23 && min == 59 && fsec == 0 && month == 12 && day == 31 || month == 6 && day == 30) {
                            sec = 59;
                        } else {
                            throw T2Msg.exception("T1025", new Object[0]);
                        }
                    }
                    CompositeOverflowAndHMSU checkResult = TimeTools.checkTimeComponentsAndApplyTimeZoneOffset(unit, hour, min, sec, fsec, tp.getTZOffset());
                    time = TimeTools.sum(time, checkResult.overflow);
                    hour = checkResult.hmsu.h();
                    min = checkResult.hmsu.m();
                    sec = checkResult.hmsu.s();
                    fsec = checkResult.hmsu.f();
                    time = TimeTools.sum(TimeTools.prod(time, 24L), hour);
                    if (unit == Resolution.HOUR) break block15;
                    time = TimeTools.sum(TimeTools.prod(time, 60L), min);
                    if (unit == Resolution.MIN) break block15;
                    time = TimeTools.sum(TimeTools.prod(time, 60L), sec);
                    if (unit == Resolution.SEC) break block15;
                    if (unit == Resolution.MSEC) {
                        time = TimeTools.sum(TimeTools.prod(time, 1000L), fsec);
                        break block15;
                    }
                    if (unit == Resolution.USEC) {
                        time = TimeTools.sum(TimeTools.prod(time, 1000000L), fsec);
                        break block15;
                    }
                    if (unit == Resolution.NSEC) {
                        time = TimeTools.sum(TimeTools.prod(time, 1000000000L), fsec);
                        break block15;
                    }
                    throw new RuntimeException("bug: " + unit.name());
                }
                catch (ArithmeticException e) {
                    throw T2Msg.exception("T1079", new DefaultTimeFormatter(true).format(tp));
                }
            }
        }
        return time;
    }

    private static CompositeOverflowAndHMSU checkTimeComponentsAndApplyTimeZoneOffset(Resolution unit, int hour, int min, int sec, int fsec, TimeParts.TimeZoneOffset tzOffset) throws T2Exception {
        if (unit.compareTo(Resolution.HOUR) < 0) {
            throw new IllegalStateException("resolution too low for this method: " + unit.name());
        }
        if (hour < 0 || hour > 23) {
            throw T2Msg.exception("T1017", hour);
        }
        if (min < 0 || min > 59) {
            throw T2Msg.exception("T1019", min);
        }
        if (sec < 0 || sec > 59) {
            throw T2Msg.exception("T1022", sec);
        }
        if (!TimeParts.good(unit, fsec)) {
            throw T2Msg.exception("T1026", fsec);
        }
        int overflow = 0;
        if (tzOffset != null) {
            if (tzOffset.isNegative()) {
                switch (unit) {
                    case MSEC: {
                        if ((fsec -= tzOffset.getFsec()) <= 999) break;
                        fsec -= 1000;
                        ++sec;
                        break;
                    }
                    case USEC: {
                        if ((fsec -= tzOffset.getFsec()) <= 999999) break;
                        fsec -= 1000000;
                        ++sec;
                        break;
                    }
                    case NSEC: {
                        if ((fsec -= tzOffset.getFsec()) <= 999999999) break;
                        fsec -= 1000000000;
                        ++sec;
                        break;
                    }
                }
                if ((sec -= tzOffset.getSec()) > 59) {
                    sec -= 60;
                    ++min;
                }
                if ((min -= tzOffset.getMin()) > 59) {
                    min -= 60;
                    ++hour;
                }
                if ((hour -= tzOffset.getHour()) > 23) {
                    hour -= 24;
                    overflow = 1;
                }
            } else {
                switch (unit) {
                    case MSEC: {
                        if ((fsec -= tzOffset.getFsec()) >= 0) break;
                        fsec += 1000;
                        --sec;
                        break;
                    }
                    case USEC: {
                        if ((fsec -= tzOffset.getFsec()) >= 0) break;
                        fsec += 1000000;
                        --sec;
                        break;
                    }
                    case NSEC: {
                        if ((fsec -= tzOffset.getFsec()) >= 0) break;
                        fsec += 1000000000;
                        --sec;
                        break;
                    }
                }
                if ((sec -= tzOffset.getSec()) < 0) {
                    sec += 60;
                    --min;
                }
                if ((min -= tzOffset.getMin()) < 0) {
                    min += 60;
                    --hour;
                }
                if ((hour -= tzOffset.getHour()) < 0) {
                    hour += 24;
                    overflow = -1;
                }
            }
            tzOffset = null;
        }
        return new CompositeOverflowAndHMSU(overflow, new TimeParts.HMSF(hour, min, sec, fsec));
    }

    public static long dayIndex(Resolution unit, long time) throws T2Exception {
        long dayIndex;
        switch (unit) {
            case DAY: {
                dayIndex = time;
                break;
            }
            case HOUR: {
                dayIndex = time / 24L;
                break;
            }
            case MIN: {
                dayIndex = time / 1440L;
                break;
            }
            case SEC: {
                dayIndex = time / 86400L;
                break;
            }
            case MSEC: {
                dayIndex = time / 86400000L;
                break;
            }
            case USEC: {
                dayIndex = time / 86400000000L;
                break;
            }
            case NSEC: {
                dayIndex = time / 86400000000000L;
                break;
            }
            default: {
                throw T2Msg.exception("T1060", new Object[]{unit});
            }
        }
        return dayIndex;
    }

    public static DayOfWeek getDayOfWeek(Resolution unit, long time) throws T2Exception {
        int day = (int)(TimeTools.dayIndex(unit, time) % 7L);
        day = day == 0 ? 6 : --day;
        return DayOfWeek.values()[day];
    }

    public static int getDayByRank(long year, int month, DayOfWeek name, int rank) throws T2Exception {
        int week1Offset;
        int daysInPeriod;
        int max = 5;
        if (month == 0) {
            max = 53;
        }
        if (rank == 0 || rank < -max || rank > max) {
            throw T2Msg.exception("T1051", rank, -max, max);
        }
        if (month == 0) {
            month = 1;
            daysInPeriod = TimeTools.isLeap(year) ? 366 : 365;
        } else {
            daysInPeriod = TimeTools.daysInMonth(year, month);
        }
        Day t = new Day(year, month, 1);
        DayOfWeek firstOfPeriod = t.getDayOfWeek();
        int workRank = rank;
        if (workRank < 0) {
            workRank = max;
        }
        if ((week1Offset = name.ordinal() - firstOfPeriod.ordinal()) < 0) {
            week1Offset += 7;
        }
        int dayOfPeriod = 1 + week1Offset + (workRank - 1) * 7;
        if (rank < 0) {
            if (dayOfPeriod > daysInPeriod) {
                dayOfPeriod -= 7;
            }
            if ((dayOfPeriod += (rank + 1) * 7) < 0) {
                dayOfPeriod = 0;
            }
        } else if (dayOfPeriod > daysInPeriod) {
            dayOfPeriod = 0;
        }
        return dayOfPeriod;
    }

    public static Day getDayOfMonthByRank(TimeIndex time, DayOfWeek dayName, int rank) throws T2Exception {
        int m;
        if (time.getTimeDomain().compareResolutionTo(Resolution.MONTH) > 0) {
            throw T2Msg.exception("T1059", time.toString(), Resolution.MONTH.name());
        }
        long y = time.getYear();
        int day = TimeTools.getDayByRank(y, m = time.getMonth(), dayName, rank);
        return day == 0 ? null : new Day(y, m, day);
    }

    public static Day getDayOfYearByRank(TimeIndex time, DayOfWeek dayName, int rank) throws T2Exception {
        long y = time.getYear();
        int yearDay = TimeTools.getDayByRank(y, 0, dayName, rank);
        if (yearDay == 0) {
            return null;
        }
        int[] md = TimeTools.computeMonthAndDay(y, yearDay);
        return new Day(y, md[0], md[1]);
    }

    public static long sum(long a, long b) {
        long sum = a + b;
        if (a > 0L && b > 0L && sum < 0L || a < 0L && b > 0L && sum > 0L) {
            throw new ArithmeticException(a + "+" + b + " cannot be represented in a long integer");
        }
        return sum;
    }

    public static long diff(long a, long b) {
        long diff = a - b;
        if (a > 0L && b < 0L && diff < 0L || a < 0L && b > 0L && diff > 0L) {
            throw new ArithmeticException(a + "-" + b + " cannot be represented in a long integer");
        }
        return diff;
    }

    public static long prod(long a, long b) {
        long prod = a * b;
        if ((Math.abs(a) | Math.abs(b)) >>> 31 != 0L && (b != 0L && prod / b != a || b == -1L && a == Long.MIN_VALUE)) {
            throw new ArithmeticException(a + "*" + b + " cannot be represented in a long integer");
        }
        return prod;
    }

    private static class CompositeOverflowAndHMSU {
        int overflow;
        TimeParts.HMSF hmsu;

        public CompositeOverflowAndHMSU(int overflow, TimeParts.HMSF hmsu) {
            this.overflow = overflow;
            this.hmsu = hmsu;
        }
    }
}

