/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Resolution;

public class TimeParts {
    private final Resolution unit;
    private final long year;
    private final int month;
    private final int day;
    private final int hour;
    private final int min;
    private final int sec;
    private final int fsec;
    private final TimeZoneOffset timeZoneOffset;

    static boolean good(Resolution unit, int fsec) {
        boolean good = false;
        if (fsec >= 0) {
            switch (unit) {
                case MSEC: {
                    good = fsec < 1000;
                    break;
                }
                case USEC: {
                    good = fsec < 1000000;
                    break;
                }
                case NSEC: {
                    good = fsec < 1000000000;
                    break;
                }
                default: {
                    good = fsec == 0;
                }
            }
        }
        return good;
    }

    public TimeParts(Resolution unit, long year, int month, int day, int hour, int min, int sec, int fsec, TimeZoneOffset tzOffset) {
        if (unit == null) {
            throw new IllegalArgumentException("unit null");
        }
        if (unit.compareTo(Resolution.MSEC) < 0) {
            fsec = 0;
            if (unit.compareTo(Resolution.SEC) < 0) {
                sec = 0;
                if (unit.compareTo(Resolution.MIN) < 0) {
                    min = 0;
                    if (unit.compareTo(Resolution.HOUR) < 0) {
                        hour = 0;
                        tzOffset = null;
                        if (unit.compareTo(Resolution.DAY) < 0) {
                            day = 1;
                            if (unit.compareTo(Resolution.MONTH) < 0) {
                                month = 1;
                            }
                        }
                    }
                }
            }
        }
        this.unit = unit;
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.fsec = fsec;
        this.timeZoneOffset = tzOffset;
    }

    public TimeParts(Resolution unit, long year, int month, int day, int hour, int min, int sec, int fsec) {
        this(unit, year, month, day, hour, min, sec, fsec, null);
    }

    public Resolution getResolution() {
        return this.unit;
    }

    public long getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMin() {
        return this.min;
    }

    public int getSec() {
        return this.sec;
    }

    public int getFsec() {
        return this.fsec;
    }

    public int getFsec(Resolution targetUnit) {
        int result = this.fsec;
        block0 : switch (this.unit) {
            case MSEC: {
                switch (targetUnit) {
                    case MSEC: {
                        break block0;
                    }
                    case USEC: {
                        result = this.fsec * 1000;
                        break block0;
                    }
                    case NSEC: {
                        result = this.fsec * 1000 * 1000;
                        break block0;
                    }
                }
                result = 0;
                break;
            }
            case USEC: {
                switch (targetUnit) {
                    case MSEC: {
                        result = this.fsec / 1000;
                        break block0;
                    }
                    case USEC: {
                        break block0;
                    }
                    case NSEC: {
                        result = this.fsec * 1000;
                        break block0;
                    }
                }
                result = 0;
                break;
            }
            case NSEC: {
                switch (targetUnit) {
                    case MSEC: {
                        result = this.fsec / 1000000;
                        break block0;
                    }
                    case USEC: {
                        result = this.fsec / 1000;
                        break block0;
                    }
                    case NSEC: {
                        break block0;
                    }
                }
                result = 0;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    public TimeZoneOffset getTZOffset() {
        return this.timeZoneOffset;
    }

    public String toString() {
        return String.format("%04d-%02d-%02d %02d:%02d:%02d.%06d", (this.unit == Resolution.NSEC ? 2000L : 0L) + this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMin(), this.getSec(), this.getFsec());
    }

    public static class TimeZoneOffset {
        private final int hour;
        private final int min;
        private final int sec;
        private final int fsec;
        private final int sign;

        public TimeZoneOffset(Resolution unit, boolean negative, int hour, int min, int sec, int fsec) throws T2Exception {
            if (unit == null) {
                throw new IllegalArgumentException("unit null");
            }
            if (unit.compareTo(Resolution.MSEC) < 0) {
                fsec = 0;
                if (unit.compareTo(Resolution.SEC) < 0) {
                    sec = 0;
                    if (unit.compareTo(Resolution.MIN) < 0) {
                        min = 0;
                        if (unit.compareTo(Resolution.HOUR) < 0) {
                            hour = 0;
                        }
                    }
                }
            }
            int n = this.sign = negative ? -1 : 1;
            if (hour < 0 || hour > 11) {
                throw T2Msg.exception("T1018", hour);
            }
            this.hour = this.sign * hour;
            if (min < 0 || min > 59) {
                throw T2Msg.exception("T1021", min);
            }
            this.min = this.sign * min;
            if (sec < 0 || sec > 59) {
                throw T2Msg.exception("T1023", sec);
            }
            this.sec = this.sign * sec;
            if (!TimeParts.good(unit, fsec)) {
                throw T2Msg.exception("T1027", fsec);
            }
            this.fsec = this.sign * fsec;
        }

        public boolean isNegative() {
            return this.sign < 0;
        }

        public int getHour() {
            return this.hour;
        }

        public int getMin() {
            return this.min;
        }

        public int getSec() {
            return this.sec;
        }

        public int getFsec() {
            return this.fsec;
        }

        public String toString() {
            return String.format("%d:%d:%d.%d", this.hour, this.min, this.sec, this.fsec);
        }
    }

    public static class HMSF {
        private final int h;
        private final int m;
        private final int s;
        private final int f;

        public HMSF(int h, int m, int s, int f) {
            this.h = h;
            this.m = m;
            this.s = s;
            this.f = f;
        }

        public int h() {
            return this.h;
        }

        public int m() {
            return this.m;
        }

        public int s() {
            return this.s;
        }

        public int f() {
            return this.f;
        }

        public String toString() {
            return this.f == 0 ? String.format("%02d:%02d:%02d", this.h, this.m, this.s) : String.format("%02d:%02d:%02d.%d", this.h, this.m, this.s, this.f);
        }
    }

    public static class YMD {
        private final long y;
        private final int m;
        private final int d;

        public YMD(long y, int m, int d) {
            this.y = y;
            this.m = m;
            this.d = d;
        }

        public long y() {
            return this.y;
        }

        public int m() {
            return this.m;
        }

        public int d() {
            return this.d;
        }

        public String toString() {
            return String.format("%04d-%02d-%02d", this.y, this.m, this.d);
        }
    }
}

