/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.BasePeriodPattern;
import ch.agent.t2.time.DayOfWeek;
import ch.agent.t2.time.DefaultTimeFormatter;
import ch.agent.t2.time.DefaultTimeScanner;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.SubPeriodPattern;
import ch.agent.t2.time.Time2;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeDomainDefinition;
import ch.agent.t2.time.TimeFormatter;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.time.TimePacker;
import ch.agent.t2.time.TimeParts;
import ch.agent.t2.time.TimeScanner;
import ch.agent.t2.time.TimeTools;

public class TimeFactory
implements TimeDomain,
TimePacker,
TimeFormatter,
TimeScanner {
    private int hash = 0;
    private String label;
    private Resolution baseUnit;
    private long origin;
    private BasePeriodPattern basePeriodPattern;
    private SubPeriodPattern subPeriodPattern;
    private TimeIndex minTime;
    private TimeIndex maxTime;
    private TimeIndex minOffsetCompatibleTime;
    private TimeIndex maxOffsetCompatibleTime;
    private long min;
    private long max;
    private final TimeFormatter formatter;
    private final TimeScanner scanner;

    public TimeFactory(TimeDomainDefinition def, TimeFormatter formatter, TimeScanner scanner) {
        if (def == null) {
            throw new IllegalArgumentException("def null");
        }
        if (formatter == null) {
            throw new IllegalArgumentException("formatter null");
        }
        this.label = def.getLabel();
        this.baseUnit = def.getBaseUnit();
        this.origin = def.getOrigin();
        this.basePeriodPattern = def.getBasePeriodPattern();
        if (this.basePeriodPattern != null && !this.basePeriodPattern.effective()) {
            this.basePeriodPattern = null;
        }
        this.subPeriodPattern = def.getSubPeriodPattern();
        this.min = 0L;
        this.max = this.findMaxIndex(this.basePeriodPattern, this.subPeriodPattern);
        this.formatter = formatter;
        this.scanner = scanner;
        this.minTime = new Time2((TimeDomain)this, this.min);
        this.maxTime = new Time2((TimeDomain)this, this.max);
        this.minOffsetCompatibleTime = new Time2((TimeDomain)this, this.getOrigin());
        this.maxOffsetCompatibleTime = new Time2((TimeDomain)this, Integer.MAX_VALUE + this.getOrigin());
    }

    public TimeFactory(TimeDomainDefinition def) {
        this(def, new DefaultTimeFormatter(), new DefaultTimeScanner());
    }

    public TimeFactory(TimeDomainDefinition def, TimeFormatter formatter) {
        this(def, formatter, new DefaultTimeScanner());
    }

    @Override
    public TimePacker getPacker() {
        return this;
    }

    @Override
    public TimeFormatter getFormatter() {
        return this;
    }

    @Override
    public TimeScanner getScanner() {
        return this;
    }

    @Override
    public String getLabel() {
        return this.label != null ? this.label : this.toString();
    }

    @Override
    public long getOrigin() {
        return this.origin;
    }

    @Override
    public Resolution getResolution() {
        if (this.subPeriodPattern != null) {
            return this.subPeriodPattern.getSubPeriod();
        }
        return this.baseUnit;
    }

    @Override
    public int compareResolutionTo(Resolution unit) {
        return -this.getResolution().compareTo(unit);
    }

    @Override
    public void requireEquality(TimeDomain domain) throws T2Exception {
        if (!this.equals(domain)) {
            throw T2Msg.exception("T1074", this.getLabel(), domain.getLabel());
        }
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    private boolean equalsIgnoringLabel(TimeFactory domain) {
        if (!domain.baseUnit.equals((Object)this.baseUnit)) {
            return false;
        }
        if (domain.origin != this.origin) {
            return false;
        }
        if (!this.equals(this.basePeriodPattern, domain.basePeriodPattern)) {
            return false;
        }
        return this.equals(this.subPeriodPattern, domain.subPeriodPattern);
    }

    @Override
    public boolean similar(TimeDomain domain) {
        if (this == domain) {
            return true;
        }
        if (domain == null) {
            return false;
        }
        if (this.getClass() != domain.getClass()) {
            return false;
        }
        return this.equalsIgnoringLabel((TimeFactory)domain);
    }

    public int hashCode() {
        if (this.hash == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.basePeriodPattern == null ? 0 : this.basePeriodPattern.hashCode());
            result = 31 * result + (this.baseUnit == null ? 0 : this.baseUnit.hashCode());
            result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
            result = 31 * result + (int)(this.origin ^ this.origin >>> 32);
            this.hash = result = 31 * result + (this.subPeriodPattern == null ? 0 : this.subPeriodPattern.hashCode());
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!this.equals(this.label, ((TimeFactory)obj).label)) {
            return false;
        }
        return this.equalsIgnoringLabel((TimeFactory)obj);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("L=" + this.label);
        s.append(" O=" + this.origin);
        s.append(" U=" + (Object)((Object)this.baseUnit));
        s.append(" P=" + this.basePeriodPattern);
        s.append(" S=" + this.subPeriodPattern);
        return s.toString();
    }

    @Override
    public TimeIndex time(long year, int month, int day, int hour, int min, int sec, int usec, Adjustment adjust) throws T2Exception {
        return new Time2(this, year, month, day, hour, min, sec, usec, adjust);
    }

    @Override
    public TimeIndex time(String date) throws T2Exception {
        return new Time2((TimeDomain)this, date, Adjustment.NONE);
    }

    @Override
    public TimeIndex time(String date, Adjustment adjust) throws T2Exception {
        return new Time2((TimeDomain)this, date, adjust);
    }

    @Override
    public TimeIndex minTime() {
        return this.minTime(false);
    }

    @Override
    public TimeIndex maxTime() {
        return this.maxTime(false);
    }

    @Override
    public TimeIndex minTime(boolean offsetCompatible) {
        return offsetCompatible ? this.minOffsetCompatibleTime : this.minTime;
    }

    @Override
    public TimeIndex maxTime(boolean offsetCompatible) {
        return offsetCompatible ? this.maxOffsetCompatibleTime : this.maxTime;
    }

    @Override
    public TimeIndex time(long index) {
        return new Time2((TimeDomain)this, index);
    }

    @Override
    public TimeIndex timeFromOffset(long offset) {
        return new Time2((TimeDomain)this, offset + this.getOrigin());
    }

    @Override
    public boolean valid(long t, boolean testOnly) throws T2Exception {
        if (t >= this.min && t <= this.max) {
            return true;
        }
        if (testOnly) {
            return false;
        }
        throw T2Msg.exception("T1070", t);
    }

    @Override
    public BasePeriodPattern getBasePeriodPattern() {
        return this.basePeriodPattern;
    }

    @Override
    public SubPeriodPattern getSubPeriodPattern() {
        return this.subPeriodPattern;
    }

    @Override
    public TimeParts scan(Resolution unit, String time) throws T2Exception {
        return this.scanner.scan(unit, time);
    }

    @Override
    public String format(TimeParts timeParts) {
        return this.formatter.format(timeParts);
    }

    @Override
    public long pack(TimeParts tp, Adjustment adjust) throws T2Exception {
        try {
            long time = TimeTools.makeRawIndex(this.baseUnit, tp);
            if (this.subPeriodPattern == null) {
                time = this.compress(time, adjust);
            } else {
                time = this.compress(time, Adjustment.NONE);
                time = this.subPeriodPattern.adjustForSubPeriod(time, adjust, tp);
            }
            return time;
        }
        catch (T2Exception e) {
            String messageKey = this.subPeriodPattern == null ? "T1068" : "T1069";
            throw T2Msg.exception(e, messageKey, tp.toString(), this.getLabel());
        }
    }

    @Override
    public TimeParts unpack(long time) {
        int subPeriod = 0;
        if (this.subPeriodPattern != null) {
            int sz = this.subPeriodPattern.getSize();
            long orig = time;
            subPeriod = (int)(orig - (time /= (long)sz) * (long)sz);
        }
        if (this.basePeriodPattern != null) {
            time = this.basePeriodPattern.expandIndex(time);
        }
        Resolution unit = this.baseUnit;
        TimeParts.YMD ymd = null;
        TimeParts.HMSF hmsu = null;
        switch (unit) {
            case YEAR: {
                ymd = new TimeParts.YMD(time, 1, 1);
                break;
            }
            case MONTH: {
                long year = time / 12L;
                ymd = new TimeParts.YMD(year, (int)(time - year * 12L) + 1, 1);
                break;
            }
            case DAY: {
                ymd = TimeTools.computeYMD(time);
                break;
            }
            case HOUR: {
                long days = time / 24L;
                hmsu = new TimeParts.HMSF((int)(time - days * 24L), 0, 0, 0);
                ymd = TimeTools.computeYMD(days);
                break;
            }
            case MIN: {
                long days = time / 1440L;
                long minutes = time - days * 24L * 60L;
                int hours = (int)(minutes / 60L);
                hmsu = new TimeParts.HMSF(hours, (int)(minutes - (long)(hours * 60)), 0, 0);
                ymd = TimeTools.computeYMD(days);
                break;
            }
            case SEC: {
                long days = time / 86400L;
                long seconds = time - days * 24L * 60L * 60L;
                ymd = TimeTools.computeYMD(days);
                hmsu = TimeTools.computeHMS(seconds);
                break;
            }
            case MSEC: {
                long days = time / 86400000L;
                long millis = time - days * 24L * 60L * 60L * 1000L;
                long seconds = millis / 1000L;
                ymd = TimeTools.computeYMD(days);
                hmsu = TimeTools.computeHMS(seconds, (int)(millis - seconds * 1000L));
                break;
            }
            case USEC: {
                long days = time / 86400000000L;
                long micros = time - days * 24L * 60L * 60L * 1000000L;
                long seconds = micros / 1000000L;
                ymd = TimeTools.computeYMD(days);
                hmsu = TimeTools.computeHMS(seconds, (int)(micros - seconds * 1000000L));
                break;
            }
            case NSEC: {
                long days = time / 86400000000000L;
                long nanos = time - days * 24L * 60L * 60L * 1000000000L;
                long seconds = nanos / 1000000000L;
                ymd = TimeTools.computeYMD(days);
                hmsu = TimeTools.computeHMS(seconds, (int)(nanos - seconds * 1000000000L));
                break;
            }
            default: {
                throw new RuntimeException("bug: " + unit.name());
            }
        }
        TimeParts tp = this.makeTimeParts(unit, ymd, hmsu);
        if (this.subPeriodPattern != null) {
            tp = this.subPeriodPattern.fillInSubPeriod(subPeriod, tp);
        }
        return tp;
    }

    private TimeParts makeTimeParts(Resolution unit, TimeParts.YMD ymd, TimeParts.HMSF hmsu) {
        return hmsu == null ? new TimeParts(unit, ymd.y(), ymd.m(), ymd.d(), 0, 0, 0, 0) : new TimeParts(unit, ymd.y(), ymd.m(), ymd.d(), hmsu.h(), hmsu.m(), hmsu.s(), hmsu.f());
    }

    @Override
    public DayOfWeek getDayOfWeek(TimeIndex time) throws T2Exception {
        if (this.subPeriodPattern != null) {
            if (this.compareResolutionTo(Resolution.DAY) <= 0) {
                long numTime = TimeTools.makeRawIndex(Resolution.DAY, ((Time2)time).getTimeParts());
                return TimeTools.getDayOfWeek(Resolution.DAY, numTime);
            }
            throw T2Msg.exception("T1060", new Object[]{this.getResolution()});
        }
        long t = this.basePeriodPattern == null ? time.asLong() : this.basePeriodPattern.expandIndex(time.asLong());
        return TimeTools.getDayOfWeek(this.getResolution(), t);
    }

    @Override
    public int getBasePeriodSize() {
        return this.subPeriodPattern == null ? 1 : this.subPeriodPattern.getSize();
    }

    @Override
    public TimeIndex getBasePeriodStart(TimeIndex t) {
        if (t == null) {
            throw new IllegalArgumentException("t null");
        }
        if (!t.getTimeDomain().equals(this)) {
            throw new IllegalArgumentException(new T2Msg("T0017", t.getTimeDomain().getLabel(), this.getLabel()).toString());
        }
        long size = this.getPacker().getBasePeriodSize();
        long boundary = t.asLong() / size * size;
        return boundary == t.asLong() ? t : this.time(boundary);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long compress(long time, Adjustment adjust) throws T2Exception {
        if (this.basePeriodPattern != null) {
            if (time < 0L) {
                throw T2Msg.exception("T1070", time);
            }
            if (adjust == Adjustment.NONE) {
                return this.basePeriodPattern.makeIndex(time);
            }
            while (true) {
                try {
                    return this.basePeriodPattern.makeIndex(time);
                }
                catch (T2Exception e) {
                    time = this.adjust(time, adjust == Adjustment.UP);
                    continue;
                }
                break;
            }
        }
        this.valid(time, false);
        return time;
    }

    private long adjust(long time, boolean up) throws T2Exception {
        long result = time;
        result = up ? ++result : --result;
        if (result < 0L && time > 0L || result > 0L && time < 0L) {
            throw T2Msg.exception("T1072", new Object[0]);
        }
        return result;
    }

    private long findMaxIndex(BasePeriodPattern basePattern, SubPeriodPattern subPattern) {
        long maxIndex = Long.MAX_VALUE;
        if (subPattern != null) {
            maxIndex /= (long)subPattern.getSize();
        }
        if (basePattern != null) {
            for (int i = 0; i < basePattern.getSize(); ++i) {
                try {
                    return basePattern.makeIndex(maxIndex - (long)i);
                }
                catch (T2Exception e) {
                    continue;
                }
            }
            throw new RuntimeException("bug: " + maxIndex);
        }
        return maxIndex;
    }
}

