/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.time.BasePeriodPattern;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.SubPeriodPattern;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeFactory;

public class TimeDomainDefinition {
    private final String label;
    private final Resolution baseUnit;
    private final long origin;
    private final BasePeriodPattern basePeriodPattern;
    private final SubPeriodPattern subPeriodPattern;
    private TimeDomain cached;

    public TimeDomainDefinition(String label, Resolution baseUnit, long origin, BasePeriodPattern basePattern, SubPeriodPattern subPattern) {
        if (baseUnit == null) {
            throw new IllegalArgumentException("resolution null");
        }
        if (subPattern != null && !baseUnit.equals((Object)subPattern.getBasePeriod())) {
            throw new IllegalArgumentException("resolution of sub pattern differs base resolution");
        }
        this.label = label;
        this.baseUnit = baseUnit;
        this.origin = origin;
        this.basePeriodPattern = basePattern;
        this.subPeriodPattern = subPattern;
    }

    public TimeDomainDefinition(String label, Resolution baseUnit, long origin, BasePeriodPattern basePattern) {
        this(label, baseUnit, origin, basePattern, null);
    }

    public TimeDomainDefinition(String label, Resolution baseUnit, long origin) {
        this(label, baseUnit, origin, null, null);
    }

    protected TimeDomain getCached() {
        return this.cached;
    }

    protected void setCached(TimeDomain cached) {
        this.cached = cached;
    }

    public TimeDomain asTimeDomain() {
        if (this.getCached() == null) {
            this.setCached(new TimeFactory(this));
        }
        return this.getCached();
    }

    public String getLabel() {
        return this.label;
    }

    public long getOrigin() {
        return this.origin;
    }

    public Resolution getBaseUnit() {
        return this.baseUnit;
    }

    public BasePeriodPattern getBasePeriodPattern() {
        return this.basePeriodPattern;
    }

    public SubPeriodPattern getSubPeriodPattern() {
        return this.subPeriodPattern;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("L=" + this.label);
        s.append(" O=" + this.origin);
        s.append(" U=" + (Object)((Object)this.baseUnit));
        s.append(" P=" + this.basePeriodPattern);
        s.append(" S=" + this.subPeriodPattern);
        return s.toString();
    }
}

