/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.DayOfWeek;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeDomainDefinition;
import ch.agent.t2.time.TimeFactory;
import ch.agent.t2.time.TimeFormatter;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.time.TimeParts;
import ch.agent.t2.time.TimeTools;
import java.util.Formatter;

public class Time2
implements TimeIndex {
    private int hash;
    private TimeDomain domain;
    private final long time;
    private TimeParts timeParts;

    public Time2(TimeDomain domain, long time) {
        if (domain == null) {
            throw new IllegalArgumentException("domain null");
        }
        this.domain = domain;
        try {
            this.domain.getPacker().valid(time, false);
        }
        catch (T2Exception e) {
            throw new IllegalArgumentException("time", e);
        }
        this.time = time;
    }

    public Time2(TimeDomain domain, long year, int month, int day, int hour, int min, int sec, int fsec, Adjustment adjust) throws T2Exception {
        this(domain, domain.getPacker().pack(new TimeParts(domain.getResolution(), year, month, day, hour, min, sec, fsec), adjust));
    }

    public Time2(TimeDomain domain, TimeParts timeParts, Adjustment adjust) throws T2Exception {
        this(domain, domain.getPacker().pack(timeParts, adjust));
    }

    public Time2(TimeDomain domain, String time, Adjustment adjustment) throws T2Exception {
        this(domain, domain.getScanner().scan(domain.getResolution(), time), adjustment);
    }

    public Time2(TimeDomain domain, String time) throws T2Exception {
        this(domain, time, Adjustment.NONE);
    }

    @Override
    public TimeIndex convert(TimeDomain domain) throws T2Exception {
        return this.convert(domain, Adjustment.NONE);
    }

    @Override
    public TimeIndex convert(TimeDomain domain, Adjustment adjustment) throws T2Exception {
        if (this.getTimeDomain().equals(domain)) {
            return this;
        }
        TimeParts tp = this.getTP();
        tp = new TimeParts(domain.getResolution(), tp.getYear(), tp.getMonth(), tp.getDay(), tp.getHour(), tp.getMin(), tp.getSec(), tp.getFsec(domain.getResolution()), tp.getTZOffset());
        return new Time2(domain, tp, adjustment);
    }

    @Override
    public TimeDomain getTimeDomain() {
        return this.domain;
    }

    @Override
    public long asLong() {
        return this.getInternalTime();
    }

    @Override
    public int asOffset() throws T2Exception {
        long time = this.getInternalTime() - this.domain.getOrigin();
        if (time < Integer.MIN_VALUE || time > Integer.MAX_VALUE) {
            throw T2Msg.exception("T1076", new Object[]{this.domain.getResolution(), time});
        }
        return (int)time;
    }

    @Override
    public TimeIndex add(long increment) throws T2Exception {
        long sum = 0L;
        try {
            sum = TimeTools.sum(this.asLong(), increment);
            this.domain.getPacker().valid(sum, false);
        }
        catch (Exception e) {
            throw T2Msg.exception(e, "T1075", this.toString(), increment);
        }
        return new Time2(this.domain, sum);
    }

    @Override
    public long sub(TimeIndex time) throws T2Exception {
        if (this.getTimeDomain().equals(time.getTimeDomain())) {
            try {
                return TimeTools.diff(this.asLong(), time.asLong());
            }
            catch (Exception e) {
                throw T2Msg.exception(e, "T1078", time.toString(), this.toString());
            }
        }
        throw T2Msg.exception("T1077", time.toString(), this.toString(), time.getTimeDomain().getLabel(), this.getTimeDomain().getLabel());
    }

    TimeParts getTimeParts() {
        return this.getTP();
    }

    @Override
    public long getYear() {
        return this.getTP().getYear();
    }

    @Override
    public int getMonth() {
        return this.getTP().getMonth();
    }

    @Override
    public int getDay() {
        return this.getTP().getDay();
    }

    @Override
    public int getHour() {
        return this.getTP().getHour();
    }

    @Override
    public int getMinute() {
        return this.getTP().getMin();
    }

    @Override
    public int getSecond() {
        return this.getTP().getSec();
    }

    @Override
    public int getFractionalSecond() {
        return this.getTP().getFsec();
    }

    @Override
    public DayOfWeek getDayOfWeek() throws T2Exception {
        return this.domain.getPacker().getDayOfWeek(this);
    }

    @Override
    public TimeIndex getDayByRank(Resolution basePeriod, DayOfWeek day, int rank) throws T2Exception {
        switch (basePeriod) {
            case MONTH: {
                return TimeTools.getDayOfMonthByRank(this, day, rank);
            }
            case YEAR: {
                return TimeTools.getDayOfYearByRank(this, day, rank);
            }
        }
        throw T2Msg.exception("T1052", basePeriod.name());
    }

    @Override
    public String toString(TimeFormatter formatter) {
        return formatter == null ? this.domain.getFormatter().format(this.getTP()) : formatter.format(this.getTP());
    }

    @Override
    public String toString(String format) {
        if (format == null) {
            return this.toString();
        }
        TimeParts tp = this.getTP();
        if (format.length() == 0) {
            String yy = tp.getYear() + "";
            if (yy.length() >= 3) {
                yy = yy.substring(2);
            }
            return String.format("%d.%d.%s", tp.getDay(), tp.getMonth(), yy);
        }
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format(format, tp.getYear(), tp.getMonth(), tp.getDay(), tp.getHour(), tp.getMin(), tp.getSec(), tp.getFsec());
        fmt.close();
        return sb.toString();
    }

    public String toString() {
        return this.toString((TimeFormatter)null);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Time2)) {
            return false;
        }
        return this.asLong() == ((Time2)obj).asLong() && this.domain.equals(((Time2)obj).getTimeDomain());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 31 * this.domain.hashCode() + new Long(this.asLong()).hashCode();
        }
        return this.hash;
    }

    @Override
    public int compareTo(TimeIndex otherTime) {
        if (otherTime == null) {
            throw new IllegalArgumentException("t null");
        }
        if (otherTime.getTimeDomain().equals(this.getTimeDomain())) {
            long l2;
            long l1 = this.asLong();
            if (l1 < (l2 = otherTime.asLong())) {
                return -1;
            }
            if (l1 > l2) {
                return 1;
            }
            return 0;
        }
        int compareResols = this.getTimeDomain().getResolution().compareTo(otherTime.getTimeDomain().getResolution());
        if (compareResols == 0) {
            TimeDomainDefinition def = new TimeDomainDefinition(null, this.getTimeDomain().getResolution(), 0L);
            TimeFactory unrestrictedDomain = new TimeFactory(def);
            TimeIndex converted = this.convertOrThrowRTE(unrestrictedDomain, this);
            TimeIndex otherConverted = this.convertOrThrowRTE(unrestrictedDomain, otherTime);
            return converted.compareTo(otherConverted);
        }
        if (compareResols < 0) {
            TimeDomainDefinition def = new TimeDomainDefinition(null, otherTime.getTimeDomain().getResolution(), 0L);
            TimeFactory unrestrictedDomain = new TimeFactory(def);
            TimeIndex converted = this.convertOrThrowRTE(unrestrictedDomain, this);
            return converted.compareTo(otherTime);
        }
        TimeDomainDefinition def = new TimeDomainDefinition(null, this.getTimeDomain().getResolution(), 0L);
        TimeFactory unrestrictedDomain = new TimeFactory(def);
        TimeIndex otherConverted = this.convertOrThrowRTE(unrestrictedDomain, otherTime);
        return this.compareTo(otherConverted);
    }

    private TimeIndex convertOrThrowRTE(TimeDomain domain, TimeIndex time) {
        try {
            return time.convert(domain);
        }
        catch (T2Exception e) {
            T2Exception cause = T2Msg.exception(e, "T0005", time.toString(), domain);
            throw T2Msg.runtimeException("T0001", cause);
        }
    }

    private long getInternalTime() {
        return this.time;
    }

    private TimeParts getTP() {
        if (this.timeParts == null) {
            this.timeParts = this.domain.getPacker().unpack(this.getInternalTime());
        }
        return this.timeParts;
    }
}

