/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeDomainCatalog;
import ch.agent.t2.time.TimeDomainDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public abstract class ImmutableTimeDomainCatalog
implements TimeDomainCatalog {
    private final Map<String, TimeDomain> domains = new HashMap<String, TimeDomain>();

    public ImmutableTimeDomainCatalog(TimeDomain ... domains) {
        int i = 0;
        for (TimeDomain domain : domains) {
            ++i;
            try {
                String label = this.verify(i, domain);
                this.domains.put(label, domain);
            }
            catch (Exception e) {
                throw T2Msg.runtimeException("T0001", e);
            }
        }
    }

    private String verify(int i, TimeDomain domain) throws T2Exception {
        String label = domain.getLabel();
        if (label == null || label.length() == 0) {
            throw T2Msg.exception("T0014", i);
        }
        if (this.domains.containsKey(label)) {
            throw T2Msg.exception("T0015", i, label);
        }
        for (TimeDomain d : this.domains.values()) {
            if (!domain.similar(d)) continue;
            throw T2Msg.exception("T0016", label, d.getLabel());
        }
        return label;
    }

    @Override
    public Collection<TimeDomain> get() {
        ArrayList<TimeDomain> d = new ArrayList<TimeDomain>(this.domains.size());
        d.addAll(this.domains.values());
        return d;
    }

    @Override
    public TimeDomain get(String label) throws T2Exception {
        TimeDomain domain = this.domains.get(label);
        if (domain == null) {
            throw T2Msg.exception("T0006", label, this.getTimeDomainLabels().toString());
        }
        return domain;
    }

    @Override
    public TimeDomain get(TimeDomainDefinition def) {
        TimeDomain domain = null;
        for (TimeDomain d : this.domains.values()) {
            if (!d.similar(def.asTimeDomain())) continue;
            domain = d;
            break;
        }
        return domain;
    }

    private Collection<String> getTimeDomainLabels() {
        TreeSet<String> labels = new TreeSet<String>();
        for (String label : this.domains.keySet()) {
            labels.add(label);
        }
        return labels;
    }
}

