/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.TimeParts;
import ch.agent.t2.time.TimeScanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultTimeScanner
implements TimeScanner {
    private static final Pattern PATTERN_1 = Pattern.compile("((?:\\+\\d+)?\\d\\d\\d\\d)(?:-(\\d\\d)(?:-(\\d\\d)(?:[T ]([0-9:.,]*)(?:Z|([+-][0-9:.,]*))?)?)?)?");
    private static final Pattern PATTERN_2 = Pattern.compile("(\\d\\d\\d\\d)(?:(\\d\\d)(?:(\\d\\d)(?:T([0-9:.,]*)(?:Z|([+-][0-9:.,]*))?)?)?)?");
    private static final Pattern TIME_PATTERN_1 = Pattern.compile("(\\d\\d)(?::(\\d\\d)(?::(\\d\\d)(?:[.,](\\d\\d?\\d?\\d?\\d?\\d?\\d?\\d?\\d?))?)?)?");
    private static final Pattern TIME_PATTERN_2 = Pattern.compile("(\\d\\d)(?:(\\d\\d)(?:(\\d\\d)(?:[.,](\\d\\d?\\d?\\d?\\d?\\d?\\d?\\d?\\d?))?)?)?");

    @Override
    public TimeParts scan(Resolution unit, String datetime) throws T2Exception {
        Matcher matcher;
        int bigT;
        boolean hyphenated;
        TimeParts tp = null;
        if (datetime == null) {
            throw new IllegalArgumentException("date null");
        }
        int hyphen = datetime.indexOf(45);
        boolean bl = hyphenated = hyphen > 0;
        if (hyphenated && (bigT = datetime.indexOf(84)) >= 0 && bigT < hyphen) {
            hyphenated = false;
        }
        Matcher matcher2 = matcher = hyphenated ? PATTERN_1.matcher(datetime) : PATTERN_2.matcher(datetime);
        if (!matcher.matches()) {
            throw T2Msg.exception(hyphenated ? "T1081" : "T1082", datetime);
        }
        if (matcher.groupCount() != 5) {
            throw new RuntimeException("bug: unexpected count " + matcher.groupCount());
        }
        String group = null;
        try {
            long year = 0L;
            int month = 1;
            int day = 1;
            TimeParts.HMSF hmsu = new TimeParts.HMSF(0, 0, 0, 0);
            TimeParts.TimeZoneOffset tzo = null;
            block11: for (int i = 0; i < 5; ++i) {
                group = matcher.group(i + 1);
                if (group == null || group.length() == 0) continue;
                switch (i) {
                    case 0: {
                        try {
                            year = Long.valueOf(group);
                        }
                        catch (NumberFormatException e) {
                            if (!group.startsWith("+")) continue block11;
                            year = Long.valueOf(group.substring(1));
                        }
                        continue block11;
                    }
                    case 1: {
                        month = Integer.valueOf(group);
                        continue block11;
                    }
                    case 2: {
                        day = Integer.valueOf(group);
                        continue block11;
                    }
                    case 3: {
                        hmsu = this.scanTime(unit, hyphenated ? TIME_PATTERN_1.matcher(group) : TIME_PATTERN_2.matcher(group));
                        if (hmsu != null) continue block11;
                        throw T2Msg.exception(hyphenated ? "T1083" : "T1084", group);
                    }
                    case 4: {
                        TimeParts.HMSF hmsu2 = this.scanTime(unit, hyphenated ? TIME_PATTERN_1.matcher(group.substring(1)) : TIME_PATTERN_2.matcher(group.substring(1)));
                        if (hmsu2 == null) {
                            throw T2Msg.exception(hyphenated ? "T1085" : "T1086", group);
                        }
                        tzo = new TimeParts.TimeZoneOffset(unit, group.startsWith("-"), hmsu2.h(), hmsu2.m(), hmsu2.s(), hmsu2.f());
                        continue block11;
                    }
                    default: {
                        throw new RuntimeException("bug: " + i);
                    }
                }
            }
            if (unit == Resolution.NSEC && (year -= 2000L) < 0L) {
                throw T2Msg.exception("T1013", 2000L);
            }
            tp = new TimeParts(unit, year, month, day, hmsu.h(), hmsu.m(), hmsu.s(), hmsu.f(), tzo);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("bug: group not numeric " + group);
        }
        return tp;
    }

    private TimeParts.HMSF scanTime(Resolution unit, Matcher matcher) throws T2Exception {
        if (!matcher.matches()) {
            return null;
        }
        if (matcher.groupCount() != 4) {
            throw new RuntimeException("bug: unexpected count " + matcher.groupCount());
        }
        String group = null;
        int h = 0;
        int m = 0;
        int s = 0;
        int u = 0;
        try {
            block13: for (int i = 0; i < 4 && (group = matcher.group(i + 1)) != null; ++i) {
                switch (i) {
                    case 0: {
                        h = Integer.valueOf(group);
                        continue block13;
                    }
                    case 1: {
                        m = Integer.valueOf(group);
                        continue block13;
                    }
                    case 2: {
                        s = Integer.valueOf(group);
                        continue block13;
                    }
                    case 3: {
                        switch (unit) {
                            case MSEC: {
                                u = Integer.valueOf((group + "000").substring(0, 3));
                                continue block13;
                            }
                            case USEC: {
                                u = Integer.valueOf((group + "000000").substring(0, 6));
                                continue block13;
                            }
                            case NSEC: {
                                u = Integer.valueOf((group + "000000000").substring(0, 9));
                                continue block13;
                            }
                        }
                        u = 0;
                        continue block13;
                    }
                    default: {
                        throw new RuntimeException("bug: " + i);
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("bug: group not numeric " + group);
        }
        return new TimeParts.HMSF(h, m, s, u);
    }
}

