/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.time.TimeFormatter;
import ch.agent.t2.time.TimeParts;
import java.util.Formatter;

public class DefaultTimeFormatter
implements TimeFormatter {
    private final char T;
    private final String Z;

    public DefaultTimeFormatter(boolean withTandZ) {
        this.T = (char)(withTandZ ? 84 : 32);
        this.Z = withTandZ ? "Z" : "";
    }

    public DefaultTimeFormatter() {
        this(false);
    }

    @Override
    public String format(TimeParts tp) {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        String plus = tp.getYear() > 9999L ? "+" : "";
        switch (tp.getResolution()) {
            case YEAR: {
                fmt.format("%s%04d", plus, tp.getYear());
                break;
            }
            case MONTH: {
                fmt.format("%s%04d-%02d", plus, tp.getYear(), tp.getMonth());
                break;
            }
            case DAY: {
                fmt.format("%s%04d-%02d-%02d", plus, tp.getYear(), tp.getMonth(), tp.getDay());
                break;
            }
            case HOUR: {
                fmt.format("%s%04d-%02d-%02d%c%02d%s", plus, tp.getYear(), tp.getMonth(), tp.getDay(), Character.valueOf(this.T), tp.getHour(), this.Z);
                break;
            }
            case MIN: {
                fmt.format("%s%04d-%02d-%02d%c%02d:%02d%s", plus, tp.getYear(), tp.getMonth(), tp.getDay(), Character.valueOf(this.T), tp.getHour(), tp.getMin(), this.Z);
                break;
            }
            case SEC: {
                fmt.format("%s%04d-%02d-%02d%c%02d:%02d:%02d%s", plus, tp.getYear(), tp.getMonth(), tp.getDay(), Character.valueOf(this.T), tp.getHour(), tp.getMin(), tp.getSec(), this.Z);
                break;
            }
            case MSEC: {
                fmt.format("%s%04d-%02d-%02d%c%02d:%02d:%02d.%03d%s", plus, tp.getYear(), tp.getMonth(), tp.getDay(), Character.valueOf(this.T), tp.getHour(), tp.getMin(), tp.getSec(), tp.getFsec(), this.Z);
                break;
            }
            case USEC: {
                fmt.format("%s%04d-%02d-%02d%c%02d:%02d:%02d.%06d%s", plus, tp.getYear(), tp.getMonth(), tp.getDay(), Character.valueOf(this.T), tp.getHour(), tp.getMin(), tp.getSec(), tp.getFsec(), this.Z);
                break;
            }
            case NSEC: {
                fmt.format("%s%04d-%02d-%02d%c%02d:%02d:%02d.%09d%s", plus, 2000L + tp.getYear(), tp.getMonth(), tp.getDay(), Character.valueOf(this.T), tp.getHour(), tp.getMin(), tp.getSec(), tp.getFsec(), this.Z);
                break;
            }
            default: {
                fmt.close();
                throw new RuntimeException("bug: " + tp.getResolution().name());
            }
        }
        fmt.close();
        return sb.toString();
    }
}

