/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.applied;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.Time2;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeDomainDefinition;
import ch.agent.t2.time.TimeIndex;

public class SystemTime
extends Time2 {
    private static final long ORIGIN = 62167219200000L;
    public static final String LABEL = "systemtime";
    public static final TimeDomain DOMAIN = new TimeDomainDefinition("systemtime", Resolution.MSEC, 62167219200000L).asTimeDomain();

    public SystemTime(TimeIndex time) throws T2Exception {
        super(DOMAIN, time.asLong());
        if (DOMAIN != time.getTimeDomain()) {
            throw T2Msg.exception("T1073", time.getTimeDomain().getLabel(), DOMAIN.getLabel());
        }
    }

    public SystemTime() throws T2Exception {
        super(DOMAIN, 62167219200000L + System.currentTimeMillis());
    }

    public SystemTime(long millis) {
        super(DOMAIN, 62167219200000L + millis);
    }

    public SystemTime(String date) throws T2Exception {
        super(DOMAIN, date);
    }

    public SystemTime(long year, int month, int day, int hour, int min, int sec, int msec) throws T2Exception {
        super(DOMAIN, year, month, day, hour, min, sec, msec * 1000, Adjustment.NONE);
    }

    public long asFastJavaTime() {
        return this.asLong() - 62167219200000L;
    }
}

