/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.applied;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.applied.DayByNameAndRank;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.SubPeriodPattern;
import ch.agent.t2.time.TimeParts;
import ch.agent.t2.time.TimeTools;
import java.util.Arrays;

public class DayRankingSubPeriodPattern
implements SubPeriodPattern {
    private Resolution basePeriodUnit;
    private DayByNameAndRank[] ranks;

    public DayRankingSubPeriodPattern(Resolution basePeriod, DayByNameAndRank[] ranks) {
        if (basePeriod != Resolution.YEAR && basePeriod != Resolution.MONTH) {
            throw new IllegalArgumentException("basePeriod must be either YEAR or MONTH");
        }
        if (ranks == null || ranks.length == 0) {
            throw new IllegalArgumentException("ranks null or empty");
        }
        this.basePeriodUnit = basePeriod;
        this.ranks = ranks;
        try {
            this.validateRanks();
        }
        catch (T2Exception e) {
            throw new IllegalArgumentException("ranks invalid", e);
        }
    }

    @Override
    public int getSize() {
        return this.ranks.length;
    }

    @Override
    public Resolution getSubPeriod() {
        return Resolution.DAY;
    }

    @Override
    public Resolution getBasePeriod() {
        return this.basePeriodUnit;
    }

    @Override
    public long adjustForSubPeriod(long time, Adjustment adjust, TimeParts tp) throws T2Exception {
        time *= (long)this.getSize();
        switch (this.basePeriodUnit) {
            case YEAR: {
                time = this.increment(true, time, tp.getYear(), tp.getMonth(), tp.getDay(), adjust, this.ranks);
                break;
            }
            case MONTH: {
                time = this.increment(false, time, tp.getYear(), tp.getMonth(), tp.getDay(), adjust, this.ranks);
                break;
            }
            default: {
                throw T2Msg.exception("T1118", this.basePeriodUnit.name(), this.getSubPeriod().name());
            }
        }
        return time;
    }

    @Override
    public TimeParts fillInSubPeriod(int subPeriod, TimeParts tp) {
        if (subPeriod < 0 || subPeriod > this.ranks.length) {
            throw new IllegalArgumentException("subPeriod does not agree with ranks.length");
        }
        TimeParts result = null;
        try {
            switch (this.basePeriodUnit) {
                case YEAR: {
                    int yearDay = TimeTools.getDayByRank(tp.getYear(), 0, this.ranks[subPeriod].getDayOfWeek(), this.ranks[subPeriod].getRank());
                    int[] md = TimeTools.computeMonthAndDay(tp.getYear(), yearDay);
                    result = new TimeParts(this.getSubPeriod(), tp.getYear(), md[0], md[1], tp.getHour(), tp.getMin(), tp.getSec(), tp.getFsec(), tp.getTZOffset());
                    break;
                }
                case MONTH: {
                    int day = TimeTools.getDayByRank(tp.getYear(), tp.getMonth(), this.ranks[subPeriod].getDayOfWeek(), this.ranks[subPeriod].getRank());
                    result = new TimeParts(this.getSubPeriod(), tp.getYear(), tp.getMonth(), day, tp.getHour(), tp.getMin(), tp.getSec(), tp.getFsec(), tp.getTZOffset());
                    break;
                }
                default: {
                    throw T2Msg.exception("T1118", this.basePeriodUnit.name(), this.getSubPeriod().name());
                }
            }
        }
        catch (T2Exception e) {
            throw new RuntimeException("bug", e);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DayRankingSubPeriodPattern)) {
            return false;
        }
        return Arrays.equals(this.ranks, ((DayRankingSubPeriodPattern)obj).ranks);
    }

    public int hashCode() {
        return Arrays.hashCode(this.ranks);
    }

    public String toString() {
        return Arrays.toString(this.ranks);
    }

    private long increment(long time, int inc) throws T2Exception {
        try {
            return TimeTools.sum(time, inc);
        }
        catch (ArithmeticException e) {
            throw T2Msg.exception("T1116", new Object[0]);
        }
    }

    private long increment(boolean yearMode, long time, long year, int month, int day, Adjustment adjust, DayByNameAndRank[] ranks) throws T2Exception {
        if (yearMode) {
            day += TimeTools.daysToMonth(year, month);
            month = 0;
        }
        int inc = Integer.MAX_VALUE;
        block10: for (int i = 0; i < ranks.length; ++i) {
            DayByNameAndRank rank = ranks[i];
            int rankDay = TimeTools.getDayByRank(year, month, rank.getDayOfWeek(), rank.getRank());
            if (rankDay == day) {
                inc = i;
                break;
            }
            if (rankDay < day) {
                switch (adjust) {
                    case UP: {
                        if (i != ranks.length - 1) continue block10;
                        inc = this.getSize();
                        break block10;
                    }
                    case DOWN: {
                        if (i != ranks.length - 1) continue block10;
                        inc = i;
                        break block10;
                    }
                    case NONE: {
                        throw T2Msg.exception("T1117", new Object[0]);
                    }
                    default: {
                        throw new RuntimeException("bug: " + adjust.name());
                    }
                }
            }
            switch (adjust) {
                case UP: {
                    inc = i;
                    break block10;
                }
                case DOWN: {
                    inc = i - 1;
                    break block10;
                }
                case NONE: {
                    throw T2Msg.exception("T1117", new Object[0]);
                }
                default: {
                    throw new RuntimeException("bug: " + adjust.name());
                }
            }
        }
        assert (inc != Integer.MAX_VALUE);
        return this.increment(time, inc);
    }

    private void validateRanks() throws T2Exception {
        int m = this.ranks[0].getMaxRank(this.basePeriodUnit);
        int previousR = Integer.MIN_VALUE;
        boolean[] inUse = new boolean[m];
        for (DayByNameAndRank dnr : this.ranks) {
            int r = dnr.getRank();
            if (r <= -m || r >= m || r == 0) {
                throw T2Msg.exception("T1051", r, -m + 1, m - 1);
            }
            if (r > 0) {
                if (r <= previousR) {
                    throw T2Msg.exception("T1055", new Object[0]);
                }
                if (inUse[r - 1]) {
                    throw T2Msg.exception("T1053", r);
                }
                inUse[r - 1] = true;
                previousR = r;
                continue;
            }
            int virtualR1 = m + 1 + r;
            if (virtualR1 <= previousR) {
                throw T2Msg.exception("T1055", new Object[0]);
            }
            int virtualR2 = m + r;
            if (inUse[virtualR1 - 1] || inUse[virtualR2 - 1]) {
                throw T2Msg.exception("T1054", r, virtualR1, virtualR2);
            }
            inUse[virtualR1 - 1] = true;
            inUse[virtualR2 - 1] = true;
            previousR = virtualR1;
        }
    }
}

