/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.applied;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.DayOfWeek;
import ch.agent.t2.time.Resolution;

public class DayByNameAndRank {
    private static final int MONTH_MAX_RANK = 5;
    private static final int YEAR_MAX_RANK = 53;
    private DayOfWeek day;
    private int rank;

    public DayByNameAndRank(DayOfWeek day, int rank) {
        this.day = day;
        this.rank = rank;
    }

    protected int getMaxRank(Resolution unit) throws T2Exception {
        switch (unit) {
            case MONTH: {
                return 5;
            }
            case YEAR: {
                return 53;
            }
        }
        throw T2Msg.exception("T1052", unit.name());
    }

    protected void checkRank(int rank, Resolution unit) throws T2Exception {
        int m = this.getMaxRank(unit);
        if (rank == 0 || rank < -m || rank > m) {
            throw T2Msg.exception("T1051", rank, -m, m);
        }
    }

    public DayOfWeek getDayOfWeek() {
        return this.day;
    }

    public int getRank() {
        return this.rank;
    }

    public String toString() {
        return this.day.name() + "#" + this.rank;
    }

    public int hashCode() {
        int h = this.rank;
        return 31 * h + this.day.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DayByNameAndRank)) {
            return false;
        }
        if (this.rank != ((DayByNameAndRank)obj).rank) {
            return false;
        }
        return this.day.equals((Object)((DayByNameAndRank)obj).day);
    }
}

