/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.core;

import ch.agent.core.MessageBundle;
import java.text.MessageFormat;
import java.util.MissingResourceException;

public abstract class KeyedMessage {
    private MessageBundle bundle;
    private String key;
    private String message;
    private Object[] args;

    public KeyedMessage(String key, MessageBundle bundle, Object ... args) {
        this.bundle = bundle;
        this.key = key;
        this.args = args;
    }

    private String findMessage(MessageBundle bundle, String key, Object[] args) {
        try {
            return this.format(bundle.getBundle().getString(String.valueOf(key)), args);
        }
        catch (MissingResourceException e) {
            return key + "??";
        }
    }

    private String format(String rawMessage, Object ... args) {
        if (args.length == 0) {
            return rawMessage;
        }
        String[] s = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            s[i] = args[i] == null ? "null" : args[i].toString();
        }
        MessageFormat format = new MessageFormat(rawMessage);
        return format.format(s);
    }

    public String getCategory() {
        return this.bundle.getCategory();
    }

    public String getKey() {
        return this.key;
    }

    public String getMessage() {
        if (this.message == null) {
            this.message = this.findMessage(this.bundle, this.key, this.args);
        }
        return this.message;
    }

    public String toString() {
        return String.format("%s.%s - %s", this.getCategory(), this.key, this.getMessage());
    }
}

