/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.timeutil;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.Day;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.timeutil.DateHolder;
import ch.agent.t2.timeutil.DayExpression;
import ch.agent.t2.timeutil.TimeUtil;

public class RangeHolder {
    private TimeDomain domain;
    private DayExpression beginExpr;
    private DayExpression endExpr;
    private Adjustment beginAdj = Adjustment.UP;
    private Adjustment endAdj = Adjustment.DOWN;

    private RangeHolder(TimeDomain domain, TimeIndex time) {
        this.domain = domain;
        if (time != null) {
            this.newExpr();
            this.beginExpr.setTime(time);
            this.endExpr.setTime(time);
        } else {
            this.setEmpty();
        }
    }

    public RangeHolder(TimeDomain domain) {
        this(domain, TimeUtil.now(domain));
    }

    public RangeHolder() {
        this(Day.DOMAIN);
    }

    public RangeHolder(Range range) {
        this(range.getTimeDomain(), null);
        this.reset(range);
    }

    public RangeHolder(RangeHolder model) {
        this.domain = model.domain;
        this.beginExpr = model.beginExpr == null ? null : new DayExpression(model.beginExpr);
        this.endExpr = model.endExpr == null ? null : new DayExpression(model.endExpr);
        this.beginAdj = model.beginAdj;
        this.endAdj = model.endAdj;
    }

    private void setEmpty() {
        this.beginExpr = null;
        this.endExpr = null;
    }

    private void newExpr() {
        if (this.beginExpr == null) {
            this.beginExpr = new DayExpression(this.beginAdj);
            this.endExpr = new DayExpression(this.endAdj);
        }
    }

    public TimeDomain getTimeDomain() {
        return this.domain;
    }

    public void reset(Range range) {
        this.domain = range.getTimeDomain();
        if (range.isEmpty()) {
            this.setEmpty();
        } else {
            this.newExpr();
            this.beginExpr.setTime(range.getFirst());
            this.endExpr.setTime(range.getLast());
        }
    }

    public void reset(TimeDomain domain) throws T2Exception {
        if (domain == null) {
            throw new IllegalArgumentException("domain null");
        }
        String begin = this.getBeginText();
        String end = this.getEndText();
        this.domain = domain;
        this.setBegin(begin, false);
        this.setEnd(end);
    }

    public void setBegin(String date) throws T2Exception {
        this.setBegin(date, true);
    }

    private void setBegin(String date, boolean enforceValidRange) throws T2Exception {
        DayExpression previousBegin;
        DayExpression dayExpression = previousBegin = this.beginExpr == null ? null : new DayExpression(this.beginExpr);
        if (date == null || date.length() == 0) {
            this.setEmpty();
        } else {
            this.newExpr();
            this.beginExpr.setExpression(this.domain, date);
            if (enforceValidRange) {
                this.enforceValidRange(true, previousBegin);
            }
        }
    }

    public void setEnd(String date) throws T2Exception {
        DayExpression previousEnd;
        DayExpression dayExpression = previousEnd = this.endExpr == null ? null : new DayExpression(this.endExpr);
        if (date == null || date.length() == 0) {
            this.setEmpty();
        } else {
            this.newExpr();
            this.endExpr.setExpression(this.domain, date);
            this.enforceValidRange(false, previousEnd);
        }
    }

    public void incrBegin(int increment) throws T2Exception {
        if (increment == 0) {
            return;
        }
        DayExpression previousBegin = null;
        if (this.beginExpr == null) {
            this.setBegin(TimeUtil.now(this.domain).toString());
        } else {
            previousBegin = new DayExpression(this.beginExpr);
            this.beginExpr.incr(increment);
        }
        this.enforceValidRange(true, previousBegin);
    }

    public void incrBegin(boolean up, boolean large) throws T2Exception {
        int incr = 1;
        if (large) {
            incr = this.beginExpr.isToday() ? DateHolder.getLargeIncrement(Resolution.DAY) : DateHolder.getLargeIncrement(this.domain.getResolution());
        }
        this.incrBegin(up ? incr : -incr);
    }

    public void incrEnd(int increment) throws T2Exception {
        if (increment == 0) {
            return;
        }
        DayExpression previousEnd = null;
        if (this.endExpr == null) {
            this.setEnd(TimeUtil.now(this.domain).toString());
        } else {
            previousEnd = new DayExpression(this.endExpr);
            this.endExpr.incr(increment);
        }
        this.enforceValidRange(false, previousEnd);
    }

    public void incrEnd(boolean up, boolean large) throws T2Exception {
        int incr = 1;
        if (large) {
            incr = this.endExpr.isToday() ? DateHolder.getLargeIncrement(Resolution.DAY) : DateHolder.getLargeIncrement(this.domain.getResolution());
        }
        this.incrEnd(up ? incr : -incr);
    }

    public String getBeginText() {
        if (this.beginExpr == null) {
            return "";
        }
        return this.beginExpr.getExpression();
    }

    public String getEndText() {
        if (this.endExpr == null) {
            return "";
        }
        return this.endExpr.getExpression();
    }

    public Range getRange() throws T2Exception {
        return this.getRange(this.domain);
    }

    public Range getRange(TimeDomain context) throws T2Exception {
        if (this.beginExpr == null) {
            return new Range(context);
        }
        return new Range(this.beginExpr.getDate(context), this.endExpr.getDate(context));
    }

    public Range getRange(Range context) throws T2Exception {
        TimeDomain contextDomain = context.getTimeDomain();
        if (this.beginExpr == null) {
            return new Range(contextDomain);
        }
        TimeIndex begin = this.beginExpr.getDate(context);
        TimeIndex end = this.endExpr.getDate(context);
        if (begin == null || end == null) {
            return new Range(contextDomain);
        }
        if (begin.compareTo(end) > 0 && (this.beginExpr.needContext() || this.endExpr.needContext())) {
            return new Range(contextDomain);
        }
        if (begin.compareTo(end) > 0 && this.beginAdj == Adjustment.UP) {
            this.beginExpr.setTime(end);
            begin = this.beginExpr.getDate(context);
        }
        return new Range(begin, end);
    }

    public boolean needContext() {
        return this.beginExpr != null && this.beginExpr.needContext() || this.endExpr != null && this.endExpr.needContext();
    }

    private void enforceValidRange(boolean keepBegin, DayExpression previous) throws T2Exception {
        DayExpression previous2 = new DayExpression(keepBegin ? this.endExpr : this.beginExpr);
        if (!this.endExpr.enforceValidRange(this.domain, this.beginExpr, keepBegin)) {
            if (keepBegin) {
                this.beginExpr.reset(previous);
                this.endExpr.reset(previous2);
            } else {
                this.beginExpr.reset(previous2);
                this.endExpr.reset(previous);
            }
            throw T2Msg.exception("T7027", new Object[0]);
        }
    }
}

