/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.timeutil;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.Day;
import ch.agent.t2.time.SystemTime;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class JavaDateUtil {
    private static long epoch = 62167219200000L;
    private static long gregorianCutover = Long.MIN_VALUE;
    private static TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");

    public static Date toJavaDate(TimeIndex t) throws T2Exception {
        long index;
        switch (t.getTimeDomain().getResolution()) {
            case YEAR: {
                index = JavaDateUtil.yearOrMonthToMillisecSinceEpoch(t.getYear(), 1);
                break;
            }
            case MONTH: {
                index = JavaDateUtil.yearOrMonthToMillisecSinceEpoch(t.getYear(), t.getMonth());
                break;
            }
            default: {
                index = JavaDateUtil.dayOrLessToMillisecSinceEpoch(t);
            }
        }
        if (index < gregorianCutover) {
            throw T2Msg.exception("T7023", t.toString());
        }
        return new Date(index);
    }

    public static TimeIndex fromJavaDate(Date date, TimeDomain domain) throws T2Exception {
        return JavaDateUtil.fromJavaDate(date, domain, Adjustment.NONE, true);
    }

    public static TimeIndex fromJavaDate(Date date, TimeDomain domain, Adjustment adjustment, boolean UTC) throws T2Exception {
        GregorianCalendar cal = null;
        cal = UTC ? new GregorianCalendar(utcTimeZone) : new GregorianCalendar();
        cal.setTimeInMillis(date.getTime());
        return domain.time(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), 1000 * cal.get(14), adjustment);
    }

    private static long yearOrMonthToMillisecSinceEpoch(long year, int month) throws T2Exception {
        TimeIndex m = Day.DOMAIN.time(year, month, 1, 0, 0, 0, 0, Adjustment.NONE);
        long index = m.asLong() * 24L * 3600000L;
        return index -= epoch;
    }

    private static long dayOrLessToMillisecSinceEpoch(TimeIndex t) throws T2Exception {
        long index = new SystemTime(t.toString()).asLong();
        return index - epoch;
    }

    static {
        gregorianCutover = new GregorianCalendar(new SimpleTimeZone(0, "No DST time zone")).getGregorianChange().getTime();
    }
}

