/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.timeutil;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DateTimeScanner {
    private TimeDomain domain;
    private Matcher matcher;
    private int[] patternGroups;
    private Map<String, Integer> months;
    private int twoDigitYearThreshold;

    public DateTimeScanner(String pattern, int[] groups) throws T2Exception {
        if (pattern != null) {
            try {
                this.matcher = Pattern.compile(pattern).matcher("");
            }
            catch (PatternSyntaxException e) {
                throw T2Msg.exception(e, "T7015", pattern);
            }
            int n = this.matcher.groupCount();
            if (n < 1 || n > 7) {
                throw T2Msg.exception("T7016", pattern);
            }
            if (groups != null) {
                this.verifyGroups(n, groups);
            } else {
                groups = new int[n];
                for (int i = 0; i < n; ++i) {
                    groups[i] = i + 1;
                }
            }
            this.patternGroups = groups;
        }
        this.twoDigitYearThreshold = -1;
    }

    private void verifyGroups(int requiredLength, int[] groups) throws T2Exception {
        boolean error = false;
        if (groups.length != requiredLength) {
            error = true;
        } else {
            int[] check = new int[requiredLength];
            for (int i : groups) {
                if (i < 1 || i > requiredLength) {
                    error = true;
                    break;
                }
                if (check[i - 1] != 0) {
                    error = true;
                    break;
                }
                check[i - 1] = i;
            }
        }
        if (error) {
            throw T2Msg.exception("T7017", requiredLength);
        }
    }

    public void setDomain(TimeDomain domain) {
        this.domain = domain;
    }

    public void setMonths(String[] keywords) {
        if (keywords == null || keywords.length != 12) {
            throw new IllegalArgumentException("keywords.length != 12");
        }
        if (this.months == null) {
            this.months = new HashMap<String, Integer>(12);
        }
        for (int i = 0; i < keywords.length; ++i) {
            this.months.put(keywords[i], i + 1);
        }
    }

    public void setTwoDigitYearThreshold(int threshold) {
        this.twoDigitYearThreshold = threshold;
    }

    public TimeIndex scan(String date) throws T2Exception {
        return this.scan(this.domain, date);
    }

    public TimeIndex scan(TimeDomain domain, String date) throws T2Exception {
        if (domain == null) {
            throw new IllegalArgumentException("domain == null");
        }
        if (date == null) {
            throw new IllegalArgumentException("text null");
        }
        if (this.matcher == null) {
            return domain.time(date);
        }
        this.matcher.reset(date);
        if (this.matcher.matches()) {
            int[] t = new int[]{0, 1, 1, 0, 0, 0, 0};
            for (int i = 0; i < this.patternGroups.length; ++i) {
                if (this.months != null && i == 1) {
                    String month = this.matcher.group(this.patternGroups[i]);
                    Integer m = this.months.get(month);
                    if (m == null) {
                        throw T2Msg.exception("T7019", date, month);
                    }
                    t[i] = m;
                    continue;
                }
                t[i] = Integer.valueOf(this.matcher.group(this.patternGroups[i]));
            }
            if (this.twoDigitYearThreshold >= 0 && t[0] < 100 && t[0] >= 0) {
                t[0] = t[0] < this.twoDigitYearThreshold ? t[0] + 2000 : t[0] + 1900;
            }
            return domain.time(t[0], t[1], t[2], t[3], t[4], t[5], t[6], Adjustment.NONE);
        }
        throw T2Msg.exception("T7018", date, this.matcher.pattern().toString());
    }
}

