/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.timeseries;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.timeseries.RegularTimeSeries;
import ch.agent.t2.timeseries.SparseTimeSeries;
import ch.agent.t2.timeseries.TimeAddressable;
import ch.agent.t2.timeseries.TimeIndexable;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class TimeSeriesFactory {
    private static final int MAXGAP = 500;
    private int maxGap = 500;
    private Map<Class<?>, Object> map = new HashMap();
    private Object nullValue = new Object();

    public static TimeSeriesFactory getInstance() {
        return Singleton.singleton;
    }

    public static <T> TimeIndexable<T> make(TimeDomain domain, Class<T> type) {
        return TimeSeriesFactory.getInstance().makeRegularTimeSeries(domain, type);
    }

    public static <T> TimeAddressable<T> make(TimeDomain domain, Class<T> type, boolean forceSparse) {
        return TimeSeriesFactory.getInstance().makeRegularOrSparseTimeSeries(domain, type, forceSparse);
    }

    protected TimeSeriesFactory() {
    }

    public void setMaxGap(int maxGap) {
        if (maxGap < 1) {
            throw new IllegalArgumentException("maxGap not positive");
        }
        this.maxGap = maxGap;
    }

    public synchronized void define(Class<?> type, Object missingValue) throws T2Exception {
        if (this.map.containsKey(type)) {
            throw T2Msg.exception("T5005", type.getSimpleName());
        }
        this.map.put(type, missingValue == null ? this.nullValue : missingValue);
    }

    protected synchronized Object getOrCreateMissingValue(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("type null");
        }
        Object mv = this.map.get(type);
        if (mv == null) {
            mv = type == Double.class ? new Double(Double.NaN) : this.nullValue;
            try {
                this.define(type, mv);
            }
            catch (Exception e) {
                throw new RuntimeException("bug", e);
            }
        }
        return mv == this.nullValue ? null : mv;
    }

    protected <T> TimeIndexable<T> makeRegularTimeSeries(TimeDomain domain, Class<T> type) {
        Object missingValue = this.getOrCreateMissingValue(type);
        return new RegularTimeSeries<Object>(domain, (Object[])Array.newInstance(type, 0), missingValue, this.maxGap);
    }

    protected <T> TimeAddressable<T> makeRegularOrSparseTimeSeries(TimeDomain domain, Class<T> type, boolean forceSparse) {
        Object missingValue = this.getOrCreateMissingValue(type);
        if (forceSparse || domain.compareResolutionTo(Resolution.DAY) < 0) {
            return new SparseTimeSeries<Object>(type, domain, missingValue);
        }
        return new RegularTimeSeries<Object>(domain, (Object[])Array.newInstance(type, 0), missingValue, this.maxGap);
    }

    private static class Singleton {
        private static TimeSeriesFactory singleton = new TimeSeriesFactory();

        private Singleton() {
        }
    }
}

