/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time.engine;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Day;
import ch.agent.t2.time.DayOfWeek;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.time.TimeParts;
import java.util.Arrays;

public class TimeTools {
    private static final long DAYS_IN_400_YEARS = 146097L;
    private static final int[] daysToMonthCommonYear = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] daysToMonthLeapYear = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};

    public static int daysInMonth(long year, int month) {
        int[] daysToMonth;
        int[] nArray = daysToMonth = TimeTools.isLeap(year) ? daysToMonthLeapYear : daysToMonthCommonYear;
        if (month == 12) {
            return 31;
        }
        return daysToMonth[month] - daysToMonth[month - 1];
    }

    public static int daysToMonth(long year, int month) {
        int[] daysToMonth = TimeTools.isLeap(year) ? daysToMonthLeapYear : daysToMonthCommonYear;
        return daysToMonth[month - 1];
    }

    public static boolean isLeap(long year) {
        if (year < 0L) {
            throw new IllegalArgumentException();
        }
        return year % 4L == 0L && year % 100L != 0L || year % 400L == 0L;
    }

    public static long leapYears(long year) {
        if (year < 0L) {
            throw new IllegalArgumentException();
        }
        if (year == 0L) {
            return 0L;
        }
        return 1L + --year / 4L - year / 100L + year / 400L;
    }

    public static int[] computeMonthAndDay(long year, int day) {
        int[] md = new int[2];
        int[] daysToMonth = TimeTools.isLeap(year) ? daysToMonthLeapYear : daysToMonthCommonYear;
        int i = Arrays.binarySearch(daysToMonth, day - 1);
        if (i >= 0) {
            md[0] = i + 1;
            md[1] = 1;
        } else {
            i = -i - 2;
            md[0] = i + 1;
            md[1] = day - daysToMonth[i];
        }
        return md;
    }

    public static void computeHMS(long totalSeconds, TimeParts tp) {
        if (totalSeconds < 0L) {
            throw new IllegalArgumentException("totalSeconds negative");
        }
        long minutes = totalSeconds / 60L;
        tp.setSec((int)(totalSeconds - minutes * 60L));
        tp.setHour((int)(minutes / 60L));
        tp.setMin((int)(minutes - (long)(tp.getHour() * 60)));
    }

    public static void computeYMD(long days, TimeParts tp) {
        if (days < 0L) {
            throw new IllegalArgumentException("" + days);
        }
        long y400Intervals = days / 146097L;
        int y400Remainder = (int)(days - y400Intervals * 146097L);
        int remainingYears = y400Remainder / 365;
        int dayOffset = y400Remainder - remainingYears * 365 - (int)TimeTools.leapYears(remainingYears);
        if (dayOffset < 0) {
            dayOffset += TimeTools.isLeap(--remainingYears) ? 366 : 365;
        }
        tp.setYear(y400Intervals * 400L + (long)remainingYears);
        int[] monthDay = TimeTools.computeMonthAndDay(tp.getYear(), dayOffset + 1);
        tp.setMonth(monthDay[0]);
        tp.setDay(monthDay[1]);
    }

    @Deprecated
    public static long makeRawIndex(Resolution unit, TimeParts tp) throws T2Exception {
        return tp.asRawIndex(unit);
    }

    public static long dayIndex(Resolution unit, long time) throws T2Exception {
        long dayIndex;
        switch (unit) {
            case DAY: {
                dayIndex = time;
                break;
            }
            case HOUR: {
                dayIndex = time / 24L;
                break;
            }
            case MIN: {
                dayIndex = time / 1440L;
                break;
            }
            case SEC: {
                dayIndex = time / 86400L;
                break;
            }
            case MSEC: {
                dayIndex = time / 86400000L;
                break;
            }
            case USEC: {
                dayIndex = time / 86400000000L;
                break;
            }
            default: {
                throw T2Msg.exception("T1060", new Object[]{unit});
            }
        }
        return dayIndex;
    }

    public static DayOfWeek getDayOfWeek(Resolution unit, long time) throws T2Exception {
        int day = (int)(TimeTools.dayIndex(unit, time) % 7L);
        day = day == 0 ? 6 : --day;
        return DayOfWeek.values()[day];
    }

    public static int getDayByRank(long year, int month, DayOfWeek name, int rank) throws T2Exception {
        int week1Offset;
        int daysInPeriod;
        int max = 5;
        if (month == 0) {
            max = 53;
        }
        if (rank == 0 || rank < -max || rank > max) {
            throw T2Msg.exception("T1051", rank, -max, max);
        }
        if (month == 0) {
            month = 1;
            daysInPeriod = TimeTools.isLeap(year) ? 366 : 365;
        } else {
            daysInPeriod = TimeTools.daysInMonth(year, month);
        }
        Day t = new Day(year, month, 1);
        DayOfWeek firstOfPeriod = t.getDayOfWeek();
        int workRank = rank;
        if (workRank < 0) {
            workRank = max;
        }
        if ((week1Offset = name.ordinal() - firstOfPeriod.ordinal()) < 0) {
            week1Offset += 7;
        }
        int dayOfPeriod = 1 + week1Offset + (workRank - 1) * 7;
        if (rank < 0) {
            if (dayOfPeriod > daysInPeriod) {
                dayOfPeriod -= 7;
            }
            if ((dayOfPeriod += (rank + 1) * 7) < 0) {
                dayOfPeriod = 0;
            }
        } else if (dayOfPeriod > daysInPeriod) {
            dayOfPeriod = 0;
        }
        return dayOfPeriod;
    }

    public static Day getDayOfMonthByRank(TimeIndex time, DayOfWeek dayName, int rank) throws T2Exception {
        int m;
        if (time.getTimeDomain().compareResolutionTo(Resolution.MONTH) > 0) {
            throw T2Msg.exception("T1059", time.toString(), Resolution.MONTH.name());
        }
        long y = time.getYear();
        int day = TimeTools.getDayByRank(y, m = time.getMonth(), dayName, rank);
        return day == 0 ? null : new Day(y, m, day);
    }

    public static Day getDayOfYearByRank(TimeIndex time, DayOfWeek dayName, int rank) throws T2Exception {
        long y = time.getYear();
        int yearDay = TimeTools.getDayByRank(y, 0, dayName, rank);
        if (yearDay == 0) {
            return null;
        }
        int[] md = TimeTools.computeMonthAndDay(y, yearDay);
        return new Day(y, md[0], md[1]);
    }
}

