/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time.engine;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.DayOfWeek;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeDomainDefinition;
import ch.agent.t2.time.TimeDomainManager;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.time.TimeParts;
import ch.agent.t2.time.engine.TimeFactory;
import ch.agent.t2.time.engine.TimeTools;
import java.util.Formatter;

public class Time2
implements TimeIndex {
    private int hash;
    private TimeFactory domain;
    private long internalTime;
    private boolean internalTimeModified;
    private TimeParts tp;

    private Time2() {
    }

    private Time2(TimeDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException("domain null");
        }
        try {
            this.domain = (TimeFactory)domain;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("domain " + domain.getLabel() + " is not a " + TimeFactory.class.getSimpleName());
        }
    }

    protected Time2(TimeDomain domain, long time) {
        this(domain);
        try {
            this.domain.valid(time, false);
            this.setInternalTime(time);
        }
        catch (T2Exception e) {
            throw new IllegalArgumentException("time", e);
        }
    }

    protected Time2(TimeDomain domain, long year, int month, int day, int hour, int min, int sec, int usec, Adjustment adjust) throws T2Exception {
        this(domain);
        TimeParts tp = new TimeParts();
        tp.setYear(year);
        tp.setMonth(month);
        tp.setDay(day);
        tp.setHour(hour);
        tp.setMin(min);
        tp.setSec(sec);
        tp.setUsec(usec);
        this.set(tp, adjust);
    }

    protected Time2(TimeDomain domain, String time, Adjustment adjustment) throws T2Exception {
        this(domain);
        this.set(time, adjustment);
    }

    protected Time2(TimeDomain domain, String time) throws T2Exception {
        this(domain, time, Adjustment.NONE);
    }

    private Time2(TimeIndex timeIndex, long increment) throws T2Exception {
        this(timeIndex.getTimeDomain());
        long t = timeIndex.asLong();
        long incrT = t + increment;
        if (t > 0L && incrT < 0L || t < 0L && incrT > 0L) {
            throw T2Msg.exception("T1075", timeIndex.toString(), increment);
        }
        try {
            this.domain.valid(incrT, false);
        }
        catch (T2Exception e) {
            throw T2Msg.exception(e, "T1075", timeIndex.toString(), increment);
        }
        this.setInternalTime(incrT);
    }

    @Override
    public TimeIndex convert(TimeDomain domain) throws T2Exception {
        return this.convert(domain, Adjustment.NONE);
    }

    @Override
    public TimeIndex convert(TimeDomain domain, Adjustment adjustment) throws T2Exception {
        if (this.getTimeDomain().equals(domain)) {
            return this;
        }
        this.resolve();
        switch (this.getTimeDomain().getResolution()) {
            case YEAR: {
                this.tp.setMonth(1);
            }
            case MONTH: {
                this.tp.setDay(1);
                break;
            }
        }
        return new Time2(domain, this.tp.getYear(), this.tp.getMonth(), this.tp.getDay(), this.tp.getHour(), this.tp.getMin(), this.tp.getSec(), this.tp.getUsec(), adjustment);
    }

    @Override
    public TimeDomain getTimeDomain() {
        return this.domain;
    }

    @Override
    public long asLong() {
        return this.getInternalTime();
    }

    @Override
    public int asOffset() throws T2Exception {
        long time = this.getInternalTime() - this.domain.getOrigin();
        if (time < Integer.MIN_VALUE || time > Integer.MAX_VALUE) {
            throw T2Msg.exception("T1076", new Object[]{this.domain.getResolution(), time});
        }
        return (int)time;
    }

    @Override
    public TimeIndex add(long increment) throws T2Exception {
        return new Time2(this, increment);
    }

    @Override
    public long sub(TimeIndex time) throws T2Exception {
        if (this.getTimeDomain().equals(time.getTimeDomain())) {
            return this.asLong() - time.asLong();
        }
        throw T2Msg.exception("T1077", time.toString(), this.toString(), time.getTimeDomain().getLabel(), this.getTimeDomain().getLabel());
    }

    TimeParts getTimeParts() {
        this.resolve();
        return this.tp;
    }

    @Override
    public long getYear() {
        this.resolve();
        return this.tp.getYear();
    }

    @Override
    public int getMonth() {
        this.resolve();
        return this.tp.getMonth();
    }

    @Override
    public int getDay() {
        this.resolve();
        return this.tp.getDay();
    }

    @Override
    public int getHour() {
        this.resolve();
        return this.tp.getHour();
    }

    @Override
    public int getMinute() {
        this.resolve();
        return this.tp.getMin();
    }

    @Override
    public int getSecond() {
        this.resolve();
        return this.tp.getSec();
    }

    @Override
    public int getMicrosecond() {
        this.resolve();
        return this.tp.getUsec();
    }

    @Override
    public DayOfWeek getDayOfWeek() throws T2Exception {
        return this.domain.getDayOfWeek(this);
    }

    @Override
    public TimeIndex getDayByRank(Resolution basePeriod, DayOfWeek day, int rank) throws T2Exception {
        switch (basePeriod) {
            case MONTH: {
                return TimeTools.getDayOfMonthByRank(this, day, rank);
            }
            case YEAR: {
                return TimeTools.getDayOfYearByRank(this, day, rank);
            }
        }
        throw T2Msg.exception("T1052", basePeriod.name());
    }

    public String toString(boolean full) {
        this.resolve();
        if (full) {
            StringBuilder sb = new StringBuilder();
            Formatter fmt = new Formatter(sb);
            String plus = this.tp.getYear() > 9999L ? "+" : "";
            fmt.format("%s%04d-%02d-%02d %02d:%02d:%02d.%06d", plus, this.tp.getYear(), this.tp.getMonth(), this.tp.getDay(), this.tp.getHour(), this.tp.getMin(), this.tp.getSec(), this.tp.getUsec());
            fmt.close();
            return sb.toString();
        }
        return this.domain.format(this.domain.getResolution(), this.tp);
    }

    @Override
    public String toString(String format) {
        if (format == null) {
            return this.toString();
        }
        this.resolve();
        if (format.length() == 0) {
            String yy = this.tp.getYear() + "";
            if (yy.length() >= 3) {
                yy = yy.substring(2);
            }
            return String.format("%d.%d.%s", this.tp.getDay(), this.tp.getMonth(), yy);
        }
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        fmt.format(format, this.tp.getYear(), this.tp.getMonth(), this.tp.getDay(), this.tp.getHour(), this.tp.getMin(), this.tp.getSec(), this.tp.getUsec());
        fmt.close();
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Time2)) {
            return false;
        }
        return this.asLong() == ((Time2)obj).asLong() && this.domain.equals(((Time2)obj).getTimeDomain());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = 31 * this.domain.hashCode() + new Long(this.asLong()).hashCode();
        }
        return this.hash;
    }

    @Override
    public int compareTo(TimeIndex otherTime) {
        if (otherTime == null) {
            throw new IllegalArgumentException("t null");
        }
        if (otherTime.getTimeDomain().equals(this.getTimeDomain())) {
            long l2;
            long l1 = this.asLong();
            if (l1 < (l2 = otherTime.asLong())) {
                return -1;
            }
            if (l1 > l2) {
                return 1;
            }
            return 0;
        }
        int compareResols = this.getTimeDomain().getResolution().compareTo(otherTime.getTimeDomain().getResolution());
        if (compareResols == 0) {
            TimeDomainDefinition def = new TimeDomainDefinition(null, this.getTimeDomain().getResolution(), 0L);
            TimeDomain unrestrictedDomain = TimeDomainManager.getFactory().get(def, true);
            TimeIndex converted = this.convertOrThrowRTE(unrestrictedDomain, this);
            TimeIndex otherConverted = this.convertOrThrowRTE(unrestrictedDomain, otherTime);
            return converted.compareTo(otherConverted);
        }
        if (compareResols < 0) {
            TimeDomainDefinition def = new TimeDomainDefinition(null, otherTime.getTimeDomain().getResolution(), 0L);
            TimeDomain unrestrictedDomain = TimeDomainManager.getFactory().get(def, true);
            TimeIndex converted = this.convertOrThrowRTE(unrestrictedDomain, this);
            return converted.compareTo(otherTime);
        }
        TimeDomainDefinition def = new TimeDomainDefinition(null, this.getTimeDomain().getResolution(), 0L);
        TimeDomain unrestrictedDomain = TimeDomainManager.getFactory().get(def, true);
        TimeIndex otherConverted = this.convertOrThrowRTE(unrestrictedDomain, otherTime);
        return this.compareTo(otherConverted);
    }

    private TimeIndex convertOrThrowRTE(TimeDomain domain, TimeIndex time) {
        try {
            return time.convert(domain);
        }
        catch (T2Exception e) {
            T2Exception cause = T2Msg.exception(e, "T0005", time.toString(), domain);
            throw T2Msg.runtimeException("T0001", cause);
        }
    }

    private void set(TimeParts tp, Adjustment adjust) throws T2Exception {
        this.setInternalTime(this.domain.pack(tp, adjust));
    }

    private void set(String date, Adjustment adjust) throws T2Exception {
        TimeParts tp = this.domain.scan(date);
        this.set(tp, adjust);
    }

    private void resolve() {
        if (this.internalTimeModified) {
            this.tp = this.domain.unpack(this.getInternalTime());
            this.internalTimeModified = false;
        }
    }

    private long getInternalTime() {
        return this.internalTime;
    }

    private void setInternalTime(long time) {
        this.internalTimeModified = true;
        this.internalTime = time;
    }
}

