/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time.engine;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.DefaultExternalFormat;
import ch.agent.t2.time.ExternalTimeFormat;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeDomainDefinition;
import ch.agent.t2.time.TimeDomainFactory;
import ch.agent.t2.time.engine.TimeFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractTimeDomainFactory
implements TimeDomainFactory {
    private Map<String, TimeFactory> domains = new HashMap<String, TimeFactory>();
    private Set<String> declaredBuiltIns = new LinkedHashSet<String>();
    private TimeDomain[] builtIns;
    private ExternalTimeFormat timeFormat;

    protected AbstractTimeDomainFactory() {
    }

    @Override
    public ExternalTimeFormat getExternalTimeFormat() {
        if (this.timeFormat == null) {
            this.timeFormat = DefaultExternalFormat.getInstance();
        }
        return this.timeFormat;
    }

    protected void setExternalTimeFormat(ExternalTimeFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    @Override
    public Collection<TimeDomain> getTimeDomains() {
        ArrayList<TimeDomain> d = new ArrayList<TimeDomain>(this.domains.size());
        d.addAll(this.domains.values());
        return d;
    }

    @Override
    public TimeDomain get(String label) throws T2Exception {
        TimeDomain domain = this.domains.get(label);
        if (domain == null) {
            throw T2Msg.exception("T0006", label, this.getTimeDomainLabels().toString());
        }
        return domain;
    }

    @Override
    public TimeDomain get(TimeDomainDefinition def, boolean register) {
        TimeDomain domain = this.get(def);
        if (domain == null) {
            if (register) {
                domain = this.define(def);
            }
        } else if (def.getLabel() != null && !domain.getLabel().equals(def.getLabel())) {
            T2Exception cause = T2Msg.exception("T0009", domain.toString(), def.getLabel());
            throw T2Msg.runtimeException("T0001", cause);
        }
        return domain;
    }

    @Override
    public TimeDomain get(TimeDomainDefinition def) {
        TimeFactory domain = null;
        for (TimeFactory d : this.domains.values()) {
            if (!d.matches(def.getBaseUnit(), def.getOrigin(), def.getBasePeriodPattern(), def.getSubPeriodPattern())) continue;
            domain = d;
            break;
        }
        return domain;
    }

    private TimeDomain getTimeDomain(TimeDomainDefinition def) {
        TimeFactory domain = null;
        for (TimeFactory d : this.domains.values()) {
            if (!d.matches(def.getBaseUnit(), def.getOrigin(), def.getBasePeriodPattern(), def.getSubPeriodPattern())) continue;
            domain = d;
            break;
        }
        return domain;
    }

    private synchronized TimeDomain define(TimeDomainDefinition def) {
        if (def.getBaseUnit() == null) {
            throw new IllegalArgumentException("basePeriod");
        }
        if (def.getSubPeriodPattern() != null && !def.getBaseUnit().equals((Object)def.getSubPeriodPattern().getBasePeriod())) {
            throw new IllegalArgumentException("basePeriods differ");
        }
        TimeDomain domain = this.getTimeDomain(def);
        if (domain == null) {
            if (def.getLabel() == null) {
                def.setLabel(this.inventLabel());
            } else {
                domain = this.domains.get(def.getLabel());
                if (domain != null) {
                    T2Exception cause = T2Msg.exception("T0007", domain.toString());
                    throw T2Msg.runtimeException("T0001", cause);
                }
            }
            ExternalTimeFormat externalFormat = this.getExternalTimeFormat();
            if (externalFormat == null) {
                externalFormat = DefaultExternalFormat.getInstance();
            }
            domain = new TimeFactory(def, externalFormat);
            this.domains.put(def.getLabel(), (TimeFactory)domain);
        }
        return domain;
    }

    private String inventLabel() {
        String label = "domain" + (this.domains.size() + 1);
        int i = 0;
        String invented = label;
        while (this.domains.get(invented) != null) {
            invented = label + "." + ++i;
        }
        return invented;
    }

    private Collection<String> getTimeDomainLabels() {
        TreeSet<String> labels = new TreeSet<String>();
        for (String label : this.domains.keySet()) {
            labels.add(label);
        }
        return labels;
    }

    @Override
    public void declareBuiltIn(String label) {
        if (this.builtIns != null) {
            throw new IllegalStateException("built-ins are locked");
        }
        if (label == null) {
            throw new IllegalArgumentException("label null");
        }
        this.declaredBuiltIns.add(label);
    }

    @Override
    public boolean isBuiltIn(TimeDomain domain) {
        this.resolveBuiltIns();
        return domain instanceof TimeFactory ? ((TimeFactory)domain).isBuiltIn() : false;
    }

    @Override
    public Collection<TimeDomain> getBuiltIns() {
        this.resolveBuiltIns();
        return Arrays.asList(this.builtIns);
    }

    @Override
    public void lockBuiltIns() {
        if (this.declaredBuiltIns == null) {
            return;
        }
        this.builtIns = new TimeDomain[this.declaredBuiltIns.size()];
    }

    private void resolveBuiltIns() {
        this.lockBuiltIns();
        if (this.declaredBuiltIns == null) {
            return;
        }
        if (this.builtIns.length > 0) {
            int i = 0;
            for (String def : this.declaredBuiltIns) {
                try {
                    TimeDomain d = this.get(def);
                    ((TimeFactory)d).markBuiltIn(i);
                    this.builtIns[i] = d;
                    ++i;
                }
                catch (T2Exception e) {
                    T2Exception cause = T2Msg.exception(e, "T0008", this.getClass().getCanonicalName());
                    throw T2Msg.runtimeException("T0001", cause);
                }
            }
        }
        this.declaredBuiltIns = null;
    }
}

