/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.DefaultTimeDomainFactory;
import ch.agent.t2.time.TimeDomainFactory;
import java.lang.reflect.Method;

public class TimeDomainManager {
    private static final String PROP = "TimeDomainFactory";
    private static final String INSTANCE_METHOD = "getInstance";
    private static TimeDomainFactory factory;

    public static synchronized TimeDomainFactory getFactory() {
        if (factory == null) {
            String className = System.getProperty(PROP);
            if (className == null) {
                factory = DefaultTimeDomainFactory.getInstance();
            } else {
                try {
                    Class<?> c = Class.forName(className);
                    Method getI = c.getMethod(INSTANCE_METHOD, new Class[0]);
                    factory = (TimeDomainFactory)getI.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    T2Exception cause = T2Msg.exception(e, "T0004", PROP, className);
                    throw T2Msg.runtimeException("T0001", cause);
                }
            }
        }
        return factory;
    }

    private TimeDomainManager() {
    }
}

