/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.SubPeriodPattern;
import ch.agent.t2.time.TimeParts;
import ch.agent.t2.time.engine.TimeTools;
import java.util.Arrays;

public class SimpleSubPeriodPattern
implements SubPeriodPattern {
    private Resolution basePeriodUnit;
    private Resolution subPeriodUnit;
    private int[] ranks;

    @Override
    public int getSize() {
        return this.ranks.length;
    }

    public SimpleSubPeriodPattern(Resolution basePeriod, Resolution subPeriod, int[] ranks) throws T2Exception {
        if (basePeriod == null) {
            throw new IllegalArgumentException("basePeriod null");
        }
        if (subPeriod == null) {
            throw new IllegalArgumentException("subPeriod null");
        }
        if (ranks == null || ranks.length == 0) {
            throw new IllegalArgumentException("ranks null or empty");
        }
        this.basePeriodUnit = basePeriod;
        this.subPeriodUnit = subPeriod;
        this.ranks = ranks;
        this.validateRanks();
    }

    private void validateRanks() throws T2Exception {
        int minRank = Integer.MAX_VALUE;
        int maxRank = Integer.MIN_VALUE;
        switch (this.subPeriodUnit) {
            case MONTH: {
                minRank = 1;
                maxRank = 12;
                break;
            }
            case DAY: {
                minRank = 1;
                maxRank = 28;
                break;
            }
            case SEC: {
                minRank = 0;
                maxRank = 86399;
                break;
            }
            default: {
                throw T2Msg.exception("T1112", this.subPeriodUnit.name());
            }
        }
        for (int i = 0; i < this.ranks.length; ++i) {
            if (this.ranks[i] < minRank || this.ranks[i] > maxRank) {
                throw T2Msg.exception("T1113", this.ranks[i], minRank, maxRank);
            }
            if (i <= 0 || this.ranks[i] > this.ranks[i - 1]) continue;
            throw T2Msg.exception("T1114", new Object[0]);
        }
    }

    @Override
    public Resolution getSubPeriod() {
        return this.subPeriodUnit;
    }

    @Override
    public Resolution getBasePeriod() {
        return this.basePeriodUnit;
    }

    @Override
    public long adjustForSubPeriod(long time, Adjustment adjust, TimeParts tp) throws T2Exception {
        time *= (long)this.getSize();
        block0 : switch (this.basePeriodUnit) {
            case YEAR: {
                switch (this.subPeriodUnit) {
                    case MONTH: {
                        time = this.increment(time, adjust, this.ranks, tp.getMonth());
                        break block0;
                    }
                }
                throw T2Msg.exception("T1115", this.basePeriodUnit.name(), this.subPeriodUnit.name());
            }
            case MONTH: {
                switch (this.subPeriodUnit) {
                    case DAY: {
                        time = this.increment(time, adjust, this.ranks, tp.getDay());
                        break block0;
                    }
                }
                throw T2Msg.exception("T1115", this.basePeriodUnit.name(), this.subPeriodUnit.name());
            }
            case DAY: {
                switch (this.subPeriodUnit) {
                    case SEC: {
                        time = this.increment(time, adjust, this.ranks, tp.getHour() * 3600 + tp.getMin() * 60 + tp.getSec());
                        break block0;
                    }
                }
                throw T2Msg.exception("T1115", this.basePeriodUnit.name(), this.subPeriodUnit.name());
            }
            default: {
                throw T2Msg.exception("T1115", this.basePeriodUnit.name(), this.subPeriodUnit.name());
            }
        }
        return time;
    }

    private long increment(long time, Adjustment adjust, int[] ranks, int period) throws T2Exception {
        int inc = 0;
        int i = Arrays.binarySearch(ranks, period);
        if (i >= 0) {
            inc = i;
        } else {
            switch (adjust) {
                case UP: {
                    inc = -i - 1;
                    if (inc != ranks.length) break;
                    inc = this.getSize();
                    break;
                }
                case DOWN: {
                    inc = -i - 2;
                    if (inc >= 0) break;
                    inc = -1;
                    break;
                }
                case NONE: {
                    throw T2Msg.exception("T1117", new Object[0]);
                }
                default: {
                    throw new RuntimeException(adjust.name());
                }
            }
        }
        return this.increment(time, inc);
    }

    private long increment(long time, int inc) throws T2Exception {
        long result = time;
        if (result < 0L && (time += (long)inc) > 0L || result > 0L && time < 0L) {
            throw T2Msg.exception("T1116", new Object[0]);
        }
        return time;
    }

    @Override
    public void fillInSubPeriod(int subPeriod, TimeParts tp) {
        if (subPeriod < 0 || subPeriod > this.ranks.length) {
            throw new IllegalArgumentException("subPeriod does not agree with ranks.length");
        }
        switch (this.subPeriodUnit) {
            case MONTH: {
                tp.setMonth(this.ranks[subPeriod]);
                break;
            }
            case DAY: {
                tp.setDay(this.ranks[subPeriod]);
                break;
            }
            case SEC: {
                TimeTools.computeHMS(this.ranks[subPeriod], tp);
                break;
            }
            default: {
                throw new RuntimeException("bug: " + this.subPeriodUnit.name());
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleSubPeriodPattern)) {
            return false;
        }
        if (!this.subPeriodUnit.equals((Object)((SimpleSubPeriodPattern)obj).subPeriodUnit)) {
            return false;
        }
        return Arrays.equals(this.ranks, ((SimpleSubPeriodPattern)obj).ranks);
    }

    public int hashCode() {
        return 31 * this.subPeriodUnit.hashCode() + Arrays.hashCode(this.ranks);
    }

    public String toString() {
        return this.subPeriodUnit.toString() + Arrays.toString(this.ranks);
    }
}

