/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeIndex;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Range
implements Iterable<TimeIndex> {
    private int hash;
    private TimeDomain domain;
    private long first;
    private long last;

    public Range(TimeDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException("domain null");
        }
        this.domain = domain;
        this.first = 2L;
        this.last = 1L;
        this.normalize();
    }

    public Range(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("range null");
        }
        this.domain = range.domain;
        this.first = range.first;
        this.last = range.last;
    }

    public Range(TimeDomain domain, long first, long last) {
        this(domain);
        this.first = first;
        this.last = last;
        this.normalize();
    }

    public Range(TimeIndex first, TimeIndex last) throws T2Exception {
        this(first.getTimeDomain());
        if (!this.domain.equals(last.getTimeDomain())) {
            throw T2Msg.exception("T5009", first.toString(), last.toString(), first.getTimeDomain().getLabel(), last.getTimeDomain().getLabel());
        }
        this.first = first.asLong();
        this.last = last.asLong();
        this.normalize();
    }

    public Range(TimeDomain domain, String firstDate, String lastDate, Adjustment adjust) throws T2Exception {
        this(domain);
        Adjustment firstAdjust = Adjustment.NONE;
        Adjustment lastAdjust = Adjustment.NONE;
        switch (adjust) {
            case NONE: {
                break;
            }
            case UP: {
                firstAdjust = Adjustment.DOWN;
                lastAdjust = Adjustment.UP;
                break;
            }
            case DOWN: {
                firstAdjust = Adjustment.UP;
                lastAdjust = Adjustment.DOWN;
                break;
            }
            default: {
                throw new RuntimeException("bug: " + adjust.name());
            }
        }
        this.first = domain.time(firstDate, firstAdjust).asLong();
        this.last = domain.time(lastDate, lastAdjust).asLong();
        this.normalize();
    }

    public Range convert(TimeDomain domain, Adjustment adjust) throws T2Exception {
        if (this.domain.equals(domain)) {
            return this;
        }
        Adjustment firstAdjust = Adjustment.NONE;
        Adjustment lastAdjust = Adjustment.NONE;
        switch (adjust) {
            case NONE: {
                break;
            }
            case UP: {
                firstAdjust = Adjustment.DOWN;
                lastAdjust = Adjustment.UP;
                break;
            }
            case DOWN: {
                firstAdjust = Adjustment.UP;
                lastAdjust = Adjustment.DOWN;
                break;
            }
            default: {
                throw new RuntimeException("bug: " + adjust.name());
            }
        }
        Range r = new Range(domain);
        if (!this.isEmpty()) {
            r.first = this.getFirst().convert(domain, firstAdjust).asLong();
            r.last = this.getLast().convert(domain, lastAdjust).asLong();
        }
        return r;
    }

    @Override
    public Iterator<TimeIndex> iterator() {
        return new RangeIterator(this);
    }

    private void normalize() {
        if (this.getSize() <= 0L) {
            this.first = 0L;
            this.last = -1L;
        }
    }

    public long getFirstIndex() {
        return this.first;
    }

    public long getLastIndex() {
        return this.last;
    }

    public int getSizeAsInt() throws T2Exception {
        long size = this.getSize();
        if (size > Integer.MAX_VALUE) {
            throw T2Msg.exception("T5008", this.domain.time(this.first).toString(), this.domain.time(this.last).toString());
        }
        return (int)size;
    }

    public long getSize() {
        return this.getLastIndex() - this.getFirstIndex() + 1L;
    }

    public TimeDomain getTimeDomain() {
        return this.domain;
    }

    public boolean isEmpty() {
        return this.first > this.last;
    }

    public boolean isInRange(long index) {
        return index >= this.first && index <= this.last;
    }

    public boolean isInRange(TimeIndex time) throws T2Exception {
        this.getTimeDomain().requireEquality(time.getTimeDomain());
        return this.isInRange(time.asLong());
    }

    public boolean isInRange(Range range) throws T2Exception {
        this.getTimeDomain().requireEquality(range.getTimeDomain());
        return this.isInRange(range.first) && this.isInRange(range.last);
    }

    public TimeIndex getFirst() {
        if (this.first > this.last) {
            return null;
        }
        return this.domain.time(this.first);
    }

    public TimeIndex getLast() {
        if (this.first > this.last) {
            return null;
        }
        return this.domain.time(this.last);
    }

    public Range union(Range range) throws T2Exception {
        this.getTimeDomain().requireEquality(range.getTimeDomain());
        Range union = null;
        if (range.isEmpty()) {
            union = new Range(this);
        } else if (this.isEmpty()) {
            union = new Range(range);
        } else {
            long t1 = Math.min(this.first, range.getFirstIndex());
            long t2 = Math.max(this.last, range.getLastIndex());
            union = new Range(this.domain, t1, t2);
        }
        return union;
    }

    public Range intersection(Range range) throws T2Exception {
        this.getTimeDomain().requireEquality(range.getTimeDomain());
        Range inter = null;
        if (this.isEmpty() || range.isEmpty() || range.getFirstIndex() > this.last || this.first > range.getLastIndex()) {
            inter = new Range(this.domain);
        } else {
            long t1 = Math.max(this.first, range.getFirstIndex());
            long t2 = Math.min(this.last, range.getLastIndex());
            inter = new Range(this.domain, t1, t2);
        }
        return inter;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        return "[" + this.getFirst().toString() + ", " + this.getLast().toString() + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Range)) {
            return false;
        }
        Range r = (Range)obj;
        if (!this.domain.equals(r.getTimeDomain())) {
            return false;
        }
        return this.first == r.getFirstIndex() && this.last == r.getLastIndex();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.domain.hashCode();
            this.hash = 31 * this.hash + new Long(this.first).hashCode();
            this.hash = 31 * this.hash + new Long(this.last).hashCode();
        }
        return this.hash;
    }

    public class RangeIterator
    implements Iterator<TimeIndex> {
        private Range range;
        private TimeIndex next;

        public RangeIterator(Range range2) {
            this.range = range2;
            this.next = range2.isEmpty() ? null : range2.getFirst();
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next.asLong() <= this.range.getLastIndex();
        }

        @Override
        public TimeIndex next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TimeIndex result = this.next;
            try {
                this.next = this.next.add(1L);
            }
            catch (T2Exception e) {
                this.next = null;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

