/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeDomainDefinition;
import ch.agent.t2.time.TimeDomainManager;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.time.engine.Time2;

public class Day
extends Time2 {
    public static final TimeDomainDefinition DEF = new TimeDomainDefinition("daily", Resolution.DAY, 0L);
    public static final TimeDomain DOMAIN = TimeDomainManager.getFactory().get(DEF, true);

    public Day(TimeIndex time) throws T2Exception {
        super(DOMAIN, time.asLong());
        if (DOMAIN != time.getTimeDomain()) {
            throw T2Msg.exception("T1073", time.getTimeDomain().getLabel(), DOMAIN.getLabel());
        }
    }

    public Day(String date) throws T2Exception {
        super(DOMAIN, date);
    }

    public Day(long year, int month, int day) throws T2Exception {
        super(DOMAIN, year, month, day, 0, 0, 0, 0, Adjustment.NONE);
    }

    public boolean isWeekEnd() throws T2Exception {
        switch (this.getDayOfWeek()) {
            case Sun: 
            case Sat: {
                return true;
            }
        }
        return false;
    }
}

