/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.timeseries;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Range;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.timeseries.AbstractTimeSeries;
import ch.agent.t2.timeseries.Filler;
import ch.agent.t2.timeseries.Observation;
import ch.agent.t2.timeseries.TimeAddressable;
import ch.agent.t2.timeseries.TimeIndexable;
import ch.agent.t2.timeseries.UpdateReviewer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class RegularTimeSeries<T>
extends AbstractTimeSeries<T>
implements TimeIndexable<T> {
    private List<T> data;
    private T[] template;
    private long start;
    private T[] empty;
    private int maxGap;

    private RegularTimeSeries() {
    }

    protected RegularTimeSeries(TimeDomain domain, T[] template, T missingValue, int maxGap) {
        super(domain, missingValue);
        this.data = new ArrayList<T>();
        this.start = -1L;
        this.template = template;
        this.empty = new ArrayList(0).toArray(template);
        this.maxGap = maxGap;
    }

    private RegularTimeSeries(RegularTimeSeries<T> ts, int fromOffset, int toOffset) {
        super(ts.getTimeDomain(), ts.getMissingValue());
        this.template = ts.template;
        this.empty = ts.empty;
        this.maxGap = ts.maxGap;
        if (toOffset > fromOffset) {
            this.data = new ArrayList<T>(ts.data.subList(fromOffset, toOffset));
            this.start = ts.start + (long)fromOffset;
        } else {
            this.data = new ArrayList<T>();
            this.start = -1L;
        }
    }

    @Override
    public Iterator<Observation<T>> iterator() {
        return new TimeSeriesIterator(this.start, this.data);
    }

    @Override
    public TimeAddressable<T> get(Range range) throws T2Exception {
        this.getTimeDomain().requireEquality(range.getTimeDomain());
        if (range.isEmpty()) {
            return new RegularTimeSeries<T>(this, 0, -1);
        }
        return this.get(range.getFirstIndex(), range.getLastIndex());
    }

    @Override
    public TimeAddressable<T> get(long first, long last) throws T2Exception {
        if (first > last) {
            if (first == 0L && last == -1L) {
                return new RegularTimeSeries<T>(this, 0, -1);
            }
            throw T2Msg.exception("T5016", this.getTimeDomain().time(first).toString(), this.getTimeDomain().time(last).toString());
        }
        if (this.start < 0L) {
            return new RegularTimeSeries<T>(this, 0, -1);
        }
        int fromOffset = this.offset(first, this.start);
        if (fromOffset < 0) {
            fromOffset = 0;
        }
        if (fromOffset >= this.data.size()) {
            return new RegularTimeSeries<T>(this, 0, -1);
        }
        long toOffset = (long)fromOffset + last - first + 1L;
        if (toOffset > (long)this.data.size() || toOffset < 0L) {
            toOffset = this.data.size();
        }
        while (this.data.get(fromOffset) == this.getMissingValue() && (long)(++fromOffset) != toOffset) {
        }
        if ((long)fromOffset < toOffset) {
            while (this.data.get((int)toOffset - 1) == this.getMissingValue() && (long)fromOffset < toOffset) {
                --toOffset;
            }
        }
        return new RegularTimeSeries<T>(this, fromOffset, (int)toOffset);
    }

    @Override
    protected Observation<T> internalGetLast(long index) throws T2Exception {
        long last;
        Object value = this.get(index);
        if (this.isMissing(value) && (last = this.internalGetLastIndex()) >= 0L) {
            if (index > last) {
                value = this.get(last);
                index = last;
            } else {
                long first = this.internalGetFirstIndex();
                while (index > first && this.isMissing(value)) {
                    value = this.get(--index);
                }
            }
        }
        if (this.isMissing(value)) {
            return null;
        }
        return new Observation(this.getTimeDomain(), index, value);
    }

    @Override
    protected Observation<T> internalGetFirst(long index) throws T2Exception {
        long first;
        Object value = this.get(index);
        if (this.isMissing(value) && (first = this.internalGetFirstIndex()) >= 0L) {
            if (index < first) {
                value = this.get(first);
                index = first;
            } else {
                long last = this.internalGetLastIndex();
                while (index < last && this.isMissing(value)) {
                    value = this.get(++index);
                }
            }
        }
        if (this.isMissing(value)) {
            return null;
        }
        return new Observation(this.getTimeDomain(), index, value);
    }

    @Override
    public int getValueCount() {
        T[] values = this.getArray();
        int valueCount = 0;
        for (T d : values) {
            if (this.isMissing(d)) continue;
            ++valueCount;
        }
        return valueCount;
    }

    @Override
    public boolean isIndexable() {
        return true;
    }

    @Override
    public int getMaxGap() {
        return this.maxGap;
    }

    @Override
    public TimeIndexable<T> makeEmptyCopy() {
        return new RegularTimeSeries<T>(this.getTimeDomain(), this.template, this.getMissingValue(), this.maxGap);
    }

    @Override
    public TimeIndexable<T> asIndexable() throws T2Exception {
        return this;
    }

    @Override
    public TimeIndexable<T> copy() throws T2Exception {
        TimeAddressable ts = this.makeEmptyCopy();
        ts.put(this, null);
        return ts;
    }

    @Override
    public T[] getArray() {
        if (this.start < 0L) {
            return this.empty;
        }
        return this.data.toArray(this.template);
    }

    @Override
    public T[] getArray(Range range) throws T2Exception {
        long first = range.getFirstIndex();
        long last = range.getLastIndex();
        if (this.start < 0L) {
            return this.empty;
        }
        int firstOffset = this.offset(first, this.start);
        int lastOffset = this.offset(last, this.start);
        if (firstOffset >= this.data.size()) {
            return this.empty;
        }
        if (lastOffset >= this.data.size()) {
            lastOffset = this.data.size() - 1;
        }
        return this.data.subList(firstOffset, lastOffset + 1).toArray(this.template);
    }

    @Override
    public void put(long index, T[] values) throws T2Exception {
        if (this.getSize() != 0) {
            super.put(index, values);
        } else {
            int firstNonMissing = 0;
            int lastNonMissing = -1;
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.normalizeMissingValue(values[i]);
                if (this.isMissing(values[i])) {
                    if (firstNonMissing != i) continue;
                    firstNonMissing = i + 1;
                    continue;
                }
                lastNonMissing = i;
            }
            if (lastNonMissing >= 0) {
                if (firstNonMissing == 0 && lastNonMissing == values.length - 1) {
                    this.data.addAll(0, Arrays.asList(values));
                    this.start = index;
                } else {
                    this.data.addAll(0, Arrays.asList(values).subList(firstNonMissing, lastNonMissing + 1));
                    this.start = index + (long)firstNonMissing;
                }
            }
        }
    }

    @Override
    public void put(TimeAddressable<T> values, UpdateReviewer<T> reviewer) throws T2Exception {
        if (reviewer != null || this.getSize() != 0 || !values.isIndexable()) {
            super.put(values, reviewer);
        } else {
            this.data.addAll(0, ((AbstractTimeSeries)values).internalGetData());
            this.start = ((AbstractTimeSeries)values).internalGetFirstIndex();
        }
    }

    private void append(T value, long repetitions) {
        if ((long)this.data.size() + repetitions > Integer.MAX_VALUE) {
            throw new RuntimeException("too many repetitions: " + repetitions);
        }
        if (repetitions > 0L) {
            while (repetitions > 0L) {
                this.data.add(value);
                --repetitions;
            }
        }
    }

    @Override
    public int fill(T replacement, long tailLength) throws T2Exception {
        Object mv = this.getMissingValue();
        if (replacement == null && mv != null) {
            throw T2Msg.exception("T5015", new Object[0]);
        }
        if (replacement.equals(mv) && tailLength > 0L) {
            throw T2Msg.exception("T5020", new Object[0]);
        }
        replacement = mv;
        int count = 0;
        T[] val = this.getArray();
        if (val == null) {
            return count;
        }
        for (int i = 0; i < val.length; ++i) {
            if (!this.isMissing(val[i])) continue;
            val[i] = replacement;
            ++count;
        }
        if (count > 0) {
            this.data.clear();
            this.data.addAll(Arrays.asList(val));
        }
        if (tailLength > 0L) {
            this.append(replacement, tailLength);
            count = (int)((long)count + tailLength);
        }
        return count;
    }

    @Override
    public int fill(long tailLength) {
        int count = 0;
        T[] val = this.getArray();
        if (val == null) {
            return count;
        }
        for (int i = 1; i < val.length; ++i) {
            if (!this.isMissing(val[i]) || this.isMissing(val[i - 1])) continue;
            val[i] = val[i - 1];
            ++count;
        }
        if (count > 0) {
            this.data.clear();
            this.data.addAll(Arrays.asList(val));
        }
        if (tailLength > 0L && val.length > 0) {
            T replacement = val[val.length - 1];
            this.append(replacement, tailLength);
            count = (int)((long)count + tailLength);
        }
        return count;
    }

    @Override
    public int fill(Filler<T> interpolator) throws T2Exception {
        int count = 0;
        T[] val = this.getArray();
        if (val == null) {
            return count;
        }
        int mvStart = -1;
        for (int i = 0; i < val.length; ++i) {
            if (this.isMissing(val[i])) {
                ++count;
                if (mvStart != -1) continue;
                mvStart = i;
                continue;
            }
            if (mvStart > 0) {
                try {
                    interpolator.fillHole(val, mvStart - 1, i);
                }
                catch (Exception e) {
                    Range range = new Range(this.getTimeDomain(), this.getFirstIndex() + (long)mvStart, this.getFirstIndex() + (long)i - 1L);
                    throw T2Msg.exception(e, "T5017", range.toString());
                }
                for (int j = mvStart; j < i; ++j) {
                    val[j] = this.normalizeMissingValue(val[j]);
                }
            }
            mvStart = -1;
        }
        if (count > 0) {
            this.data.clear();
            this.data.addAll(Arrays.asList(val));
        }
        return count;
    }

    @Override
    protected void internalClear() {
        this.data.clear();
        this.start = -1L;
    }

    @Override
    protected T internalGet(long index) throws T2Exception {
        if (this.start < 0L) {
            return this.getMissingValue();
        }
        int offset = this.offset(index, this.start);
        if (offset < 0 || offset >= this.data.size()) {
            return this.getMissingValue();
        }
        return this.data.get(offset);
    }

    @Override
    protected Collection<T> internalGetData() {
        return this.data;
    }

    @Override
    protected long internalGetFirstIndex() {
        return this.start;
    }

    @Override
    protected long internalGetLastIndex() {
        if (this.start < 0L) {
            return this.start;
        }
        return this.start + (long)this.internalGetSize() - 1L;
    }

    @Override
    protected int internalGetSize() {
        return this.data.size();
    }

    @Override
    protected void internalPut(long index, T value) throws T2Exception {
        if (index < 0L) {
            throw new IllegalArgumentException("index < 0");
        }
        value = this.normalizeMissingValue(value);
        if (this.start < 0L) {
            if (!this.isMissing(value)) {
                this.start = index;
                this.data.add(value);
            }
            return;
        }
        int offset = this.offset(index, this.start);
        if (offset >= 0 && offset < this.data.size()) {
            if (this.isMissing(value)) {
                if (offset == 0) {
                    ++this.start;
                    this.data.remove(0);
                    this.removeBeginningMissingValues();
                }
                if (offset == this.data.size() - 1) {
                    this.data.remove(offset);
                    this.removeEndingMissingValues();
                }
            } else {
                this.data.set(offset, value);
            }
        } else {
            if (this.isMissing(value)) {
                return;
            }
            if (offset < 0) {
                int padSize = -offset - 1;
                if (padSize > 0) {
                    if (padSize > this.maxGap) {
                        throw T2Msg.exception("T5018", padSize, this.maxGap, this.getTimeDomain().time(index).toString());
                    }
                    ArrayList pad = new ArrayList(padSize);
                    for (int i = 0; i < padSize; ++i) {
                        pad.add(this.getMissingValue());
                    }
                    this.data.addAll(0, pad);
                }
                this.data.add(0, value);
                this.start = index;
            } else {
                int padSize = offset - this.data.size();
                if (padSize > 0) {
                    if (padSize > this.maxGap) {
                        throw T2Msg.exception("T5019", padSize, this.maxGap, this.getTimeDomain().time(index).toString());
                    }
                    ArrayList pad = new ArrayList(padSize);
                    for (int i = 0; i < padSize; ++i) {
                        pad.add(this.getMissingValue());
                    }
                    this.data.addAll(pad);
                }
                this.data.add(value);
            }
        }
    }

    @Override
    protected void internalRemove(long index) throws T2Exception {
        this.internalPut(index, this.getMissingValue());
    }

    @Override
    protected void internalSetBounds(long first, long last) throws T2Exception {
        this.data = this.data.subList((int)(first - this.start), (int)(last - this.start + 1L));
        this.start = first;
        this.removeBeginningMissingValues();
        this.removeEndingMissingValues();
    }

    private void removeBeginningMissingValues() {
        while (this.data.size() > 0 && this.isMissing(this.data.get(0))) {
            this.data.remove(0);
            ++this.start;
        }
    }

    private void removeEndingMissingValues() {
        while (this.data.size() > 0 && this.isMissing(this.data.get(this.data.size() - 1))) {
            this.data.remove(this.data.size() - 1);
        }
    }

    private int offset(long index, long start) throws T2Exception {
        long offset = index - start;
        if (offset < Integer.MIN_VALUE || offset > Integer.MAX_VALUE) {
            throw T2Msg.exception("T1058", index, start);
        }
        return (int)offset;
    }

    public class TimeSeriesIterator
    implements Iterator<Observation<T>> {
        private Iterator<T> dataIt;
        private long index;
        private TimeDomain domain;

        public TimeSeriesIterator(long start, List<T> data) {
            this.dataIt = data.iterator();
            this.domain = RegularTimeSeries.this.getTimeDomain();
            this.index = start;
        }

        @Override
        public boolean hasNext() {
            return this.dataIt.hasNext();
        }

        @Override
        public Observation<T> next() {
            Observation obs = new Observation(this.domain, this.index++, this.dataIt.next());
            return obs;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

