/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time.engine;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Adjustment;
import ch.agent.t2.time.BasePeriodPattern;
import ch.agent.t2.time.DayOfWeek;
import ch.agent.t2.time.ExternalTimeFormat;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.SubPeriodPattern;
import ch.agent.t2.time.TimeDomain;
import ch.agent.t2.time.TimeDomainDefinition;
import ch.agent.t2.time.TimeIndex;
import ch.agent.t2.time.TimePacker;
import ch.agent.t2.time.TimeParts;
import ch.agent.t2.time.engine.Time2;
import ch.agent.t2.time.engine.TimeTools;

public class TimeFactory
implements TimeDomain,
TimePacker,
ExternalTimeFormat {
    private int hash;
    private String label;
    private Resolution baseUnit;
    private long origin;
    private ExternalTimeFormat externalFormat;
    private BasePeriodPattern basePeriodPattern;
    private SubPeriodPattern subPeriodPattern;
    private int serialNumber = -1;
    private TimeIndex minTime;
    private TimeIndex maxTime;
    private TimeIndex minOffsetCompatibleTime;
    private TimeIndex maxOffsetCompatibleTime;
    private long minNumericTime;
    private long maxNumericTime;

    protected TimeFactory(TimeDomainDefinition def, ExternalTimeFormat externalFormat) {
        this.label = def.getLabel();
        this.baseUnit = def.getBaseUnit();
        this.origin = def.getOrigin();
        this.basePeriodPattern = def.getBasePeriodPattern();
        if (this.basePeriodPattern != null && !this.basePeriodPattern.effective()) {
            this.basePeriodPattern = null;
        }
        this.subPeriodPattern = def.getSubPeriodPattern();
        this.externalFormat = externalFormat;
        this.minNumericTime = 0L;
        this.maxNumericTime = this.findMaxIndex(this.basePeriodPattern, this.subPeriodPattern);
    }

    boolean isBuiltIn() {
        return this.serialNumber >= 0;
    }

    void markBuiltIn(int serialNumber) {
        if (serialNumber < 0) {
            throw new IllegalArgumentException("serialNumber negative");
        }
        this.serialNumber = serialNumber;
    }

    int getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public String getLabel() {
        return this.label != null ? this.label : this.toString();
    }

    @Override
    public long getOrigin() {
        return this.origin;
    }

    @Override
    public Resolution getResolution() {
        if (this.subPeriodPattern != null) {
            return this.subPeriodPattern.getSubPeriod();
        }
        return this.baseUnit;
    }

    @Override
    public int compareResolutionTo(Resolution unit) {
        return -this.getResolution().compareTo(unit);
    }

    @Override
    public void requireEquality(TimeDomain domain) throws T2Exception {
        if (!this.equals(domain)) {
            throw T2Msg.exception("T1074", this.getLabel(), domain.getLabel());
        }
    }

    private boolean equals(Object o1, Object o2) {
        return o1 == null && o2 == null || o1 != null && o1.equals(o2);
    }

    public boolean matches(Resolution baseUnit, long origin, BasePeriodPattern basePattern, SubPeriodPattern subPattern) {
        if (!this.baseUnit.equals((Object)baseUnit)) {
            return false;
        }
        if (origin != this.origin) {
            return false;
        }
        if (!this.equals(this.basePeriodPattern, basePattern)) {
            return false;
        }
        return this.equals(this.subPeriodPattern, subPattern);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeFactory)) {
            return false;
        }
        if (!((TimeFactory)obj).baseUnit.equals((Object)this.baseUnit)) {
            return false;
        }
        if (((TimeFactory)obj).origin != this.origin) {
            return false;
        }
        if (!this.equals(this.basePeriodPattern, ((TimeFactory)obj).basePeriodPattern)) {
            return false;
        }
        return this.equals(this.subPeriodPattern, ((TimeFactory)obj).subPeriodPattern);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = new Long(this.origin).hashCode();
            h = 31 * h + this.baseUnit.hashCode();
            if (this.basePeriodPattern != null) {
                h = 31 * h + this.basePeriodPattern.hashCode();
            }
            if (this.subPeriodPattern != null) {
                h = 31 * h + this.subPeriodPattern.hashCode();
            }
            this.hash = h;
        }
        return h;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("L=" + this.label);
        s.append(" O=" + this.origin);
        s.append(" U=" + (Object)((Object)this.baseUnit));
        s.append(" P=" + this.basePeriodPattern);
        s.append(" S=" + this.subPeriodPattern);
        return s.toString();
    }

    @Override
    public TimeIndex time(long year, int month, int day, int hour, int min, int sec, int usec, Adjustment adjust) throws T2Exception {
        return new Time2(this, year, month, day, hour, min, sec, usec, adjust);
    }

    @Override
    public TimeIndex time(String date) throws T2Exception {
        return new Time2(this, date, Adjustment.NONE);
    }

    @Override
    public TimeIndex time(String date, Adjustment adjust) throws T2Exception {
        return new Time2(this, date, adjust);
    }

    @Override
    public TimeIndex minTime() {
        if (this.minTime == null) {
            this.minTime = new Time2((TimeDomain)this, this.minNumericTime);
        }
        return this.minTime;
    }

    @Override
    public TimeIndex maxTime() {
        return this.maxTime(false);
    }

    @Override
    public TimeIndex minTime(boolean offsetCompatible) {
        if (offsetCompatible) {
            if (this.minOffsetCompatibleTime == null) {
                this.minOffsetCompatibleTime = new Time2((TimeDomain)this, Integer.MIN_VALUE + this.getOrigin());
            }
            return this.minOffsetCompatibleTime;
        }
        if (this.minTime == null) {
            this.minTime = new Time2((TimeDomain)this, this.minNumericTime);
        }
        return this.minTime;
    }

    @Override
    public TimeIndex maxTime(boolean offsetCompatible) {
        if (offsetCompatible) {
            if (this.maxOffsetCompatibleTime == null) {
                this.maxOffsetCompatibleTime = new Time2((TimeDomain)this, Integer.MAX_VALUE + this.getOrigin());
            }
            return this.maxOffsetCompatibleTime;
        }
        if (this.maxTime == null) {
            this.maxTime = new Time2((TimeDomain)this, this.maxNumericTime);
        }
        return this.maxTime;
    }

    @Override
    public TimeIndex time(long index) {
        return new Time2((TimeDomain)this, index);
    }

    @Override
    public TimeIndex timeFromOffset(long offset) {
        return new Time2((TimeDomain)this, offset + this.getOrigin());
    }

    @Override
    public boolean valid(long t, boolean testOnly) throws T2Exception {
        if (t >= this.minNumericTime && t <= this.maxNumericTime) {
            return true;
        }
        if (testOnly) {
            return false;
        }
        throw T2Msg.exception("T1070", t);
    }

    @Override
    public BasePeriodPattern getBasePeriodPattern() {
        return this.basePeriodPattern;
    }

    @Override
    public SubPeriodPattern getSubPeriodPattern() {
        return this.subPeriodPattern;
    }

    @Override
    public TimeParts scan(String time) throws T2Exception {
        return this.externalFormat.scan(time);
    }

    @Override
    public String format(Resolution unit, TimeParts timeParts) {
        return this.externalFormat.format(unit, timeParts);
    }

    @Override
    public long pack(TimeParts tp, Adjustment adjust) throws T2Exception {
        try {
            long time = tp.asRawIndex(this.baseUnit);
            if (this.subPeriodPattern == null) {
                time = this.compress(time, adjust);
            } else {
                time = this.compress(time, Adjustment.NONE);
                time = this.subPeriodPattern.adjustForSubPeriod(time, adjust, tp);
            }
            return time;
        }
        catch (T2Exception e) {
            String messageKey = this.subPeriodPattern == null ? "T1068" : "T1069";
            throw T2Msg.exception(e, messageKey, tp.toString(), this.getLabel());
        }
    }

    @Override
    public TimeParts unpack(long time) {
        int subPeriod = 0;
        if (this.subPeriodPattern != null) {
            int sz = this.subPeriodPattern.getSize();
            long orig = time;
            subPeriod = (int)(orig - (time /= (long)sz) * (long)sz);
        }
        if (this.basePeriodPattern != null) {
            time = this.basePeriodPattern.expandIndex(time);
        }
        TimeParts tp = new TimeParts();
        Resolution unit = this.baseUnit;
        switch (unit) {
            case YEAR: {
                tp.setYear(time);
                break;
            }
            case MONTH: {
                tp.setYear(time / 12L);
                tp.setMonth((int)(time - tp.getYear() * 12L) + 1);
                break;
            }
            case DAY: {
                TimeTools.computeYMD(time, tp);
                break;
            }
            case HOUR: {
                long days = time / 24L;
                tp.setHour((int)(time - days * 24L));
                TimeTools.computeYMD(days, tp);
                break;
            }
            case MIN: {
                long days = time / 1440L;
                long minutes = time - days * 24L * 60L;
                tp.setHour((int)(minutes / 60L));
                tp.setMin((int)(minutes - (long)(tp.getHour() * 60)));
                TimeTools.computeYMD(days, tp);
                break;
            }
            case SEC: {
                long days = time / 86400L;
                long seconds = time - days * 24L * 60L * 60L;
                TimeTools.computeYMD(days, tp);
                TimeTools.computeHMS(seconds, tp);
                break;
            }
            case MSEC: {
                long days = time / 86400000L;
                long millis = time - days * 24L * 60L * 60L * 1000L;
                long seconds = millis / 1000L;
                tp.setUsec((int)(millis - seconds * 1000L) * 1000);
                TimeTools.computeYMD(days, tp);
                TimeTools.computeHMS(seconds, tp);
                break;
            }
            case USEC: {
                long days = time / 86400000000L;
                long micros = time - days * 24L * 60L * 60L * 1000000L;
                long seconds = micros / 1000000L;
                tp.setUsec((int)(micros - seconds * 1000000L));
                TimeTools.computeYMD(days, tp);
                TimeTools.computeHMS(seconds, tp);
                break;
            }
            default: {
                throw new RuntimeException("bug: " + unit.name());
            }
        }
        if (this.subPeriodPattern != null) {
            this.subPeriodPattern.fillInSubPeriod(subPeriod, tp);
        }
        if (tp.anyNegative()) {
            throw new RuntimeException(String.format("(bug) time=%d %s", time, tp.toString()));
        }
        return tp;
    }

    @Override
    public DayOfWeek getDayOfWeek(TimeIndex time) throws T2Exception {
        if (this.subPeriodPattern != null) {
            if (this.compareResolutionTo(Resolution.DAY) <= 0) {
                long numTime = ((Time2)time).getTimeParts().asRawIndex(Resolution.DAY);
                return TimeTools.getDayOfWeek(Resolution.DAY, numTime);
            }
            throw T2Msg.exception("T1060", new Object[]{this.getResolution()});
        }
        long t = this.basePeriodPattern == null ? time.asLong() : this.basePeriodPattern.expandIndex(time.asLong());
        return TimeTools.getDayOfWeek(this.getResolution(), t);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long compress(long time, Adjustment adjust) throws T2Exception {
        if (this.basePeriodPattern != null) {
            if (time < 0L) {
                throw T2Msg.exception("T1070", time);
            }
            if (adjust == Adjustment.NONE) {
                return this.basePeriodPattern.makeIndex(time);
            }
            while (true) {
                try {
                    return this.basePeriodPattern.makeIndex(time);
                }
                catch (T2Exception e) {
                    time = this.adjust(time, adjust == Adjustment.UP);
                    continue;
                }
                break;
            }
        }
        this.valid(time, false);
        return time;
    }

    private long adjust(long time, boolean up) throws T2Exception {
        long result = time;
        result = up ? ++result : --result;
        if (result < 0L && time > 0L || result > 0L && time < 0L) {
            throw T2Msg.exception("T1072", new Object[0]);
        }
        return result;
    }

    private long findMaxIndex(BasePeriodPattern basePattern, SubPeriodPattern subPattern) {
        long maxIndex = Long.MAX_VALUE;
        if (subPattern != null) {
            maxIndex /= (long)subPattern.getSize();
        }
        if (basePattern != null) {
            for (int i = 0; i < basePattern.getSize(); ++i) {
                try {
                    return basePattern.makeIndex(maxIndex - (long)i);
                }
                catch (T2Exception e) {
                    continue;
                }
            }
            throw new RuntimeException("bug: " + maxIndex);
        }
        return maxIndex;
    }
}

