/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.engine.TimeTools;

public class TimeParts {
    private long year;
    private int month = 1;
    private int day = 1;
    private int hour;
    private int min;
    private int sec;
    private int usec;
    private TimeZoneOffset timeZoneOffset;

    public long getYear() {
        return this.year;
    }

    public void setYear(long year) {
        this.year = year;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getSec() {
        return this.sec;
    }

    public void setSec(int sec) {
        this.sec = sec;
    }

    public int getUsec() {
        return this.usec;
    }

    public void setUsec(int usec) {
        this.usec = usec;
    }

    public void setTimeZoneOffset(TimeZoneOffset timeZoneOffset) {
        this.timeZoneOffset = timeZoneOffset;
    }

    protected int checkTimeComponentsAndApplyTimeZoneOffset() throws T2Exception {
        if (this.hour < 0 || this.hour > 23) {
            throw T2Msg.exception("T1017", this.hour);
        }
        if (this.min < 0 || this.min > 59) {
            throw T2Msg.exception("T1019", this.min);
        }
        if (this.sec < 0 || this.sec > 59) {
            throw T2Msg.exception("T1022", this.sec);
        }
        if (this.usec < 0 || this.usec > 999999) {
            throw T2Msg.exception("T1026", this.usec);
        }
        int overflow = 0;
        if (this.timeZoneOffset != null) {
            if (this.timeZoneOffset.isNegative()) {
                this.usec -= this.timeZoneOffset.usec;
                if (this.usec > 999999) {
                    this.usec -= 1000000;
                    ++this.sec;
                }
                this.sec -= this.timeZoneOffset.sec;
                if (this.sec > 59) {
                    this.sec -= 60;
                    ++this.min;
                }
                this.min -= this.timeZoneOffset.min;
                if (this.min > 59) {
                    this.min -= 60;
                    ++this.hour;
                }
                this.hour -= this.timeZoneOffset.hour;
                if (this.hour > 23) {
                    this.hour -= 24;
                    overflow = 1;
                }
            } else {
                this.usec -= this.timeZoneOffset.usec;
                if (this.usec < 0) {
                    this.usec += 1000000;
                    --this.sec;
                }
                this.sec -= this.timeZoneOffset.sec;
                if (this.sec < 0) {
                    this.sec += 60;
                    --this.min;
                }
                this.min -= this.timeZoneOffset.min;
                if (this.min < 0) {
                    this.min += 60;
                    --this.hour;
                }
                this.hour -= this.timeZoneOffset.hour;
                if (this.hour < 0) {
                    this.hour += 24;
                    overflow = -1;
                }
            }
            this.timeZoneOffset = null;
        }
        return overflow;
    }

    public long asRawIndex(Resolution unit) throws T2Exception {
        long time = 0L;
        if (this.year < 0L) {
            throw T2Msg.exception("T1014", this.year);
        }
        if (unit == Resolution.YEAR) {
            time = this.year;
        } else {
            if (this.month < 1 || this.month > 12) {
                throw T2Msg.exception("T1015", this.month);
            }
            if (unit == Resolution.MONTH) {
                time = this.year * 12L + (long)this.month - 1L;
            } else {
                int daysInThisMonth = TimeTools.daysInMonth(this.year, this.month);
                if (this.day < 1 || this.day > daysInThisMonth) {
                    throw T2Msg.exception("T1016", this.day, daysInThisMonth);
                }
                time = this.year * 365L + TimeTools.leapYears(this.year) + (long)TimeTools.daysToMonth(this.year, this.month) + (long)this.day - 1L;
                if (unit != Resolution.DAY) {
                    if (this.hour == 24 && this.min == 0 && this.sec == 0 && this.usec == 0) {
                        this.hour = 0;
                        ++time;
                    }
                    if (this.sec == 60) {
                        if (this.hour == 23 && this.min == 59 && this.usec == 0 && this.month == 12 && this.day == 31 || this.month == 6 && this.day == 30) {
                            this.sec = 59;
                        } else {
                            throw T2Msg.exception("T1025", new Object[0]);
                        }
                    }
                    time += (long)this.checkTimeComponentsAndApplyTimeZoneOffset();
                    time = time * 24L + (long)this.hour;
                    if (unit != Resolution.HOUR) {
                        time = time * 60L + (long)this.min;
                        if (unit != Resolution.MIN) {
                            time = time * 60L + (long)this.sec;
                            if (unit != Resolution.SEC) {
                                if (unit == Resolution.MSEC) {
                                    time = time * 1000L + (long)(this.usec / 1000);
                                } else if (unit == Resolution.USEC) {
                                    time = time * 1000000L + (long)this.usec;
                                } else {
                                    throw new RuntimeException("bug: " + unit.name());
                                }
                            }
                        }
                    }
                }
            }
        }
        return time;
    }

    public boolean anyNegative() {
        return this.getYear() < 0L || this.getMonth() < 0 || this.getDay() < 0 || this.getHour() < 0 || this.getMin() < 0 || this.getSec() < 0 || this.getUsec() < 0;
    }

    public String toString() {
        return String.format("%04d-%02d-%02d %02d:%02d:%02d.%06d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMin(), this.getSec(), this.getUsec());
    }

    public class TimeZoneOffset {
        private int hour;
        private int min;
        private int sec;
        private int usec;
        private int sign;

        public TimeZoneOffset(boolean negative) {
            this.sign = negative ? -1 : 1;
        }

        public boolean isNegative() {
            return this.sign < 0;
        }

        public int getHour() {
            return this.hour;
        }

        public void setHour(int hour) throws T2Exception {
            if (hour < 0 || hour > 11) {
                throw T2Msg.exception("T1018", hour);
            }
            this.hour = this.sign * hour;
        }

        public int getMin() {
            return this.min;
        }

        public void setMin(int min) throws T2Exception {
            if (min < 0 || min > 59) {
                throw T2Msg.exception("T1021", min);
            }
            this.min = this.sign * min;
        }

        public int getSec() {
            return this.sec;
        }

        public void setSec(int sec) throws T2Exception {
            if (sec < 0 || sec > 59) {
                throw T2Msg.exception("T1023", sec);
            }
            this.sec = this.sign * sec;
        }

        public int getUsec() {
            return this.usec;
        }

        public void setUsec(int usec) throws T2Exception {
            if (usec < 0 || usec > 999999) {
                throw T2Msg.exception("T1027", usec);
            }
            this.usec = this.sign * usec;
        }
    }
}

