/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.ExternalTimeFormat;
import ch.agent.t2.time.Resolution;
import ch.agent.t2.time.TimeParts;
import java.util.Formatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultExternalFormat
implements ExternalTimeFormat {
    private static final String PATTERN_1 = "((?:\\+\\d+)?\\d\\d\\d\\d)(?:-(\\d\\d)(?:-(\\d\\d)(?:[T ]([0-9:.,]*)(?:Z|([+-][0-9:.,]*))?)?)?)?";
    private static final String PATTERN_2 = "(\\d\\d\\d\\d)(?:(\\d\\d)(?:(\\d\\d)(?:T([0-9:.,]*)(?:Z|([+-][0-9:.,]*))?)?)?)?";
    private static final String TIME_PATTERN_1 = "(\\d\\d)(?::(\\d\\d)(?::(\\d\\d)(?:[.,](\\d\\d?\\d?\\d?\\d?\\d?))?)?)?";
    private static final String TIME_PATTERN_2 = "(\\d\\d)(?:(\\d\\d)(?:(\\d\\d)(?:[.,](\\d\\d?\\d?\\d?\\d?\\d?))?)?)?";
    private Matcher matcher1;
    private Matcher timeMatcher1;
    private Matcher matcher2;
    private Matcher timeMatcher2;

    public static DefaultExternalFormat getInstance() {
        return Singleton.singleton;
    }

    public DefaultExternalFormat() {
        try {
            this.matcher1 = Pattern.compile(PATTERN_1).matcher("");
            this.timeMatcher1 = Pattern.compile(TIME_PATTERN_1).matcher("");
            this.matcher2 = Pattern.compile(PATTERN_2).matcher("");
            this.timeMatcher2 = Pattern.compile(TIME_PATTERN_2).matcher("");
        }
        catch (Exception e) {
            throw new RuntimeException("bug", e);
        }
    }

    @Override
    public TimeParts scan(String datetime) throws T2Exception {
        Matcher timeMatcher;
        Matcher matcher;
        int bigT;
        if (datetime == null) {
            throw new IllegalArgumentException("date null");
        }
        int hyphen = datetime.indexOf(45);
        if (hyphen > 0 && (bigT = datetime.indexOf(84)) >= 0 && bigT < hyphen) {
            hyphen = -1;
        }
        if (hyphen >= 0) {
            matcher = this.matcher1;
            timeMatcher = this.timeMatcher1;
        } else {
            matcher = this.matcher2;
            timeMatcher = this.timeMatcher2;
        }
        matcher.reset(datetime);
        if (!matcher.matches()) {
            throw T2Msg.exception(matcher == this.matcher1 ? "T1081" : "T1082", datetime);
        }
        if (matcher.groupCount() != 5) {
            throw new RuntimeException("bug: unexpected count " + matcher.groupCount());
        }
        TimeParts tp = new TimeParts();
        String group = null;
        try {
            block11: for (int i = 0; i < 5; ++i) {
                group = matcher.group(i + 1);
                if (group == null || group.length() == 0) continue;
                switch (i) {
                    case 0: {
                        try {
                            tp.setYear(Long.valueOf(group));
                        }
                        catch (NumberFormatException e) {
                            if (!group.startsWith("+")) continue block11;
                            tp.setYear(Long.valueOf(group.substring(1)));
                        }
                        continue block11;
                    }
                    case 1: {
                        tp.setMonth(Integer.valueOf(group));
                        continue block11;
                    }
                    case 2: {
                        tp.setDay(Integer.valueOf(group));
                        continue block11;
                    }
                    case 3: {
                        HMSU hmsd = this.scanTime(group, timeMatcher);
                        if (hmsd == null) {
                            throw T2Msg.exception(matcher == this.matcher1 ? "T1083" : "T1084", group);
                        }
                        tp.setHour(hmsd.h);
                        tp.setMin(hmsd.m);
                        tp.setSec(hmsd.s);
                        tp.setUsec(hmsd.u);
                        continue block11;
                    }
                    case 4: {
                        HMSU hmsd = this.scanTime(group.substring(1), timeMatcher);
                        if (hmsd == null) {
                            throw T2Msg.exception(matcher == this.matcher1 ? "T1085" : "T1086", group);
                        }
                        TimeParts timeParts = tp;
                        timeParts.getClass();
                        TimeParts.TimeZoneOffset tzo = new TimeParts.TimeZoneOffset(timeParts, group.startsWith("-"));
                        tzo.setHour(hmsd.h);
                        tzo.setMin(hmsd.m);
                        tzo.setSec(hmsd.s);
                        tzo.setUsec(hmsd.u);
                        tp.setTimeZoneOffset(tzo);
                        continue block11;
                    }
                    default: {
                        throw new RuntimeException("bug: " + i);
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("bug: group not numeric " + group);
        }
        return tp;
    }

    private HMSU scanTime(String time, Matcher matcher) throws T2Exception {
        matcher.reset(time);
        if (!matcher.matches()) {
            return null;
        }
        if (matcher.groupCount() != 4) {
            throw new RuntimeException("bug: unexpected count " + matcher.groupCount());
        }
        HMSU hmsd = new HMSU();
        String group = null;
        try {
            block16: for (int i = 0; i < 4 && (group = matcher.group(i + 1)) != null; ++i) {
                switch (i) {
                    case 0: {
                        hmsd.h = Integer.valueOf(group);
                        continue block16;
                    }
                    case 1: {
                        hmsd.m = Integer.valueOf(group);
                        continue block16;
                    }
                    case 2: {
                        hmsd.s = Integer.valueOf(group);
                        continue block16;
                    }
                    case 3: {
                        int u = Integer.valueOf(group);
                        switch (group.length()) {
                            case 1: {
                                u *= 100000;
                                break;
                            }
                            case 2: {
                                u *= 10000;
                                break;
                            }
                            case 3: {
                                u *= 1000;
                                break;
                            }
                            case 4: {
                                u *= 100;
                                break;
                            }
                            case 5: {
                                u *= 10;
                                break;
                            }
                            case 6: {
                                break;
                            }
                            default: {
                                throw new RuntimeException("bug: " + group.length());
                            }
                        }
                        hmsd.u = u;
                        continue block16;
                    }
                    default: {
                        throw new RuntimeException("bug: " + i);
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("bug: group not numeric " + group);
        }
        return hmsd;
    }

    @Override
    public String format(Resolution unit, TimeParts tp) {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb);
        String plus = tp.getYear() > 9999L ? "+" : "";
        switch (unit) {
            case YEAR: {
                fmt.format("%s%04d", plus, tp.getYear());
                break;
            }
            case MONTH: {
                fmt.format("%s%04d-%02d", plus, tp.getYear(), tp.getMonth());
                break;
            }
            case DAY: {
                fmt.format("%s%04d-%02d-%02d", plus, tp.getYear(), tp.getMonth(), tp.getDay());
                break;
            }
            case HOUR: {
                fmt.format("%s%04d-%02d-%02d %02d", plus, tp.getYear(), tp.getMonth(), tp.getDay(), tp.getHour());
                break;
            }
            case MIN: {
                fmt.format("%s%04d-%02d-%02d %02d:%02d", plus, tp.getYear(), tp.getMonth(), tp.getDay(), tp.getHour(), tp.getMin());
                break;
            }
            case SEC: {
                fmt.format("%s%04d-%02d-%02d %02d:%02d:%02d", plus, tp.getYear(), tp.getMonth(), tp.getDay(), tp.getHour(), tp.getMin(), tp.getSec());
                break;
            }
            case MSEC: {
                fmt.format("%s%04d-%02d-%02d %02d:%02d:%02d.%03d", plus, tp.getYear(), tp.getMonth(), tp.getDay(), tp.getHour(), tp.getMin(), tp.getSec(), tp.getUsec() / 1000);
                break;
            }
            case USEC: {
                fmt.format("%s%04d-%02d-%02d %02d:%02d:%02d.%06d", plus, tp.getYear(), tp.getMonth(), tp.getDay(), tp.getHour(), tp.getMin(), tp.getSec(), tp.getUsec());
                break;
            }
            default: {
                fmt.close();
                throw new RuntimeException("bug: " + unit.name());
            }
        }
        fmt.close();
        return sb.toString();
    }

    private static class Singleton {
        private static DefaultExternalFormat singleton = new DefaultExternalFormat();

        private Singleton() {
        }
    }

    private class HMSU {
        private int h;
        private int m;
        private int s;
        private int u;

        private HMSU() {
        }
    }
}

