/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.t2.time;

import ch.agent.t2.T2Exception;
import ch.agent.t2.T2Msg;
import ch.agent.t2.time.BasePeriodPattern;
import java.util.Arrays;

public class Cycle
implements BasePeriodPattern {
    private boolean[] pattern;
    private int[] map;
    private int[] inverseMap;
    private int cycleLength;
    private int compressedLength;

    public Cycle(boolean ... pattern) {
        if (pattern == null || pattern.length == 0) {
            throw new IllegalArgumentException("pattern null or empty");
        }
        this.pattern = pattern;
        this.computeMaps();
        if (this.cycleLength > 0 && this.compressedLength == 0) {
            throw new IllegalArgumentException("all false pattern");
        }
    }

    @Override
    public int getSize() {
        return this.cycleLength;
    }

    @Override
    public long makeIndex(long time) throws T2Exception {
        if (time < 0L) {
            throw new IllegalArgumentException("time negative");
        }
        if (this.pattern == null) {
            return time;
        }
        long cycles = time / (long)this.cycleLength;
        int remainder = (int)(time - cycles * (long)this.cycleLength);
        int offset = this.map[remainder];
        if (offset < 0) {
            throw T2Msg.exception("T1071", time, remainder);
        }
        return cycles * (long)this.compressedLength + (long)offset;
    }

    @Override
    public long expandIndex(long time) {
        if (this.pattern == null) {
            return time;
        }
        int remainder = (int)(time % (long)this.compressedLength);
        int offset = this.inverseMap[remainder];
        long cycles = (time - (long)remainder) / (long)this.compressedLength;
        return cycles * (long)this.cycleLength + (long)offset;
    }

    @Override
    public boolean effective() {
        return this.cycleLength != this.compressedLength;
    }

    public boolean matches(boolean[] pattern) {
        return Arrays.equals(this.pattern, pattern);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Cycle)) {
            return false;
        }
        return Arrays.equals(this.pattern, ((Cycle)obj).pattern);
    }

    public int hashCode() {
        return Arrays.hashCode(this.pattern);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.pattern != null) {
            for (boolean b : this.pattern) {
                if (b) {
                    s.append('1');
                    continue;
                }
                s.append('0');
            }
        } else {
            s.append("(no cycle)");
        }
        return s.toString();
    }

    private void computeMaps() {
        this.cycleLength = this.pattern.length;
        this.map = new int[this.cycleLength];
        int offset = -1;
        for (int i = 0; i < this.cycleLength; ++i) {
            this.map[i] = this.pattern[i] ? ++offset : -1;
        }
        this.compressedLength = offset + 1;
        this.inverseMap = new int[this.compressedLength];
        int j = -1;
        for (int i = 0; i < this.cycleLength; ++i) {
            if (this.map[i] <= -1) continue;
            this.inverseMap[++j] = i;
        }
    }
}

