/*
 *   Copyright 2011 Hauser Olsson GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * Package: ch.agent.t2.time
 * Type: DayOfWeek
 * Version: 1.0.0
 */
package ch.agent.t2.time;

/**
 * DayOfWeek enumerates the names of the days of the week starting with Sunday. 
 *
 * @author Jean-Paul Vetterli
 * @version 1.0.0
 */
public enum DayOfWeek {
	/**
	 * Sunday, day 0. 
	 */
	Sun, 
	/**
	 * Monday, day 1.
	 */
	Mon, /**
	 * Tuesday, day 2.
	 */
	Tue, /**
	 * Wednesday, day 3.
	 */
	Wed, /**
	 * Thursday, day 4.
	 */
	Thu, /**
	 * Friday, day 5.
	 */
	Fri, /**
	 * Saturday, day 6.
	 */
	Sat
}
