/*
 * Decompiled with CFR 0.152.
 */
package ch.agent.crnickl.impl;

import ch.agent.crnickl.T2DBException;
import ch.agent.crnickl.T2DBMsg;
import ch.agent.crnickl.api.Surrogate;
import ch.agent.crnickl.api.UpdatableValueType;
import ch.agent.crnickl.impl.ValueTypeImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class UpdatableValueTypeImpl<T>
extends ValueTypeImpl<T>
implements UpdatableValueType<T> {
    private boolean delete;
    private String name;
    private Map<T, String> values;

    protected UpdatableValueTypeImpl(ValueTypeImpl<T> valueType) throws T2DBException {
        super(valueType);
    }

    public UpdatableValueTypeImpl(String name, boolean restricted, String scannerClassOrKeyword, Map<String, String> valuesAndDescriptions, Surrogate surrogate) throws T2DBException {
        super(name, restricted, scannerClassOrKeyword, valuesAndDescriptions, surrogate);
    }

    @Override
    protected void update() throws T2DBException {
        this.name = null;
        this.values = null;
        super.update();
    }

    @Override
    public void applyUpdates() throws T2DBException {
        if (this.delete) {
            this.getDatabase().getCache().clear(this);
            this.getDatabase().deleteValueType(this);
            this.delete = false;
        } else {
            if (this.getSurrogate().inConstruction()) {
                this.getDatabase().create(this);
            } else if (this.name != null || this.values != null) {
                this.getDatabase().getCache().clear(this);
                this.getDatabase().update(this);
            }
            this.update();
        }
    }

    @Override
    public UpdatableValueType<T> edit() {
        return this;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.getName();
    }

    @Override
    public void setName(String name) throws T2DBException {
        if (this.delete) {
            throw T2DBMsg.exception("D10120", this.getName());
        }
        this.name = name;
    }

    @Override
    public Set<T> getValues() {
        return this.getValueDescriptions().keySet();
    }

    @Override
    public Map<T, String> getValueDescriptions() {
        if (this.values != null) {
            return this.values;
        }
        return super.getValueDescriptions();
    }

    @Override
    public void addValue(T value, String description) throws T2DBException {
        if (!this.isRestricted()) {
            throw T2DBMsg.exception("D10108", this.getName());
        }
        if (value == null) {
            throw new IllegalArgumentException("value null");
        }
        if (this.delete) {
            throw T2DBMsg.exception("D10120", this.getName());
        }
        if (this.getValues().contains(value)) {
            throw T2DBMsg.exception("D10121", this.getName(), value);
        }
        if (this.values == null) {
            this.values = new HashMap(super.getValueDescriptions());
        }
        this.values.put(value, description);
    }

    @Override
    public void updateValue(T value, String description) throws T2DBException {
        if (!this.isRestricted()) {
            throw T2DBMsg.exception("D10108", this.getName());
        }
        if (value == null) {
            throw new IllegalArgumentException("value null");
        }
        if (this.delete) {
            throw T2DBMsg.exception("D10120", this.getName());
        }
        if (!this.getValues().contains(value)) {
            throw T2DBMsg.exception("D10123", this.getName(), value);
        }
        if (this.values == null) {
            this.values = new HashMap(super.getValueDescriptions());
        }
        this.values.put(value, description);
    }

    @Override
    public void deleteValue(T value) throws T2DBException {
        if (!this.isRestricted()) {
            throw T2DBMsg.exception("D10108", this.getName());
        }
        if (this.delete) {
            throw T2DBMsg.exception("D10120", this.getName());
        }
        if (value == null || !this.getValues().contains(value)) {
            throw T2DBMsg.exception("D10122", this.getName(), value);
        }
        if (this.values == null) {
            this.values = new HashMap(super.getValueDescriptions());
        }
        this.values.remove(value);
    }

    @Override
    public void destroy() throws T2DBException {
        if (this.name != null || this.values != null) {
            throw T2DBMsg.exception("D10119", this.getName());
        }
        this.delete = true;
    }
}

